/*
 * Decompiled with CFR 0.152.
 */
package com.roughike.bottombar.scrollsweetness;

import android.support.design.widget.CoordinatorLayout;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.support.v4.view.animation.LinearOutSlowInInterpolator;
import android.view.View;
import android.view.animation.Interpolator;
import com.roughike.bottombar.scrollsweetness.VerticalScrollingBehavior;

public class BottomNavigationBehavior<V extends View>
extends VerticalScrollingBehavior<V> {
    private static final Interpolator INTERPOLATOR = new LinearOutSlowInInterpolator();
    private final int mBottomNavHeight;
    private final int mDefaultOffset;
    private ViewPropertyAnimatorCompat mTranslationAnimator;
    private boolean hidden = false;

    public BottomNavigationBehavior(int bottomNavHeight, int defaultOffset) {
        this.mBottomNavHeight = bottomNavHeight;
        this.mDefaultOffset = defaultOffset;
    }

    @Override
    public void onNestedVerticalOverScroll(CoordinatorLayout coordinatorLayout, V child, int direction, int currentOverScroll, int totalOverScroll) {
    }

    @Override
    public void onDirectionNestedPreScroll(CoordinatorLayout coordinatorLayout, V child, View target, int dx, int dy, int[] consumed, int scrollDirection) {
        this.handleDirection(child, scrollDirection);
    }

    private void handleDirection(V child, int scrollDirection) {
        if (scrollDirection == -1 && this.hidden) {
            this.hidden = false;
            this.animateOffset(child, this.mDefaultOffset);
        } else if (scrollDirection == 1 && !this.hidden) {
            this.hidden = true;
            this.animateOffset(child, this.mBottomNavHeight + this.mDefaultOffset);
        }
    }

    @Override
    protected boolean onNestedDirectionFling(CoordinatorLayout coordinatorLayout, V child, View target, float velocityX, float velocityY, int scrollDirection) {
        this.handleDirection(child, scrollDirection);
        return true;
    }

    private void animateOffset(V child, int offset) {
        this.ensureOrCancelAnimator(child);
        this.mTranslationAnimator.translationY((float)offset).start();
    }

    private void ensureOrCancelAnimator(V child) {
        if (this.mTranslationAnimator == null) {
            this.mTranslationAnimator = ViewCompat.animate(child);
            this.mTranslationAnimator.setDuration(300L);
            this.mTranslationAnimator.setInterpolator(INTERPOLATOR);
        } else {
            this.mTranslationAnimator.cancel();
        }
    }
}

