/*
 * Decompiled with CFR 0.152.
 */
package com.roughike.bottombar;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.IdRes;
import android.support.annotation.MenuRes;
import android.support.annotation.StyleRes;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.Display;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.roughike.bottombar.BottomBarBadge;
import com.roughike.bottombar.BottomBarFragment;
import com.roughike.bottombar.BottomBarItemBase;
import com.roughike.bottombar.BottomBarTab;
import com.roughike.bottombar.MiscUtils;
import com.roughike.bottombar.OnMenuTabClickListener;
import com.roughike.bottombar.OnMenuTabSelectedListener;
import com.roughike.bottombar.OnSizeDeterminedListener;
import com.roughike.bottombar.OnTabClickListener;
import com.roughike.bottombar.OnTabSelectedListener;
import com.roughike.bottombar.R;
import com.roughike.bottombar.scrollsweetness.BottomNavigationBehavior;
import java.util.HashMap;

public class BottomBar
extends FrameLayout
implements View.OnClickListener,
View.OnLongClickListener {
    private static final long ANIMATION_DURATION = 150L;
    private static final int MAX_FIXED_TAB_COUNT = 3;
    private static final String STATE_CURRENT_SELECTED_TAB = "STATE_CURRENT_SELECTED_TAB";
    private static final String STATE_BADGE_STATES_BUNDLE = "STATE_BADGE_STATES_BUNDLE";
    private static final String TAG_BOTTOM_BAR_VIEW_INACTIVE = "BOTTOM_BAR_VIEW_INACTIVE";
    private static final String TAG_BOTTOM_BAR_VIEW_ACTIVE = "BOTTOM_BAR_VIEW_ACTIVE";
    private static final String TAG_BADGE = "BOTTOMBAR_BADGE_";
    private Context mContext;
    private boolean mIsComingFromRestoredState;
    private boolean mIgnoreTabletLayout;
    private boolean mIsTabletMode;
    private boolean mIsShy;
    private boolean mShyHeightAlreadyCalculated;
    private boolean mUseExtraOffset;
    private ViewGroup mUserContentContainer;
    private ViewGroup mOuterContainer;
    private ViewGroup mItemContainer;
    private View mBackgroundView;
    private View mBackgroundOverlay;
    private View mShadowView;
    private View mTabletRightBorder;
    private View mPendingUserContentView;
    private int mPrimaryColor;
    private int mInActiveColor;
    private int mDarkBackgroundColor;
    private int mWhiteColor;
    private int mScreenWidth;
    private int mTwoDp;
    private int mTenDp;
    private int mMaxFixedItemWidth;
    private Object mListener;
    private Object mMenuListener;
    private int mCurrentTabPosition;
    private boolean mIsShiftingMode;
    private Object mFragmentManager;
    private int mFragmentContainer;
    private BottomBarItemBase[] mItems;
    private HashMap<Integer, Integer> mColorMap;
    private HashMap<Integer, Object> mBadgeMap;
    private HashMap<Integer, Boolean> mBadgeStateMap;
    private int mCurrentBackgroundColor;
    private int mDefaultBackgroundColor;
    private boolean mIsDarkTheme;
    private boolean mIgnoreNightMode;
    private int mCustomActiveTabColor;
    private boolean mDrawBehindNavBar = true;
    private boolean mUseTopOffset = true;
    private boolean mUseOnlyStatusBarOffset;
    private int mPendingTextAppearance = -1;
    private Typeface mPendingTypeface;
    private boolean mShouldUpdateFragmentInitially;

    public static BottomBar attach(Activity activity, Bundle savedInstanceState) {
        BottomBar bottomBar = new BottomBar((Context)activity);
        bottomBar.onRestoreInstanceState(savedInstanceState);
        ViewGroup contentView = (ViewGroup)activity.findViewById(0x1020002);
        View oldLayout = contentView.getChildAt(0);
        contentView.removeView(oldLayout);
        bottomBar.setPendingUserContentView(oldLayout);
        contentView.addView((View)bottomBar, 0);
        return bottomBar;
    }

    private void setPendingUserContentView(View oldLayout) {
        this.mPendingUserContentView = oldLayout;
    }

    public static BottomBar attach(View view, Bundle savedInstanceState) {
        BottomBar bottomBar = new BottomBar(view.getContext());
        bottomBar.onRestoreInstanceState(savedInstanceState);
        ViewGroup contentView = (ViewGroup)view.getParent();
        if (contentView != null) {
            View oldLayout = contentView.getChildAt(0);
            contentView.removeView(oldLayout);
            bottomBar.setPendingUserContentView(oldLayout);
            contentView.addView((View)bottomBar, 0);
        } else {
            bottomBar.setPendingUserContentView(view);
        }
        return bottomBar;
    }

    @Deprecated
    public static BottomBar attachShy(CoordinatorLayout coordinatorLayout, Bundle savedInstanceState) {
        return BottomBar.attachShy(coordinatorLayout, null, savedInstanceState);
    }

    public static BottomBar attachShy(CoordinatorLayout coordinatorLayout, View userContentView, Bundle savedInstanceState) {
        BottomBar bottomBar = new BottomBar(coordinatorLayout.getContext());
        bottomBar.toughChildHood(ViewCompat.getFitsSystemWindows((View)coordinatorLayout));
        bottomBar.onRestoreInstanceState(savedInstanceState);
        if (userContentView != null && coordinatorLayout.getContext().getResources().getBoolean(R.bool.bb_bottom_bar_is_tablet_mode)) {
            bottomBar.setPendingUserContentView(userContentView);
        }
        coordinatorLayout.addView((View)bottomBar);
        return bottomBar;
    }

    public void setFragmentItems(android.app.FragmentManager fragmentManager, @IdRes int containerResource, BottomBarFragment ... fragmentItems) {
        if (fragmentItems.length > 0) {
            int index = 0;
            for (BottomBarFragment fragmentItem : fragmentItems) {
                if (fragmentItem.getFragment() == null && fragmentItem.getSupportFragment() != null) {
                    throw new IllegalArgumentException("Conflict: cannot use android.app.FragmentManager to handle a android.support.v4.app.Fragment object at position " + index + ". If you want BottomBar to handle support Fragments, use getSupportFragment" + "Manager() instead of getFragmentManager().");
                }
                ++index;
            }
        }
        this.clearItems();
        this.mFragmentManager = fragmentManager;
        this.mFragmentContainer = containerResource;
        this.mItems = fragmentItems;
        this.updateItems(this.mItems);
    }

    public void setFragmentItems(FragmentManager fragmentManager, @IdRes int containerResource, BottomBarFragment ... fragmentItems) {
        if (fragmentItems.length > 0) {
            int index = 0;
            for (BottomBarFragment fragmentItem : fragmentItems) {
                if (fragmentItem.getSupportFragment() == null && fragmentItem.getFragment() != null) {
                    throw new IllegalArgumentException("Conflict: cannot use android.support.v4.app.FragmentManager to handle a android.app.Fragment object at position " + index + ". If you want BottomBar to handle normal Fragments, use getFragment" + "Manager() instead of getSupportFragmentManager().");
                }
                ++index;
            }
        }
        this.clearItems();
        this.mFragmentManager = fragmentManager;
        this.mFragmentContainer = containerResource;
        this.mItems = fragmentItems;
        this.updateItems(this.mItems);
    }

    public void setItems(BottomBarTab ... bottomBarTabs) {
        this.clearItems();
        this.mItems = bottomBarTabs;
        this.updateItems(this.mItems);
    }

    @Deprecated
    public void setItemsFromMenu(@MenuRes int menuRes, OnMenuTabSelectedListener listener) {
        this.clearItems();
        this.mItems = MiscUtils.inflateMenuFromResource((Activity)this.getContext(), menuRes);
        this.mMenuListener = listener;
        this.updateItems(this.mItems);
    }

    public void setItemsFromMenu(@MenuRes int menuRes, OnMenuTabClickListener listener) {
        this.clearItems();
        this.mItems = MiscUtils.inflateMenuFromResource((Activity)this.getContext(), menuRes);
        this.mMenuListener = listener;
        this.updateItems(this.mItems);
    }

    @Deprecated
    public void setOnItemSelectedListener(OnTabSelectedListener listener) {
        this.mListener = listener;
    }

    public void setOnTabClickListener(OnTabClickListener listener) {
        this.mListener = listener;
    }

    public void selectTabAtPosition(int position, boolean animate) {
        if (this.mItems == null || this.mItems.length == 0) {
            throw new UnsupportedOperationException("Can't select tab at position " + position + ". This BottomBar has no items set yet.");
        }
        if (position > this.mItems.length - 1 || position < 0) {
            throw new IndexOutOfBoundsException("Can't select tab at position " + position + ". This BottomBar has no items at that position.");
        }
        this.unselectTab(this.mItemContainer.findViewWithTag((Object)TAG_BOTTOM_BAR_VIEW_ACTIVE), animate);
        this.selectTab(this.mItemContainer.getChildAt(position), animate);
        this.updateSelectedTab(position);
    }

    public void setDefaultTabPosition(int defaultTabPosition) {
        if (this.mItems == null || this.mItems.length == 0) {
            throw new UnsupportedOperationException("Can't set default tab at position " + defaultTabPosition + ". This BottomBar has no items set yet.");
        }
        if (defaultTabPosition > this.mItems.length - 1 || defaultTabPosition < 0) {
            throw new IndexOutOfBoundsException("Can't set default tab at position " + defaultTabPosition + ". This BottomBar has no items at that position.");
        }
        if (!this.mIsComingFromRestoredState) {
            this.selectTabAtPosition(defaultTabPosition, false);
        }
    }

    public int getCurrentTabPosition() {
        return this.mCurrentTabPosition;
    }

    public void hide() {
        this.setBarVisibility(8);
    }

    public void show() {
        this.setBarVisibility(0);
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putInt(STATE_CURRENT_SELECTED_TAB, this.mCurrentTabPosition);
        if (this.mBadgeMap != null && this.mBadgeMap.size() > 0) {
            if (this.mBadgeStateMap == null) {
                this.mBadgeStateMap = new HashMap();
            }
            for (Integer key : this.mBadgeMap.keySet()) {
                BottomBarBadge badgeCandidate = (BottomBarBadge)this.mOuterContainer.findViewWithTag(this.mBadgeMap.get(key));
                if (badgeCandidate == null) continue;
                this.mBadgeStateMap.put(key, badgeCandidate.isVisible());
            }
            outState.putSerializable(STATE_BADGE_STATES_BUNDLE, this.mBadgeStateMap);
        }
        if (this.mFragmentManager != null && this.mFragmentContainer != 0 && this.mItems != null && this.mItems instanceof BottomBarFragment[]) {
            BottomBarFragment bottomBarFragment = (BottomBarFragment)this.mItems[this.mCurrentTabPosition];
            if (bottomBarFragment.getFragment() != null) {
                bottomBarFragment.getFragment().onSaveInstanceState(outState);
            } else if (bottomBarFragment.getSupportFragment() != null) {
                bottomBarFragment.getSupportFragment().onSaveInstanceState(outState);
            }
        }
    }

    public void mapColorForTab(int tabPosition, int color2) {
        if (this.mItems == null || this.mItems.length == 0) {
            throw new UnsupportedOperationException("You have no BottomBar Tabs set yet. Please set them first before calling the mapColorForTab method.");
        }
        if (tabPosition > this.mItems.length - 1 || tabPosition < 0) {
            throw new IndexOutOfBoundsException("Cant map color for Tab index " + tabPosition + ". You have no BottomBar Tabs at that position.");
        }
        if (!this.mIsShiftingMode || this.mIsTabletMode) {
            return;
        }
        if (this.mColorMap == null) {
            this.mColorMap = new HashMap();
        }
        if (tabPosition == this.mCurrentTabPosition && this.mCurrentBackgroundColor != color2) {
            this.mCurrentBackgroundColor = color2;
            this.mBackgroundView.setBackgroundColor(color2);
        }
        this.mColorMap.put(tabPosition, color2);
    }

    public void mapColorForTab(int tabPosition, String color2) {
        this.mapColorForTab(tabPosition, Color.parseColor((String)color2));
    }

    public void useDarkTheme(boolean darkThemeEnabled) {
        if (!this.mIsDarkTheme && darkThemeEnabled && this.mItems != null && this.mItems.length > 0) {
            this.darkThemeMagic();
            for (int i = 0; i < this.mItemContainer.getChildCount(); ++i) {
                View bottomBarTab = this.mItemContainer.getChildAt(i);
                ((ImageView)bottomBarTab.findViewById(R.id.bb_bottom_bar_icon)).setColorFilter(this.mWhiteColor);
                if (i == this.mCurrentTabPosition) {
                    this.selectTab(bottomBarTab, false);
                    continue;
                }
                this.unselectTab(bottomBarTab, false);
            }
        }
        this.mIsDarkTheme = darkThemeEnabled;
    }

    public void ignoreNightMode() {
        if (this.mItems != null && this.mItems.length > 0) {
            throw new UnsupportedOperationException("This BottomBar already has items! You must call ignoreNightMode() before setting any items.");
        }
        this.mIgnoreNightMode = true;
    }

    public void setActiveTabColor(String activeTabColor) {
        this.setActiveTabColor(Color.parseColor((String)activeTabColor));
    }

    public void setActiveTabColor(int activeTabColor) {
        this.mCustomActiveTabColor = activeTabColor;
        if (this.mItems != null && this.mItems.length > 0) {
            this.selectTabAtPosition(this.mCurrentTabPosition, false);
        }
    }

    public BottomBarBadge makeBadgeForTabAt(int tabPosition, String backgroundColor, int initialCount) {
        return this.makeBadgeForTabAt(tabPosition, Color.parseColor((String)backgroundColor), initialCount);
    }

    public BottomBarBadge makeBadgeForTabAt(int tabPosition, int backgroundColor, int initialCount) {
        if (this.mItems == null || this.mItems.length == 0) {
            throw new UnsupportedOperationException("You have no BottomBar Tabs set yet. Please set them first before calling the makeBadgeForTabAt() method.");
        }
        if (tabPosition > this.mItems.length - 1 || tabPosition < 0) {
            throw new IndexOutOfBoundsException("Cant make a Badge for Tab index " + tabPosition + ". You have no BottomBar Tabs at that position.");
        }
        BottomBarBadge badge = new BottomBarBadge(this.mContext, this.mItemContainer.getChildAt(tabPosition), backgroundColor);
        badge.setTag(TAG_BADGE + tabPosition);
        badge.setCount(initialCount);
        if (this.mBadgeMap == null) {
            this.mBadgeMap = new HashMap();
        }
        this.mBadgeMap.put(tabPosition, badge.getTag());
        this.mOuterContainer.addView((View)badge);
        boolean canShow = true;
        if (this.mIsComingFromRestoredState && this.mBadgeStateMap != null && this.mBadgeStateMap.containsKey(tabPosition)) {
            canShow = this.mBadgeStateMap.get(tabPosition);
        }
        if (canShow && this.mCurrentTabPosition != tabPosition && initialCount != 0) {
            badge.show();
        } else {
            badge.hide();
        }
        return badge;
    }

    public void setTypeFace(String typeFacePath) {
        Typeface typeface = Typeface.createFromAsset((AssetManager)this.mContext.getAssets(), (String)typeFacePath);
        if (this.mItemContainer != null && this.mItemContainer.getChildCount() > 0) {
            for (int i = 0; i < this.mItemContainer.getChildCount(); ++i) {
                View bottomBarTab = this.mItemContainer.getChildAt(i);
                TextView title = (TextView)bottomBarTab.findViewById(R.id.bb_bottom_bar_title);
                title.setTypeface(typeface);
            }
        } else {
            this.mPendingTypeface = typeface;
        }
    }

    public void setTextAppearance(@StyleRes int resId) {
        if (this.mItemContainer != null && this.mItemContainer.getChildCount() > 0) {
            for (int i = 0; i < this.mItemContainer.getChildCount(); ++i) {
                View bottomBarTab = this.mItemContainer.getChildAt(i);
                TextView title = (TextView)bottomBarTab.findViewById(R.id.bb_bottom_bar_title);
                MiscUtils.setTextAppearance(title, resId);
            }
        } else {
            this.mPendingTextAppearance = resId;
        }
    }

    public void hideShadow() {
        if (this.mShadowView != null) {
            this.mShadowView.setVisibility(8);
        }
    }

    public void noNavBarGoodness() {
        if (this.mItems != null) {
            throw new UnsupportedOperationException("This BottomBar already has items! You must call noNavBarGoodness() before setting the items, preferably right after attaching it to your layout.");
        }
        this.mDrawBehindNavBar = false;
    }

    public void noTabletGoodness() {
        if (this.mItems != null) {
            throw new UnsupportedOperationException("This BottomBar already has items! You must call noTabletGoodness() before setting the items, preferably right after attaching it to your layout.");
        }
        this.mIgnoreTabletLayout = true;
    }

    public void getBarSize(final OnSizeDeterminedListener listener) {
        int sizeCandidate;
        int n = sizeCandidate = this.mIsTabletMode ? this.mOuterContainer.getWidth() : this.mOuterContainer.getHeight();
        if (sizeCandidate == 0) {
            this.mOuterContainer.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    listener.onSizeReady(BottomBar.this.mIsTabletMode ? BottomBar.this.mOuterContainer.getWidth() : BottomBar.this.mOuterContainer.getHeight());
                    ViewTreeObserver obs = BottomBar.this.mOuterContainer.getViewTreeObserver();
                    if (Build.VERSION.SDK_INT >= 16) {
                        obs.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        obs.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                }
            });
            return;
        }
        listener.onSizeReady(sizeCandidate);
    }

    public View getBar() {
        return this.mOuterContainer;
    }

    public void noTopOffset() {
        this.mUseTopOffset = false;
    }

    public void useOnlyStatusBarTopOffset() {
        this.mUseOnlyStatusBarOffset = true;
    }

    public BottomBar(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public BottomBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public BottomBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public BottomBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mContext = context;
        this.mDarkBackgroundColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.bb_darkBackgroundColor);
        this.mWhiteColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.white);
        this.mPrimaryColor = MiscUtils.getColor(this.getContext(), R.attr.colorPrimary);
        this.mInActiveColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.bb_inActiveBottomBarItemColor);
        this.mScreenWidth = MiscUtils.getScreenWidth(this.mContext);
        this.mTwoDp = MiscUtils.dpToPixel(this.mContext, 2.0f);
        this.mTenDp = MiscUtils.dpToPixel(this.mContext, 10.0f);
        this.mMaxFixedItemWidth = MiscUtils.dpToPixel(this.mContext, 168.0f);
    }

    private void initializeViews() {
        this.mIsTabletMode = !this.mIgnoreTabletLayout && this.mContext.getResources().getBoolean(R.bool.bb_bottom_bar_is_tablet_mode);
        View rootView = View.inflate((Context)this.mContext, (int)(this.mIsTabletMode ? R.layout.bb_bottom_bar_item_container_tablet : R.layout.bb_bottom_bar_item_container), null);
        this.mTabletRightBorder = rootView.findViewById(R.id.bb_tablet_right_border);
        this.mUserContentContainer = (ViewGroup)rootView.findViewById(R.id.bb_user_content_container);
        this.mShadowView = rootView.findViewById(R.id.bb_bottom_bar_shadow);
        this.mOuterContainer = (ViewGroup)rootView.findViewById(R.id.bb_bottom_bar_outer_container);
        this.mItemContainer = (ViewGroup)rootView.findViewById(R.id.bb_bottom_bar_item_container);
        this.mBackgroundView = rootView.findViewById(R.id.bb_bottom_bar_background_view);
        this.mBackgroundOverlay = rootView.findViewById(R.id.bb_bottom_bar_background_overlay);
        if (this.mIsShy && this.mIgnoreTabletLayout) {
            this.mPendingUserContentView = null;
        }
        if (this.mPendingUserContentView != null) {
            ViewGroup.LayoutParams params = this.mPendingUserContentView.getLayoutParams();
            if (params == null) {
                params = new ViewGroup.LayoutParams(-1, -1);
            }
            if (this.mIsTabletMode && this.mIsShy) {
                ((ViewGroup)this.mPendingUserContentView.getParent()).removeView(this.mPendingUserContentView);
            }
            this.mUserContentContainer.addView(this.mPendingUserContentView, 0, params);
            this.mPendingUserContentView = null;
        }
        if (this.mIsShy && !this.mIsTabletMode) {
            this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    if (!BottomBar.this.mShyHeightAlreadyCalculated) {
                        ((CoordinatorLayout.LayoutParams)BottomBar.this.getLayoutParams()).setBehavior(new BottomNavigationBehavior(BottomBar.this.getOuterContainer().getHeight(), 0));
                    }
                    ViewTreeObserver obs = BottomBar.this.getViewTreeObserver();
                    if (Build.VERSION.SDK_INT >= 16) {
                        obs.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        obs.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                }
            });
        }
        this.addView(rootView);
    }

    private void toughChildHood(boolean useExtraOffset) {
        this.mIsShy = true;
        this.mUseExtraOffset = useExtraOffset;
    }

    protected boolean isShy() {
        return this.mIsShy;
    }

    protected void shyHeightAlreadyCalculated() {
        this.mShyHeightAlreadyCalculated = true;
    }

    protected boolean useExtraOffset() {
        return this.mUseExtraOffset;
    }

    protected ViewGroup getUserContainer() {
        return this.mUserContentContainer;
    }

    protected View getOuterContainer() {
        return this.mOuterContainer;
    }

    protected boolean drawBehindNavBar() {
        return this.mDrawBehindNavBar;
    }

    protected boolean useTopOffset() {
        return this.mUseTopOffset;
    }

    protected boolean useOnlyStatusbarOffset() {
        return this.mUseOnlyStatusBarOffset;
    }

    protected void setBarVisibility(int visibility) {
        if (this.mOuterContainer != null) {
            this.mOuterContainer.setVisibility(visibility);
        }
        if (this.mBackgroundView != null) {
            this.mBackgroundView.setVisibility(visibility);
        }
        if (this.mBackgroundOverlay != null) {
            this.mBackgroundOverlay.setVisibility(visibility);
        }
    }

    public void onClick(View v) {
        if (v.getTag().equals(TAG_BOTTOM_BAR_VIEW_INACTIVE)) {
            this.unselectTab(this.findViewWithTag(TAG_BOTTOM_BAR_VIEW_ACTIVE), true);
            this.selectTab(v, true);
        }
        this.updateSelectedTab(this.findItemPosition(v));
    }

    private void updateSelectedTab(int newPosition) {
        boolean notifyRegularListener;
        boolean notifyMenuListener = this.mMenuListener != null && this.mItems instanceof BottomBarTab[];
        boolean bl = notifyRegularListener = this.mListener != null;
        if (newPosition != this.mCurrentTabPosition) {
            this.handleBadgeVisibility(this.mCurrentTabPosition, newPosition);
            this.mCurrentTabPosition = newPosition;
            if (notifyRegularListener) {
                this.notifyRegularListener(this.mListener, false, this.mCurrentTabPosition);
            }
            if (notifyMenuListener) {
                this.notifyMenuListener(this.mMenuListener, false, ((BottomBarTab)this.mItems[this.mCurrentTabPosition]).id);
            }
            this.updateCurrentFragment();
        } else {
            if (notifyRegularListener) {
                this.notifyRegularListener(this.mListener, true, this.mCurrentTabPosition);
            }
            if (notifyMenuListener) {
                this.notifyMenuListener(this.mMenuListener, true, ((BottomBarTab)this.mItems[this.mCurrentTabPosition]).id);
            }
        }
    }

    private void notifyRegularListener(Object listener, boolean isReselection, int position) {
        if (listener instanceof OnTabClickListener) {
            OnTabClickListener onTabClickListener = (OnTabClickListener)listener;
            if (!isReselection) {
                onTabClickListener.onTabSelected(position);
            } else {
                onTabClickListener.onTabReSelected(position);
            }
        } else if (listener instanceof OnTabSelectedListener) {
            OnTabSelectedListener onTabSelectedListener = (OnTabSelectedListener)listener;
            if (!isReselection) {
                onTabSelectedListener.onItemSelected(position);
            }
        }
    }

    private void notifyMenuListener(Object listener, boolean isReselection, @IdRes int menuItemId) {
        if (listener instanceof OnMenuTabClickListener) {
            OnMenuTabClickListener onMenuTabClickListener = (OnMenuTabClickListener)listener;
            if (!isReselection) {
                onMenuTabClickListener.onMenuTabSelected(menuItemId);
            } else {
                onMenuTabClickListener.onMenuTabReSelected(menuItemId);
            }
        } else if (listener instanceof OnMenuTabSelectedListener) {
            OnMenuTabSelectedListener onMenuTabSelectedListener = (OnMenuTabSelectedListener)listener;
            if (!isReselection) {
                onMenuTabSelectedListener.onMenuItemSelected(menuItemId);
            }
        }
    }

    private void handleBadgeVisibility(int oldPosition, int newPosition) {
        if (this.mBadgeMap == null) {
            return;
        }
        if (this.mBadgeMap.containsKey(oldPosition)) {
            BottomBarBadge oldBadge = (BottomBarBadge)this.mOuterContainer.findViewWithTag(this.mBadgeMap.get(oldPosition));
            if (oldBadge.getAutoShowAfterUnSelection()) {
                oldBadge.show();
            } else {
                oldBadge.hide();
            }
        }
        if (this.mBadgeMap.containsKey(newPosition)) {
            BottomBarBadge newBadge = (BottomBarBadge)this.mOuterContainer.findViewWithTag(this.mBadgeMap.get(newPosition));
            newBadge.hide();
        }
    }

    public boolean onLongClick(View v) {
        if ((this.mIsShiftingMode || this.mIsTabletMode) && v.getTag().equals(TAG_BOTTOM_BAR_VIEW_INACTIVE)) {
            Toast.makeText((Context)this.mContext, (CharSequence)this.mItems[this.findItemPosition(v)].getTitle(this.mContext), (int)0).show();
        }
        return true;
    }

    private void updateItems(BottomBarItemBase[] bottomBarItems) {
        if (this.mItemContainer == null) {
            this.initializeViews();
        }
        int index = 0;
        int biggestWidth = 0;
        boolean bl = this.mIsShiftingMode = 3 < bottomBarItems.length;
        if (!this.mIsDarkTheme && !this.mIgnoreNightMode && MiscUtils.isNightMode(this.mContext)) {
            this.mIsDarkTheme = true;
        }
        if (!this.mIsTabletMode && this.mIsShiftingMode) {
            this.mDefaultBackgroundColor = this.mCurrentBackgroundColor = this.mPrimaryColor;
            this.mBackgroundView.setBackgroundColor(this.mDefaultBackgroundColor);
            if (this.mContext instanceof Activity) {
                BottomBar.navBarMagic((Activity)this.mContext, this);
            }
        } else if (this.mIsDarkTheme) {
            this.darkThemeMagic();
        }
        View[] viewsToAdd = new View[bottomBarItems.length];
        for (BottomBarItemBase bottomBarItemBase : bottomBarItems) {
            int layoutResource = this.mIsShiftingMode && !this.mIsTabletMode ? R.layout.bb_bottom_bar_item_shifting : (this.mIsTabletMode ? R.layout.bb_bottom_bar_item_fixed_tablet : R.layout.bb_bottom_bar_item_fixed);
            View bottomBarTab = View.inflate((Context)this.mContext, (int)layoutResource, null);
            ImageView icon = (ImageView)bottomBarTab.findViewById(R.id.bb_bottom_bar_icon);
            icon.setImageDrawable(bottomBarItemBase.getIcon(this.mContext));
            if (!this.mIsTabletMode) {
                TextView title = (TextView)bottomBarTab.findViewById(R.id.bb_bottom_bar_title);
                title.setText((CharSequence)bottomBarItemBase.getTitle(this.mContext));
                if (this.mPendingTextAppearance != -1) {
                    MiscUtils.setTextAppearance(title, this.mPendingTextAppearance);
                }
                if (this.mPendingTypeface != null) {
                    title.setTypeface(this.mPendingTypeface);
                }
            }
            if (this.mIsDarkTheme || !this.mIsTabletMode && this.mIsShiftingMode) {
                icon.setColorFilter(this.mWhiteColor);
            }
            if (bottomBarItemBase instanceof BottomBarTab) {
                bottomBarTab.setId(((BottomBarTab)bottomBarItemBase).id);
            }
            if (index == this.mCurrentTabPosition) {
                this.selectTab(bottomBarTab, false);
            } else {
                this.unselectTab(bottomBarTab, false);
            }
            if (!this.mIsTabletMode) {
                if (bottomBarTab.getWidth() > biggestWidth) {
                    biggestWidth = bottomBarTab.getWidth();
                }
                viewsToAdd[index] = bottomBarTab;
            } else {
                this.mItemContainer.addView(bottomBarTab);
            }
            bottomBarTab.setOnClickListener((View.OnClickListener)this);
            bottomBarTab.setOnLongClickListener((View.OnLongClickListener)this);
            ++index;
        }
        if (!this.mIsTabletMode) {
            int proposedItemWidth = Math.min(MiscUtils.dpToPixel(this.mContext, this.mScreenWidth / bottomBarItems.length), this.mMaxFixedItemWidth);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(proposedItemWidth, -2);
            for (View bottomBarView : viewsToAdd) {
                bottomBarView.setLayoutParams((ViewGroup.LayoutParams)params);
                this.mItemContainer.addView(bottomBarView);
            }
        }
        this.updateCurrentFragment();
        if (this.mPendingTextAppearance != -1) {
            this.mPendingTextAppearance = -1;
        }
        if (this.mPendingTypeface != null) {
            this.mPendingTypeface = null;
        }
    }

    private void darkThemeMagic() {
        if (!this.mIsTabletMode) {
            this.mBackgroundView.setBackgroundColor(this.mDarkBackgroundColor);
        } else {
            this.mItemContainer.setBackgroundColor(this.mDarkBackgroundColor);
            this.mTabletRightBorder.setBackgroundColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.bb_tabletRightBorderDark));
        }
    }

    private void onRestoreInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            this.mCurrentTabPosition = savedInstanceState.getInt(STATE_CURRENT_SELECTED_TAB, -1);
            this.mBadgeStateMap = (HashMap)savedInstanceState.getSerializable(STATE_BADGE_STATES_BUNDLE);
            if (this.mCurrentTabPosition == -1) {
                this.mCurrentTabPosition = 0;
                Log.e((String)"BottomBar", (String)"You must override the Activity's onSaveInstanceState(Bundle outState) and call BottomBar.onSaveInstanceState(outState) there to restore the state properly.");
            }
            this.mIsComingFromRestoredState = true;
            this.mShouldUpdateFragmentInitially = true;
        }
    }

    private void selectTab(View tab, boolean animate) {
        int translationY;
        tab.setTag((Object)TAG_BOTTOM_BAR_VIEW_ACTIVE);
        ImageView icon = (ImageView)tab.findViewById(R.id.bb_bottom_bar_icon);
        TextView title = (TextView)tab.findViewById(R.id.bb_bottom_bar_title);
        int tabPosition = this.findItemPosition(tab);
        if (!this.mIsShiftingMode || this.mIsTabletMode) {
            int activeColor = this.mCustomActiveTabColor != 0 ? this.mCustomActiveTabColor : this.mPrimaryColor;
            icon.setColorFilter(activeColor);
            if (title != null) {
                title.setTextColor(activeColor);
            }
        }
        if (this.mIsDarkTheme) {
            if (title != null) {
                ViewCompat.setAlpha((View)title, (float)1.0f);
            }
            ViewCompat.setAlpha((View)icon, (float)1.0f);
        }
        if (title == null) {
            return;
        }
        int n = translationY = this.mIsShiftingMode ? this.mTenDp : this.mTwoDp;
        if (animate) {
            ViewCompat.animate((View)title).setDuration(150L).scaleX(1.0f).scaleY(1.0f).start();
            ViewCompat.animate((View)tab).setDuration(150L).translationY((float)(-translationY)).start();
            if (this.mIsShiftingMode) {
                ViewCompat.animate((View)icon).setDuration(150L).alpha(1.0f).start();
            }
            this.handleBackgroundColorChange(tabPosition, tab);
        } else {
            ViewCompat.setScaleX((View)title, (float)1.0f);
            ViewCompat.setScaleY((View)title, (float)1.0f);
            ViewCompat.setTranslationY((View)tab, (float)(-translationY));
            if (this.mIsShiftingMode) {
                ViewCompat.setAlpha((View)icon, (float)1.0f);
            }
        }
    }

    private void unselectTab(View tab, boolean animate) {
        float scale;
        tab.setTag((Object)TAG_BOTTOM_BAR_VIEW_INACTIVE);
        ImageView icon = (ImageView)tab.findViewById(R.id.bb_bottom_bar_icon);
        TextView title = (TextView)tab.findViewById(R.id.bb_bottom_bar_title);
        if (!this.mIsShiftingMode || this.mIsTabletMode) {
            int inActiveColor = this.mIsDarkTheme ? this.mWhiteColor : this.mInActiveColor;
            icon.setColorFilter(inActiveColor);
            if (title != null) {
                title.setTextColor(inActiveColor);
            }
        }
        if (this.mIsDarkTheme) {
            if (title != null) {
                ViewCompat.setAlpha((View)title, (float)0.6f);
            }
            ViewCompat.setAlpha((View)icon, (float)0.6f);
        }
        if (title == null) {
            return;
        }
        float f = scale = this.mIsShiftingMode ? 0.0f : 0.86f;
        if (animate) {
            ViewCompat.animate((View)title).setDuration(150L).scaleX(scale).scaleY(scale).start();
            ViewCompat.animate((View)tab).setDuration(150L).translationY(0.0f).start();
            if (this.mIsShiftingMode) {
                ViewCompat.animate((View)icon).setDuration(150L).alpha(0.6f).start();
            }
        } else {
            ViewCompat.setScaleX((View)title, (float)scale);
            ViewCompat.setScaleY((View)title, (float)scale);
            ViewCompat.setTranslationY((View)tab, (float)0.0f);
            if (this.mIsShiftingMode) {
                ViewCompat.setAlpha((View)icon, (float)0.6f);
            }
        }
    }

    private void handleBackgroundColorChange(int tabPosition, View tab) {
        if (!this.mIsShiftingMode || this.mIsTabletMode) {
            return;
        }
        if (this.mColorMap != null && this.mColorMap.containsKey(tabPosition)) {
            this.handleBackgroundColorChange(tab, this.mColorMap.get(tabPosition));
        } else {
            this.handleBackgroundColorChange(tab, this.mDefaultBackgroundColor);
        }
    }

    private void handleBackgroundColorChange(View tab, int color2) {
        MiscUtils.animateBGColorChange(tab, this.mBackgroundView, this.mBackgroundOverlay, color2);
        this.mCurrentBackgroundColor = color2;
    }

    private int findItemPosition(View viewToFind) {
        int position = 0;
        for (int i = 0; i < this.mItemContainer.getChildCount(); ++i) {
            View candidate = this.mItemContainer.getChildAt(i);
            if (!candidate.equals(viewToFind)) continue;
            position = i;
            break;
        }
        return position;
    }

    private void updateCurrentFragment() {
        if (!this.mShouldUpdateFragmentInitially && this.mFragmentManager != null && this.mFragmentContainer != 0 && this.mItems != null && this.mItems instanceof BottomBarFragment[]) {
            BottomBarFragment newFragment = (BottomBarFragment)this.mItems[this.mCurrentTabPosition];
            if (this.mFragmentManager instanceof FragmentManager && newFragment.getSupportFragment() != null) {
                ((FragmentManager)this.mFragmentManager).beginTransaction().replace(this.mFragmentContainer, newFragment.getSupportFragment()).commit();
            } else if (this.mFragmentManager instanceof android.app.FragmentManager && newFragment.getFragment() != null) {
                ((android.app.FragmentManager)this.mFragmentManager).beginTransaction().replace(this.mFragmentContainer, newFragment.getFragment()).commit();
            }
        }
        this.mShouldUpdateFragmentInitially = false;
    }

    private void clearItems() {
        int childCount;
        if (this.mItemContainer != null && (childCount = this.mItemContainer.getChildCount()) > 0) {
            for (int i = 0; i < childCount; ++i) {
                this.mItemContainer.removeView(this.mItemContainer.getChildAt(i));
            }
        }
        if (this.mFragmentManager != null) {
            this.mFragmentManager = null;
        }
        if (this.mFragmentContainer != 0) {
            this.mFragmentContainer = 0;
        }
        if (this.mItems != null) {
            this.mItems = null;
        }
    }

    private static void navBarMagic(Activity activity, final BottomBar bottomBar) {
        Resources res = activity.getResources();
        int softMenuIdentifier = res.getIdentifier("config_showNavigationBar", "bool", "android");
        int navBarIdentifier = res.getIdentifier("navigation_bar_height", "dimen", "android");
        int navBarHeight = 0;
        if (navBarIdentifier > 0) {
            navBarHeight = res.getDimensionPixelSize(navBarIdentifier);
        }
        if (!bottomBar.drawBehindNavBar() || navBarHeight == 0 || softMenuIdentifier <= 0 || !res.getBoolean(softMenuIdentifier)) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 14 && ViewConfiguration.get((Context)activity).hasPermanentMenuKey()) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 17) {
            boolean hasSoftwareKeys;
            Display d = activity.getWindowManager().getDefaultDisplay();
            DisplayMetrics realDisplayMetrics = new DisplayMetrics();
            d.getRealMetrics(realDisplayMetrics);
            int realHeight = realDisplayMetrics.heightPixels;
            int realWidth = realDisplayMetrics.widthPixels;
            DisplayMetrics displayMetrics = new DisplayMetrics();
            d.getMetrics(displayMetrics);
            int displayHeight = displayMetrics.heightPixels;
            int displayWidth = displayMetrics.widthPixels;
            boolean bl = hasSoftwareKeys = realWidth - displayWidth > 0 || realHeight - displayHeight > 0;
            if (!hasSoftwareKeys) {
                return;
            }
        }
        if (Build.VERSION.SDK_INT >= 19 && res.getConfiguration().orientation == 1) {
            activity.getWindow().getAttributes().flags |= 0x8000000;
            if (bottomBar.useTopOffset()) {
                int statusBarResource = res.getIdentifier("status_bar_height", "dimen", "android");
                int offset = statusBarResource > 0 ? res.getDimensionPixelSize(statusBarResource) : MiscUtils.dpToPixel((Context)activity, 25.0f);
                if (!bottomBar.useOnlyStatusbarOffset()) {
                    TypedValue tv = new TypedValue();
                    offset = activity.getTheme().resolveAttribute(16843499, tv, true) ? (offset += TypedValue.complexToDimensionPixelSize((int)tv.data, (DisplayMetrics)res.getDisplayMetrics())) : (offset += MiscUtils.dpToPixel((Context)activity, 56.0f));
                }
                bottomBar.getUserContainer().setPadding(0, offset, 0, 0);
            }
            final View outerContainer = bottomBar.getOuterContainer();
            final int navBarHeightCopy = navBarHeight;
            bottomBar.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    int newHeight;
                    bottomBar.shyHeightAlreadyCalculated();
                    outerContainer.getLayoutParams().height = newHeight = outerContainer.getHeight() + navBarHeightCopy;
                    if (bottomBar.isShy()) {
                        int defaultOffset = bottomBar.useExtraOffset() ? navBarHeightCopy : 0;
                        bottomBar.setTranslationY(defaultOffset);
                        ((CoordinatorLayout.LayoutParams)bottomBar.getLayoutParams()).setBehavior(new BottomNavigationBehavior(newHeight, defaultOffset));
                    }
                    ViewTreeObserver obs = outerContainer.getViewTreeObserver();
                    if (Build.VERSION.SDK_INT >= 16) {
                        obs.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        obs.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                }
            });
        }
    }
}

