/*
 * Decompiled with CFR 0.152.
 */
package com.roughike.bottombar;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.support.annotation.MenuRes;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.support.v4.view.ViewPropertyAnimatorListener;
import android.support.v4.view.ViewPropertyAnimatorListenerAdapter;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.widget.PopupMenu;
import android.widget.TextView;
import com.roughike.bottombar.BottomBarTab;
import com.roughike.bottombar.R;

class MiscUtils {
    MiscUtils() {
    }

    protected static int getColor(Context context, int color2) {
        TypedValue tv = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.colorPrimary, tv, true);
        return tv.data;
    }

    protected static int dpToPixel(Context context, float dp) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        return (int)(dp * ((float)metrics.densityDpi / 160.0f));
    }

    protected static int getScreenWidth(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return (int)((float)displayMetrics.widthPixels / displayMetrics.density);
    }

    protected static BottomBarTab[] inflateMenuFromResource(Activity activity, @MenuRes int menuRes) {
        PopupMenu popupMenu = new PopupMenu((Context)activity, null);
        Menu menu = popupMenu.getMenu();
        activity.getMenuInflater().inflate(menuRes, menu);
        int menuSize = menu.size();
        BottomBarTab[] tabs = new BottomBarTab[menuSize];
        for (int i = 0; i < menuSize; ++i) {
            MenuItem item = menu.getItem(i);
            BottomBarTab tab = new BottomBarTab(item.getIcon(), String.valueOf(item.getTitle()));
            tab.id = item.getItemId();
            tabs[i] = tab;
        }
        return tabs;
    }

    @TargetApi(value=21)
    protected static void animateBGColorChange(View clickedView, final View backgroundView, final View bgOverlay, final int newColor) {
        ViewPropertyAnimatorCompat animator;
        int centerX = (int)(ViewCompat.getX((View)clickedView) + (float)(clickedView.getMeasuredWidth() / 2));
        int centerY = clickedView.getMeasuredHeight() / 2;
        int finalRadius = backgroundView.getWidth();
        backgroundView.clearAnimation();
        bgOverlay.clearAnimation();
        if (Build.VERSION.SDK_INT >= 21) {
            if (!bgOverlay.isAttachedToWindow()) {
                return;
            }
            animator = ViewAnimationUtils.createCircularReveal((View)bgOverlay, (int)centerX, (int)centerY, (float)0.0f, (float)finalRadius);
        } else {
            ViewCompat.setAlpha((View)bgOverlay, (float)0.0f);
            animator = ViewCompat.animate((View)bgOverlay).alpha(1.0f);
        }
        if (animator instanceof ViewPropertyAnimatorCompat) {
            animator.setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

                public void onAnimationEnd(View view) {
                    this.onCancel();
                }

                public void onAnimationCancel(View view) {
                    this.onCancel();
                }

                private void onCancel() {
                    backgroundView.setBackgroundColor(newColor);
                    bgOverlay.setVisibility(4);
                    ViewCompat.setAlpha((View)bgOverlay, (float)1.0f);
                }
            }).start();
        } else if (animator != null) {
            ((Animator)animator).addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    this.onCancel();
                }

                public void onAnimationCancel(Animator animation) {
                    this.onCancel();
                }

                private void onCancel() {
                    backgroundView.setBackgroundColor(newColor);
                    bgOverlay.setVisibility(4);
                    ViewCompat.setAlpha((View)bgOverlay, (float)1.0f);
                }
            });
            ((Animator)animator).start();
        }
        bgOverlay.setBackgroundColor(newColor);
        bgOverlay.setVisibility(0);
    }

    public static void setTextAppearance(TextView textView, int resId) {
        if (Build.VERSION.SDK_INT >= 23) {
            textView.setTextAppearance(resId);
        } else {
            textView.setTextAppearance(textView.getContext(), resId);
        }
    }
}

