/*
 * Decompiled with CFR 0.152.
 */
package com.roughike.bottombar;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.IdRes;
import android.support.annotation.MenuRes;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.KeyCharacterMap;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.roughike.bottombar.BottomBarFragment;
import com.roughike.bottombar.BottomBarItemBase;
import com.roughike.bottombar.BottomBarTab;
import com.roughike.bottombar.MiscUtils;
import com.roughike.bottombar.OnMenuTabSelectedListener;
import com.roughike.bottombar.OnTabSelectedListener;
import com.roughike.bottombar.R;
import java.util.HashMap;

public class BottomBar
extends FrameLayout
implements View.OnClickListener,
View.OnLongClickListener {
    private static final long ANIMATION_DURATION = 150L;
    private static final int MAX_FIXED_TAB_COUNT = 3;
    private static final String STATE_CURRENT_SELECTED_TAB = "STATE_CURRENT_SELECTED_TAB";
    private static final String TAG_BOTTOM_BAR_VIEW_INACTIVE = "BOTTOM_BAR_VIEW_INACTIVE";
    private static final String TAG_BOTTOM_BAR_VIEW_ACTIVE = "BOTTOM_BAR_VIEW_ACTIVE";
    private Context mContext;
    private boolean mIsTabletMode;
    private ViewGroup mUserContentContainer;
    private View mOuterContainer;
    private ViewGroup mItemContainer;
    private View mBackgroundView;
    private View mBackgroundOverlay;
    private View mShadowView;
    private int mPrimaryColor;
    private int mInActiveColor;
    private int mWhiteColor;
    private int mScreenWidth;
    private int mTwoDp;
    private int mTenDp;
    private int mMaxFixedItemWidth;
    private OnTabSelectedListener mListener;
    private OnMenuTabSelectedListener mMenuListener;
    private int mCurrentTabPosition;
    private boolean mIsShiftingMode;
    private FragmentManager mFragmentManager;
    private int mFragmentContainer;
    private BottomBarItemBase[] mItems;
    private HashMap<Integer, Integer> mColorMap;
    private int mCurrentBackgroundColor;
    private int mDefaultBackgroundColor;
    private boolean mDrawBehindNavBar = true;
    private boolean mUseTopOffset = true;

    public static BottomBar attach(Activity activity, Bundle savedInstanceState) {
        BottomBar bottomBar = new BottomBar((Context)activity);
        bottomBar.onRestoreInstanceState(savedInstanceState);
        ViewGroup contentView = (ViewGroup)activity.findViewById(0x1020002);
        View oldLayout = contentView.getChildAt(0);
        contentView.removeView(oldLayout);
        bottomBar.getUserContainer().addView(oldLayout, 0, oldLayout.getLayoutParams());
        contentView.addView((View)bottomBar, 0);
        return bottomBar;
    }

    public static BottomBar attach(View view, Bundle savedInstanceState) {
        BottomBar bottomBar = new BottomBar(view.getContext());
        bottomBar.onRestoreInstanceState(savedInstanceState);
        ViewGroup contentView = (ViewGroup)view.getParent();
        if (contentView != null) {
            View oldLayout = contentView.getChildAt(0);
            contentView.removeView(oldLayout);
            bottomBar.getUserContainer().addView(oldLayout, oldLayout.getLayoutParams());
            contentView.addView((View)bottomBar, 0);
        } else if (view.getLayoutParams() == null) {
            bottomBar.getUserContainer().addView(view, new ViewGroup.LayoutParams(-1, -1));
        } else {
            bottomBar.getUserContainer().addView(view, view.getLayoutParams());
        }
        return bottomBar;
    }

    public void setFragmentItems(FragmentManager fragmentManager, @IdRes int containerResource, BottomBarFragment ... fragmentItems) {
        this.clearItems();
        this.mFragmentManager = fragmentManager;
        this.mFragmentContainer = containerResource;
        this.mItems = fragmentItems;
        this.updateItems(this.mItems);
    }

    public void setItems(BottomBarTab ... bottomBarTabs) {
        this.clearItems();
        this.mItems = bottomBarTabs;
        this.updateItems(this.mItems);
    }

    public void setItemsFromMenu(@MenuRes int menuRes, OnMenuTabSelectedListener listener) {
        this.clearItems();
        this.mItems = MiscUtils.inflateMenuFromResource((Activity)this.getContext(), menuRes);
        this.mMenuListener = listener;
        this.updateItems(this.mItems);
    }

    public void setOnItemSelectedListener(OnTabSelectedListener listener) {
        this.mListener = listener;
    }

    public void selectTabAtPosition(int position, boolean animate) {
        this.unselectTab(this.mItemContainer.findViewWithTag((Object)TAG_BOTTOM_BAR_VIEW_ACTIVE), animate);
        this.selectTab(this.mItemContainer.getChildAt(position), animate);
        if (this.mListener != null) {
            this.mListener.onItemSelected(position);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putInt(STATE_CURRENT_SELECTED_TAB, this.mCurrentTabPosition);
    }

    public void mapColorForTab(int tabPosition, int color2) {
        if (this.mItems == null || this.mItems.length == 0) {
            throw new UnsupportedOperationException("You have no BottomBar Tabs set yet. Please set them first before calling the mapColorForTab method.");
        }
        if (tabPosition > this.mItems.length || tabPosition < 0) {
            throw new IndexOutOfBoundsException("Cant map color for Tab index " + tabPosition + ". You have no BottomBar Tabs at that position.");
        }
        if (!this.mIsShiftingMode || this.mIsTabletMode) {
            return;
        }
        if (this.mColorMap == null) {
            this.mColorMap = new HashMap();
        }
        if (tabPosition == this.mCurrentTabPosition && this.mCurrentBackgroundColor != color2) {
            this.mCurrentBackgroundColor = color2;
            this.mBackgroundView.setBackgroundColor(color2);
        }
        this.mColorMap.put(tabPosition, color2);
    }

    public void mapColorForTab(int tabPosition, String color2) {
        this.mapColorForTab(tabPosition, Color.parseColor((String)color2));
    }

    public void hideShadow() {
        if (this.mShadowView != null) {
            this.mShadowView.setVisibility(8);
        }
    }

    public void noNavBarGoodness() {
        if (this.mItems != null) {
            throw new UnsupportedOperationException("This BottomBar already has items! You must call noNavBarGoodness() before setting the items, preferably right after attaching it to your layout.");
        }
        this.mDrawBehindNavBar = false;
    }

    public void noTopOffset() {
        this.mUseTopOffset = false;
    }

    public BottomBar(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public BottomBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public BottomBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public BottomBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mContext = context;
        this.mPrimaryColor = MiscUtils.getColor(this.getContext(), R.attr.colorPrimary);
        this.mInActiveColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.bb_inActiveBottomBarItemColor);
        this.mWhiteColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.white);
        this.mScreenWidth = MiscUtils.getScreenWidth(this.mContext);
        this.mTwoDp = MiscUtils.dpToPixel(this.mContext, 2.0f);
        this.mTenDp = MiscUtils.dpToPixel(this.mContext, 10.0f);
        this.mMaxFixedItemWidth = MiscUtils.dpToPixel(this.mContext, 168.0f);
        this.initializeViews();
    }

    private void initializeViews() {
        View rootView = View.inflate((Context)this.mContext, (int)R.layout.bb_bottom_bar_item_container, null);
        this.mIsTabletMode = rootView.findViewById(R.id.bb_tablet_right_border) != null;
        this.mUserContentContainer = (ViewGroup)rootView.findViewById(R.id.bb_user_content_container);
        this.mOuterContainer = rootView.findViewById(R.id.bb_bottom_bar_outer_container);
        this.mItemContainer = (ViewGroup)rootView.findViewById(R.id.bb_bottom_bar_item_container);
        this.mBackgroundView = rootView.findViewById(R.id.bb_bottom_bar_background_view);
        this.mBackgroundOverlay = rootView.findViewById(R.id.bb_bottom_bar_background_overlay);
        this.mShadowView = rootView.findViewById(R.id.bb_bottom_bar_shadow);
        this.addView(rootView);
    }

    protected ViewGroup getUserContainer() {
        return this.mUserContentContainer;
    }

    protected View getOuterContainer() {
        return this.mOuterContainer;
    }

    protected boolean drawBehindNavBar() {
        return this.mDrawBehindNavBar;
    }

    protected boolean useTopOffset() {
        return this.mUseTopOffset;
    }

    public void onClick(View v) {
        if (v.getTag().equals(TAG_BOTTOM_BAR_VIEW_INACTIVE)) {
            this.unselectTab(this.findViewWithTag(TAG_BOTTOM_BAR_VIEW_ACTIVE), true);
            this.selectTab(v, true);
            this.updateSelectedTab(this.findItemPosition(v));
        }
    }

    private void updateSelectedTab(int newPosition) {
        if (newPosition != this.mCurrentTabPosition) {
            this.mCurrentTabPosition = newPosition;
            if (this.mListener != null) {
                this.mListener.onItemSelected(this.mCurrentTabPosition);
            }
            if (this.mMenuListener != null && this.mItems instanceof BottomBarTab[]) {
                this.mMenuListener.onMenuItemSelected(((BottomBarTab)this.mItems[this.mCurrentTabPosition]).id);
            }
            this.updateCurrentFragment();
        }
    }

    public boolean onLongClick(View v) {
        if ((this.mIsShiftingMode || this.mIsTabletMode) && v.getTag().equals(TAG_BOTTOM_BAR_VIEW_INACTIVE)) {
            Toast.makeText((Context)this.mContext, (CharSequence)this.mItems[this.findItemPosition(v)].getTitle(this.mContext), (int)0).show();
        }
        return true;
    }

    private void updateItems(BottomBarItemBase[] bottomBarItems) {
        int index = 0;
        int biggestWidth = 0;
        boolean bl = this.mIsShiftingMode = 3 < bottomBarItems.length;
        if (!this.mIsTabletMode && this.mIsShiftingMode) {
            this.mDefaultBackgroundColor = this.mCurrentBackgroundColor = this.mPrimaryColor;
            this.mBackgroundView.setBackgroundColor(this.mDefaultBackgroundColor);
            if (this.mContext instanceof Activity) {
                BottomBar.navBarMagic((Activity)this.mContext, this);
            }
        }
        View[] viewsToAdd = new View[bottomBarItems.length];
        for (BottomBarItemBase bottomBarItemBase : bottomBarItems) {
            int layoutResource = this.mIsShiftingMode && !this.mIsTabletMode ? R.layout.bb_bottom_bar_item_shifting : R.layout.bb_bottom_bar_item_fixed;
            View bottomBarView = View.inflate((Context)this.mContext, (int)layoutResource, null);
            ImageView icon = (ImageView)bottomBarView.findViewById(R.id.bb_bottom_bar_icon);
            icon.setImageDrawable(bottomBarItemBase.getIcon(this.mContext));
            if (!this.mIsTabletMode) {
                TextView title = (TextView)bottomBarView.findViewById(R.id.bb_bottom_bar_title);
                title.setText((CharSequence)bottomBarItemBase.getTitle(this.mContext));
            }
            if (!this.mIsTabletMode && this.mIsShiftingMode) {
                icon.setColorFilter(this.mWhiteColor);
            }
            if (bottomBarItemBase instanceof BottomBarTab) {
                bottomBarView.setId(((BottomBarTab)bottomBarItemBase).id);
            }
            if (index == this.mCurrentTabPosition) {
                this.selectTab(bottomBarView, false);
            } else {
                this.unselectTab(bottomBarView, false);
            }
            if (!this.mIsTabletMode) {
                if (bottomBarView.getWidth() > biggestWidth) {
                    biggestWidth = bottomBarView.getWidth();
                }
                viewsToAdd[index] = bottomBarView;
            } else {
                this.mItemContainer.addView(bottomBarView);
            }
            bottomBarView.setOnClickListener((View.OnClickListener)this);
            bottomBarView.setOnLongClickListener((View.OnLongClickListener)this);
            ++index;
        }
        if (!this.mIsTabletMode) {
            int proposedItemWidth = Math.min(MiscUtils.dpToPixel(this.mContext, this.mScreenWidth / bottomBarItems.length), this.mMaxFixedItemWidth);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(proposedItemWidth, -2);
            for (View bottomBarView : viewsToAdd) {
                bottomBarView.setLayoutParams((ViewGroup.LayoutParams)params);
                this.mItemContainer.addView(bottomBarView);
            }
        }
        this.updateCurrentFragment();
    }

    private void onRestoreInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            this.mCurrentTabPosition = savedInstanceState.getInt(STATE_CURRENT_SELECTED_TAB, -1);
            if (this.mCurrentTabPosition == -1) {
                this.mCurrentTabPosition = 0;
                Log.e((String)"BottomBar", (String)"You must override the Activity's onSaveInstanceState(Bundle outState) and call BottomBar.onSaveInstanceState(outState) there to restore the state properly.");
            }
        }
    }

    private void selectTab(View tab, boolean animate) {
        int translationY;
        tab.setTag((Object)TAG_BOTTOM_BAR_VIEW_ACTIVE);
        ImageView icon = (ImageView)tab.findViewById(R.id.bb_bottom_bar_icon);
        TextView title = (TextView)tab.findViewById(R.id.bb_bottom_bar_title);
        int tabPosition = this.findItemPosition(tab);
        if (!this.mIsShiftingMode || this.mIsTabletMode) {
            icon.setColorFilter(this.mPrimaryColor);
            if (title != null) {
                title.setTextColor(this.mPrimaryColor);
            }
        }
        if (title == null) {
            return;
        }
        int n = translationY = this.mIsShiftingMode ? this.mTenDp : this.mTwoDp;
        if (animate) {
            title.animate().setDuration(150L).scaleX(1.0f).scaleY(1.0f).start();
            tab.animate().setDuration(150L).translationY((float)(-translationY)).start();
            if (this.mIsShiftingMode) {
                icon.animate().setDuration(150L).alpha(1.0f).start();
            }
            this.handleBackgroundColorChange(tabPosition, tab);
        } else {
            title.setScaleX(1.0f);
            title.setScaleY(1.0f);
            tab.setTranslationY((float)(-translationY));
            if (this.mIsShiftingMode) {
                icon.setAlpha(1.0f);
            }
        }
    }

    private void handleBackgroundColorChange(int tabPosition, View tab) {
        if (!this.mIsShiftingMode || this.mIsTabletMode) {
            return;
        }
        if (this.mColorMap != null && this.mColorMap.containsKey(tabPosition)) {
            this.handleBackgroundColorChange(tab, this.mColorMap.get(tabPosition));
        } else {
            this.handleBackgroundColorChange(tab, this.mDefaultBackgroundColor);
        }
    }

    private void handleBackgroundColorChange(View tab, int color2) {
        MiscUtils.animateBGColorChange(tab, this.mBackgroundView, this.mBackgroundOverlay, color2);
        this.mCurrentBackgroundColor = color2;
    }

    private void unselectTab(View tab, boolean animate) {
        float scale;
        tab.setTag((Object)TAG_BOTTOM_BAR_VIEW_INACTIVE);
        ImageView icon = (ImageView)tab.findViewById(R.id.bb_bottom_bar_icon);
        TextView title = (TextView)tab.findViewById(R.id.bb_bottom_bar_title);
        if (!this.mIsShiftingMode || this.mIsTabletMode) {
            icon.setColorFilter(this.mInActiveColor);
            if (title != null) {
                title.setTextColor(this.mInActiveColor);
            }
        }
        if (title == null) {
            return;
        }
        float f = scale = this.mIsShiftingMode ? 0.0f : 0.86f;
        if (animate) {
            title.animate().setDuration(150L).scaleX(scale).scaleY(scale).start();
            tab.animate().setDuration(150L).translationY(0.0f).start();
            if (this.mIsShiftingMode && !this.mIsTabletMode) {
                icon.animate().setDuration(150L).alpha(0.6f).start();
            }
        } else {
            title.setScaleX(scale);
            title.setScaleY(scale);
            tab.setTranslationY(0.0f);
            if (this.mIsShiftingMode && !this.mIsTabletMode) {
                icon.setAlpha(0.6f);
            }
        }
    }

    private int findItemPosition(View viewToFind) {
        int position = 0;
        for (int i = 0; i < this.mItemContainer.getChildCount(); ++i) {
            View candidate = this.mItemContainer.getChildAt(i);
            if (!candidate.equals(viewToFind)) continue;
            position = i;
            break;
        }
        return position;
    }

    private void updateCurrentFragment() {
        if (this.mFragmentManager != null && this.mFragmentContainer != 0 && this.mItems != null && this.mItems instanceof BottomBarFragment[]) {
            this.mFragmentManager.beginTransaction().replace(this.mFragmentContainer, ((BottomBarFragment)this.mItems[this.mCurrentTabPosition]).getFragment()).commit();
        }
    }

    private void clearItems() {
        int childCount = this.mItemContainer.getChildCount();
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                this.mItemContainer.removeView(this.mItemContainer.getChildAt(i));
            }
        }
        if (this.mFragmentManager != null) {
            this.mFragmentManager = null;
        }
        if (this.mFragmentContainer != 0) {
            this.mFragmentContainer = 0;
        }
        if (this.mItems != null) {
            this.mItems = null;
        }
    }

    private static void navBarMagic(Activity activity, BottomBar bottomBar) {
        Resources res = activity.getResources();
        int softMenuIdentifier = res.getIdentifier("config_showNavigationBar", "bool", "android");
        if (!bottomBar.drawBehindNavBar() || softMenuIdentifier <= 0 || !res.getBoolean(softMenuIdentifier)) {
            return;
        }
        if (ViewConfiguration.get((Context)activity).hasPermanentMenuKey() && KeyCharacterMap.deviceHasKey((int)4)) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 19 && res.getConfiguration().orientation == 1) {
            activity.getWindow().getAttributes().flags |= 0x8000000;
            int navBarIdentifier = res.getIdentifier("navigation_bar_height", "dimen", "android");
            final int navBarHeight = navBarIdentifier > 0 ? res.getDimensionPixelSize(navBarIdentifier) : MiscUtils.dpToPixel((Context)activity, 48.0f);
            if (bottomBar.useTopOffset()) {
                int statusBarResource = res.getIdentifier("status_bar_height", "dimen", "android");
                int statusBarHeight = statusBarResource > 0 ? res.getDimensionPixelSize(statusBarResource) : MiscUtils.dpToPixel((Context)activity, 25.0f);
                TypedValue tv = new TypedValue();
                int actionBarHeight = activity.getTheme().resolveAttribute(16843499, tv, true) ? TypedValue.complexToDimensionPixelSize((int)tv.data, (DisplayMetrics)res.getDisplayMetrics()) : MiscUtils.dpToPixel((Context)activity, 56.0f);
                bottomBar.getUserContainer().setPadding(0, statusBarHeight + actionBarHeight, 0, 0);
            }
            final View outerContainer = bottomBar.getOuterContainer();
            bottomBar.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    outerContainer.getLayoutParams().height = outerContainer.getHeight() + navBarHeight;
                    ViewTreeObserver obs = outerContainer.getViewTreeObserver();
                    if (Build.VERSION.SDK_INT >= 16) {
                        obs.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        obs.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                }
            });
        }
    }
}

