/*
 * Decompiled with CFR 0.152.
 */
package rook.com.google.common.collect;

import java.io.Serializable;
import java.util.Comparator;
import rook.com.google.common.annotations.GwtCompatible;
import rook.com.google.common.base.Preconditions;
import rook.com.google.common.collect.Ordering;
import rook.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible(serializable=true)
final class ComparatorOrdering<T>
extends Ordering<T>
implements Serializable {
    final Comparator<T> comparator;
    private static final long serialVersionUID = 0L;

    ComparatorOrdering(Comparator<T> comparator) {
        this.comparator = Preconditions.checkNotNull(comparator);
    }

    @Override
    public int compare(T a, T b) {
        return this.comparator.compare(a, b);
    }

    @Override
    public boolean equals(@NullableDecl Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ComparatorOrdering) {
            ComparatorOrdering that = (ComparatorOrdering)object;
            return this.comparator.equals(that.comparator);
        }
        return false;
    }

    public int hashCode() {
        return this.comparator.hashCode();
    }

    public String toString() {
        return this.comparator.toString();
    }
}

