/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook;

import com.rookout.rook.Exceptions;
import java.util.ArrayList;
import java.util.Arrays;

public class RuntimeVersionVerifier {
    private static ArrayList<String> supportedDistributions = new ArrayList<String>(Arrays.asList("oracle", "amazon.com", "adoptopenjdk", "icedtea", "ibm", "pivotal"));

    public static void CheckVersionSupported() throws Exceptions.ToolException {
        versionHolder currentVersion = new versionHolder();
        RuntimeVersionVerifier.VerifyJvmDistribution(currentVersion);
        RuntimeVersionVerifier.VerifyJvmVersion(currentVersion);
    }

    private static void VerifyJvmDistribution(versionHolder currentVersion) throws Exceptions.RookUnSupportedEnvironment {
        boolean jvmDistributionIsSupported = false;
        for (String supportedDistributionName : supportedDistributions) {
            if (!currentVersion.distributionName.contains(supportedDistributionName)) continue;
            jvmDistributionIsSupported = true;
            break;
        }
        if (!jvmDistributionIsSupported) {
            throw new Exceptions.RookUnSupportedEnvironment(currentVersion.fullVersion, currentVersion.distributionName, currentVersion.updateVersion);
        }
    }

    private static void VerifyJvmVersion(versionHolder currentVersion) throws Exceptions.RookUnSupportedEnvironment {
        switch (currentVersion.majorVersion) {
            case "7": {
                if (currentVersion.updateVersion >= 111) {
                    return;
                }
            }
            case "8": {
                if (currentVersion.updateVersion >= 74) {
                    return;
                }
            }
            case "9": {
                return;
            }
            case "9-Debian": {
                return;
            }
            case "10": {
                return;
            }
            case "11": {
                return;
            }
            case "12": {
                return;
            }
            case "13": {
                return;
            }
            case "13-ea": {
                return;
            }
        }
        throw new Exceptions.RookUnSupportedEnvironment(currentVersion.fullVersion, currentVersion.distributionName, currentVersion.updateVersion);
    }

    private static abstract class Runnable {
        private Runnable() {
        }

        public abstract void run() throws Throwable;
    }

    private static class versionHolder {
        public String fullVersion = System.getProperty("java.version");
        public String majorVersion;
        public int updateVersion;
        public String distributionName;

        public versionHolder() throws Exceptions.RookUnSupportedEnvironment, Exceptions.RookJVMVersionParsingFailed {
            try {
                String major;
                String update;
                block14: {
                    String minor;
                    String[] javaVersionElements;
                    block13: {
                        this.distributionName = System.getProperty("java.vm.vendor").toLowerCase();
                        javaVersionElements = this.fullVersion.split("\\.|_|-b");
                        if (javaVersionElements.length == 0) {
                            throw new Exceptions.RookUnSupportedEnvironment(this.fullVersion, this.distributionName, this.updateVersion);
                        }
                        minor = "0";
                        update = "0";
                        String prefix = javaVersionElements[0];
                        if (0 != prefix.compareTo("1")) break block13;
                        switch (javaVersionElements.length) {
                            case 4: {
                                update = javaVersionElements[3].split("-")[0];
                            }
                            case 3: {
                                minor = javaVersionElements[2];
                            }
                            case 2: {
                                prefix = javaVersionElements[0];
                                major = javaVersionElements[1];
                                break block14;
                            }
                            default: {
                                throw new Exceptions.RookUnSupportedEnvironment(this.fullVersion, this.distributionName, this.updateVersion);
                            }
                        }
                    }
                    switch (javaVersionElements.length) {
                        case 3: {
                            minor = javaVersionElements[2];
                        }
                        case 1: {
                            major = javaVersionElements[0];
                            break;
                        }
                        default: {
                            throw new Exceptions.RookUnSupportedEnvironment(this.fullVersion, this.distributionName, this.updateVersion);
                        }
                    }
                }
                this.majorVersion = major;
                this.updateVersion = Integer.parseInt(update, 10);
            }
            catch (Exceptions.RookUnSupportedEnvironment e) {
                throw e;
            }
            catch (Throwable e) {
                throw new Exceptions.RookJVMVersionParsingFailed(this.fullVersion);
            }
        }
    }
}

