/*
 * Decompiled with CFR 0.152.
 */
package rook.io.opencensus.tags;

import rook.io.opencensus.internal.StringUtils;
import rook.io.opencensus.internal.Utils;
import rook.io.opencensus.tags.AutoValue_TagKey;
import rook.javax.annotation.concurrent.Immutable;

@Immutable
public abstract class TagKey {
    public static final int MAX_LENGTH = 255;

    TagKey() {
    }

    public static TagKey create(String name) {
        Utils.checkArgument(TagKey.isValid(name), "Invalid TagKey name: %s", name);
        return new AutoValue_TagKey(name);
    }

    public abstract String getName();

    private static boolean isValid(String name) {
        return !name.isEmpty() && name.length() <= 255 && StringUtils.isPrintableString(name);
    }
}

