/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.ComWs;

import com.rookout.AgentInfo;
import com.rookout.Messages;
import com.rookout.rook.ComWs.EnvelopeWrapper;
import com.rookout.rook.ComWs.IncomingMessageHandler;
import com.rookout.rook.ComWs.Information;
import com.rookout.rook.Exceptions;
import com.rookout.rook.RookLogger;
import rook.com.google.protobuf.Any;
import rook.com.google.protobuf.Message;
import rook.io.netty.channel.ChannelHandlerContext;
import rook.io.netty.channel.ChannelPromise;
import rook.io.netty.channel.SimpleChannelInboundHandler;
import rook.io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import rook.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;

public class RookoutProtocolHandler
extends SimpleChannelInboundHandler<Message> {
    private Information info;
    private IncomingMessageHandler messageHandler;
    ChannelPromise gotInitialAugs;

    RookoutProtocolHandler(Information info, IncomingMessageHandler handler) {
        this.info = info;
        this.messageHandler = handler;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        this.gotInitialAugs = ctx.newPromise();
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        WebSocketClientProtocolHandler.ClientHandshakeStateEvent handshakeStateEvent;
        if (evt instanceof WebSocketClientProtocolHandler.ClientHandshakeStateEvent && (handshakeStateEvent = (WebSocketClientProtocolHandler.ClientHandshakeStateEvent)((Object)evt)) == WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE) {
            ctx.channel().writeAndFlush(EnvelopeWrapper.envelope(this.getRegistrationMessage()));
        }
        ctx.fireUserEventTriggered(evt);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof WebSocketHandshakeException && cause.getMessage().contains("403")) {
            this.gotInitialAugs.setFailure(new Exceptions.RookInvalidToken());
            super.exceptionCaught(ctx, new Exceptions.RookInvalidToken());
            return;
        }
        super.exceptionCaught(ctx, cause);
    }

    @Override
    public void channelRead0(ChannelHandlerContext ctx, Message message) {
        Any any = (Any)message;
        this.messageHandler.handleIncomingMessage(any);
        if (any.is(Messages.InitialAugsCommand.class)) {
            RookLogger.Instance().debug("Finished initialization", new Object[0]);
            this.gotInitialAugs.setSuccess();
        }
        ctx.fireChannelRead(message);
    }

    private Messages.NewAgentMessage getRegistrationMessage() {
        AgentInfo.AgentInformation packedInfo = Information.PackAgentInfo(this.info);
        Messages.NewAgentMessage.Builder m = Messages.NewAgentMessage.newBuilder();
        m.setAgentInfo(packedInfo);
        return m.build();
    }
}

