/*
 * Decompiled with CFR 0.152.
 */
package rook.io.grpc.internal;

import java.net.URI;
import rook.io.grpc.NameResolver;
import rook.io.grpc.internal.ForwardingNameResolver;
import rook.javax.annotation.Nullable;

final class OverrideAuthorityNameResolverFactory
extends NameResolver.Factory {
    private final NameResolver.Factory delegate;
    private final String authorityOverride;

    OverrideAuthorityNameResolverFactory(NameResolver.Factory delegate, String authorityOverride) {
        this.delegate = delegate;
        this.authorityOverride = authorityOverride;
    }

    @Override
    @Nullable
    public NameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        NameResolver resolver = this.delegate.newNameResolver(targetUri, args);
        if (resolver == null) {
            return null;
        }
        return new ForwardingNameResolver(resolver){

            @Override
            public String getServiceAuthority() {
                return OverrideAuthorityNameResolverFactory.this.authorityOverride;
            }
        };
    }

    @Override
    public String getDefaultScheme() {
        return this.delegate.getDefaultScheme();
    }
}

