/*
 * Decompiled with CFR 0.152.
 */
package rook.io.grpc.internal;

import java.util.concurrent.Executor;
import rook.com.google.common.annotations.VisibleForTesting;
import rook.com.google.common.base.Preconditions;
import rook.com.google.common.util.concurrent.ListenableFuture;
import rook.com.google.common.util.concurrent.SettableFuture;
import rook.io.grpc.CallOptions;
import rook.io.grpc.InternalChannelz;
import rook.io.grpc.InternalLogId;
import rook.io.grpc.Metadata;
import rook.io.grpc.MethodDescriptor;
import rook.io.grpc.Status;
import rook.io.grpc.internal.ClientStream;
import rook.io.grpc.internal.ClientStreamListener;
import rook.io.grpc.internal.ClientTransport;
import rook.io.grpc.internal.FailingClientStream;

class FailingClientTransport
implements ClientTransport {
    @VisibleForTesting
    final Status error;
    private final ClientStreamListener.RpcProgress rpcProgress;

    FailingClientTransport(Status error, ClientStreamListener.RpcProgress rpcProgress) {
        Preconditions.checkArgument(!error.isOk(), "error must not be OK");
        this.error = error;
        this.rpcProgress = rpcProgress;
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions) {
        return new FailingClientStream(this.error, this.rpcProgress);
    }

    @Override
    public void ping(final ClientTransport.PingCallback callback, Executor executor) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(FailingClientTransport.this.error.asException());
            }
        });
    }

    @Override
    public ListenableFuture<InternalChannelz.SocketStats> getStats() {
        SettableFuture<InternalChannelz.SocketStats> ret = SettableFuture.create();
        ret.set(null);
        return ret;
    }

    @Override
    public InternalLogId getLogId() {
        throw new UnsupportedOperationException("Not a real transport");
    }
}

