/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Augs;

import com.rookout.rook.Augs.Actions.Action;
import com.rookout.rook.Augs.AugRateLimiter;
import com.rookout.rook.Augs.Conditions.Condition;
import com.rookout.rook.Augs.Locations.Location;
import com.rookout.rook.Augs.LogCache;
import com.rookout.rook.Com.Output;
import com.rookout.rook.Com.OutputBase;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import com.rookout.rook.Processor.Namespaces.FrameNamespace;
import com.rookout.rook.Processor.Namespaces.JavaUtilsNamespace;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.Processor.Namespaces.StackNamespace;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Services.Frame;
import com.rookout.rook.TriggerServices;
import com.rookout.rook.UserWarnings;
import com.rookout.rook.WarningReporter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.logging.Level;

public class Aug
implements WarningReporter {
    public String augId;
    private Location location;
    private Action action;
    private OutputBase output;
    private AugRateLimiter rateLimiter;
    private double maxAugTime;
    private Condition condition;
    private String status = "";
    private boolean enabled = true;
    private LogCache warningCache;
    private LogCache logCache;

    public Aug(String augId, Location location, Action action, Output output) {
        this(augId, location, action, null, output, 0.0, null);
    }

    public Aug(String augId, Location location, Action action, Condition condition, OutputBase output, double maxAugTime, AbstractMap.SimpleImmutableEntry<Long, Long> rateLimits) {
        this.augId = augId;
        this.location = location;
        this.action = action;
        this.output = output;
        this.maxAugTime = maxAugTime;
        this.condition = condition;
        this.warningCache = new LogCache(10);
        this.logCache = new LogCache(10);
        this.rateLimiter = rateLimits == null ? new AugRateLimiter(0L, 0L) : new AugRateLimiter(rateLimits.getKey(), rateLimits.getValue());
    }

    public void AddAug(TriggerServices triggerServices) {
        try {
            this.location.AddAug(triggerServices, this);
        }
        catch (Throwable e) {
            String message = "Exception when adding aug";
            RookLogger.Instance().log(Level.SEVERE, message, e, new Object[0]);
            this.SetError(new RookError(e, message));
        }
    }

    public void Execute(final Frame frame, Namespace extracted) {
        if (!this.enabled) {
            return;
        }
        try (UserWarnings reporter = new UserWarnings(this);){
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        long now = System.currentTimeMillis();
                        Long rateLimiterKey = null;
                        ContainerNamespace namespace = Aug.this.createAugNamespace(frame);
                        if (Aug.this.condition == null || Aug.this.condition.evaluate(namespace)) {
                            rateLimiterKey = Aug.this.rateLimiter.allow();
                            if (rateLimiterKey == null) {
                                Aug.this.SendWarning(new RookError(new Exceptions.RookRuleRateLimited()));
                                return null;
                            }
                            RookLogger.Instance().log(Level.INFO, "Executing aug - " + Aug.this.augId);
                            Aug.this.action.Execute(Aug.this.augId, namespace, Aug.this.output);
                        }
                        long duration = System.currentTimeMillis() - now;
                        Aug.this.rateLimiter.record(rateLimiterKey, duration);
                        if (Aug.this.maxAugTime > 0.0 && (double)duration > Aug.this.maxAugTime) {
                            RookLogger.Instance().log(Level.WARNING, "Removing rule because max execution time was reached - " + Aug.this.augId);
                            Aug.this.enabled = false;
                            Aug.this.SetError(new RookError(new Exceptions.RookRuleMaxExecutionTimeReached()));
                            return null;
                        }
                    }
                    catch (Throwable e) {
                        String message = "Exception while processing Aug";
                        RookError rookError = new RookError(e, message);
                        if (!Aug.this.ShouldSilenceLog(rookError, Aug.this.logCache)) {
                            RookLogger.Instance().log(Level.SEVERE, message, e, new Object[0]);
                        }
                        Aug.this.SendWarning(rookError);
                    }
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void SetActive() {
        this.SendRuleStatus("Active", null);
    }

    public void SetPending() {
        this.SendRuleStatus("Pending", null);
    }

    public void SetRemoved() {
        this.SendRuleStatus("Deleted", null);
    }

    public void SetError(RookError error) {
        this.SendRuleStatus("Error", error);
    }

    public void SetUnknown(RookError error) {
        this.SendRuleStatus("Unknown", error);
    }

    @Override
    public void SendWarning(RookError error) {
        if (this.ShouldSilenceLog(error, this.warningCache)) {
            return;
        }
        RookLogger.Instance().warn(error.getMessage(), new Object[0]);
        RookLogger.Instance().log(Level.WARNING, error.getMessage());
        this.output.SendWarning(this.augId, error);
    }

    @Override
    public void SendError(RookError error) {
        RookLogger.Instance().log(Level.SEVERE, error.getMessage());
        this.SetError(error);
    }

    protected void SendRuleStatus(String status, RookError error) {
        if (this.status.equals(status)) {
            return;
        }
        RookLogger.Instance().log(Level.INFO, "Updating rule status for: " + this.augId + " to " + status);
        this.status = status;
        this.output.SendRuleStatus(this.augId, status, error);
    }

    private boolean ShouldSilenceLog(RookError error, LogCache logCache) {
        String message = error.getMessage();
        if (logCache.isFull() || logCache.contains(message)) {
            return true;
        }
        logCache.put(message);
        return false;
    }

    private ContainerNamespace createAugNamespace(Frame frame) throws Exceptions.ToolException {
        ContainerNamespace namespace = new ContainerNamespace();
        namespace.WriteAttribute("frame", new FrameNamespace(frame));
        namespace.WriteAttribute("stack", new StackNamespace(frame));
        namespace.WriteAttribute("store", new ContainerNamespace());
        namespace.WriteAttribute("temp", new ContainerNamespace());
        namespace.WriteAttribute("utils", new JavaUtilsNamespace());
        return namespace;
    }
}

