/*
 * Decompiled with CFR 0.152.
 */
package rook.io.grpc.netty;

import io.perfmark.Link;
import io.perfmark.PerfMark;
import rook.io.grpc.netty.StreamIdHolder;
import rook.io.grpc.netty.WriteQueue;
import rook.io.netty.buffer.ByteBuf;
import rook.io.netty.buffer.ByteBufHolder;
import rook.io.netty.buffer.DefaultByteBufHolder;
import rook.io.netty.channel.Channel;
import rook.io.netty.channel.ChannelPromise;

final class SendGrpcFrameCommand
extends DefaultByteBufHolder
implements WriteQueue.QueuedCommand {
    private final StreamIdHolder stream;
    private final boolean endStream;
    private final Link link;
    private ChannelPromise promise;

    SendGrpcFrameCommand(StreamIdHolder stream, ByteBuf content, boolean endStream) {
        super(content);
        this.stream = stream;
        this.endStream = endStream;
        this.link = PerfMark.link();
    }

    @Override
    public Link getLink() {
        return this.link;
    }

    StreamIdHolder stream() {
        return this.stream;
    }

    boolean endStream() {
        return this.endStream;
    }

    @Override
    public ByteBufHolder copy() {
        return new SendGrpcFrameCommand(this.stream, this.content().copy(), this.endStream);
    }

    @Override
    public ByteBufHolder duplicate() {
        return new SendGrpcFrameCommand(this.stream, this.content().duplicate(), this.endStream);
    }

    @Override
    public SendGrpcFrameCommand retain() {
        super.retain();
        return this;
    }

    @Override
    public SendGrpcFrameCommand retain(int increment) {
        super.retain(increment);
        return this;
    }

    @Override
    public SendGrpcFrameCommand touch() {
        super.touch();
        return this;
    }

    @Override
    public SendGrpcFrameCommand touch(Object hint) {
        super.touch(hint);
        return this;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || !that.getClass().equals(SendGrpcFrameCommand.class)) {
            return false;
        }
        SendGrpcFrameCommand thatCmd = (SendGrpcFrameCommand)that;
        return thatCmd.stream.equals(this.stream) && thatCmd.endStream == this.endStream && thatCmd.content().equals(this.content());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(streamId=" + this.stream.id() + ", endStream=" + this.endStream + ", content=" + this.content() + ")";
    }

    @Override
    public int hashCode() {
        int hash = this.content().hashCode();
        hash = hash * 31 + this.stream.hashCode();
        if (this.endStream) {
            hash = -hash;
        }
        return hash;
    }

    @Override
    public ChannelPromise promise() {
        return this.promise;
    }

    @Override
    public void promise(ChannelPromise promise) {
        this.promise = promise;
    }

    @Override
    public final void run(Channel channel) {
        channel.write(this, this.promise);
    }
}

