/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook;

import com.rookout.rook.Utils;
import com.rookout.rook.VersionInfo;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import rook.org.json.JSONObject;

public class Config {
    public String LoggingConfiguration$LOGGER_NAME = null;
    public String LoggingConfiguration$FILE_NAME = "rookout/java-rook.log";
    public boolean LoggingConfiguration$LOG_TO_STDERR = false;
    public boolean LoggingConfiguration$LOG_TO_FILE = false;
    public String LoggingConfiguration$LOG_LEVEL = "INFO";
    public boolean LoggingConfiguration$PROPAGATE_LOGS = false;
    public boolean LoggingConfiguration$DEBUG = false;
    public String VersionConfiguration$VERSION = VersionInfo.VERSION;
    public String VersionConfiguration$COMMIT = VersionInfo.COMMIT;
    public String GitConfiguration$COMMIT = null;
    public String GitConfiguration$ORIGIN = null;
    public String DefaultConfiguration$DEFAULT_CONFIG_FILE_NAME = "rookout-config.json";
    public boolean DefaultConfiguration$LOAD_FROM_APP_FOLDER = true;
    public String DefaultConfiguration$USER_CONFIGURATION_FILE = "rookout/rookout-config.json";
    public int ErrorConfiguration$STACK_DEPTH = 10;
    public String ControllerAddress$HOST = "https://cloud.agent.rookout.com";
    public int ControllerAddress$PORT = 443;
    public Long AgentComConfiguration$RETRY_TOTAL = 0x100000L;
    public Double AgentComConfiguration$BACK_OFF = 0.2;
    public Double AgentComConfiguration$MAX_SLEEP = 300.0;
    public Integer AgentCom$MAX_MESSAGE_LENGTH = 0x6400000;
    public Integer AgentCom$TIMEOUT = 10;
    public Integer AgentCom$SEND_ROOK_MESSAGES_TIMEOUT = 30;
    public Integer AgentCom$PING_INTERVAL = 30;
    public Integer AgentCom$PING_TIMEOUT = 5;
    public Integer AgentCom$CONNECTION_TIMEOUT = 2;
    public Integer AgentCom$RESET_BACKOFF_TIMEOUT = 180;
    public Integer AgentCom$MAX_SLEEP = 60;
    public Integer AgentComConfiguration$MAX_QUEUED_MESSAGES = 500;
    public Integer OutputWsConfiguration$MAX_STATUS_UPDATES = 200;
    public Integer OutputWsConfiguration$BUCKET_REFRESH_RATE = 10;
    public Integer OutputWsConfiguration$MAX_AUG_MESSAGES = 100;
    public Integer OutputWsConfiguration$MAX_LOG_ITEMS = 200;
    public Double OutputConfiguration$FLUSH_TIME_INTERVAL = 0.25;
    public String OutputConfiguration$THREAD_NAME = "rookout_output_thread";
    public int OutputConfiguration$MAX_ITEMS = 40;
    public int OutputConfiguration$MAX_LOG_ITEMS = 100;
    public int OutputConfiguration$MAX_STATUS_UPDATES = 100;
    public Integer ClassReloaderConfiguration$SLEEP_TIME_INTERVAL_IN_MS = 250;
    private String ClassReloaderKeyName = "ROOKOUT_RELOAD_CLASSES_INTERVAL";
    public String ClassReloaderConfiguration$THREAD_NAME = "rookout_class_reloader_thread";
    public boolean LoggingServiceConfig$IGNORE_EXCEPTIONS = true;
    private String ColdFusionConfigurationKeyName = "ROOKOUT_COLD_FUSION_FOLDER";
    public String ColdFusionConfiguration$WWW_ROOT_FOLDER;
    public long InstrumentationConfig$MIN_TIME_BETWEEN_HITS_MS = 100L;
    public long InstrumentationConfig$MAX_AUG_TIME = 400L;
    private static Config instance = null;

    public static Config Instance() {
        if (null == instance) {
            instance = new Config();
        }
        return instance;
    }

    private Config() {
        String classReloaderInterval;
        String rate_limit;
        this.LoadGlobalConfigurationFile();
        this.ColdFusionConfiguration$WWW_ROOT_FOLDER = System.getenv(this.ColdFusionConfigurationKeyName);
        if (this.ColdFusionConfiguration$WWW_ROOT_FOLDER == null) {
            this.ColdFusionConfiguration$WWW_ROOT_FOLDER = "";
        }
        if (this.DefaultConfiguration$LOAD_FROM_APP_FOLDER) {
            Path app = Paths.get(Utils.GetExecutalbePath(), new String[0]);
            Path appConfig = app.toAbsolutePath().getParent().resolve(this.DefaultConfiguration$DEFAULT_CONFIG_FILE_NAME);
            this.LoadConfigurationFile(appConfig);
        }
        if ((rate_limit = System.getenv("ROOK_RULE_RATE_LIMIT")) != null) {
            try {
                this.InstrumentationConfig$MIN_TIME_BETWEEN_HITS_MS = Long.parseLong(rate_limit);
            }
            catch (NumberFormatException appConfig) {
                // empty catch block
            }
        }
        if ((classReloaderInterval = System.getenv(this.ClassReloaderKeyName)) != null) {
            try {
                this.ClassReloaderConfiguration$SLEEP_TIME_INTERVAL_IN_MS = Integer.parseInt(classReloaderInterval);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    void LoadGlobalConfigurationFile() {
        String baseFilePath = this.DefaultConfiguration$USER_CONFIGURATION_FILE;
        if ("".equals(baseFilePath)) {
            return;
        }
        Path configFilePath = Paths.get(baseFilePath, new String[0]);
        if (!configFilePath.isAbsolute()) {
            String osName = System.getProperty("os.name").toLowerCase();
            configFilePath = osName.contains("mac") ? Paths.get(Utils.getEnv("HOME", "."), baseFilePath) : (osName.contains("win") ? Paths.get(Utils.getEnv("USERPROFILE", "."), baseFilePath) : Paths.get("/etc", baseFilePath));
        }
        this.LoadConfigurationFile(configFilePath);
    }

    public void LoadConfigurationFile(Path filePath) {
        try {
            if (!Files.exists(filePath, new LinkOption[0])) {
                return;
            }
            String rawFile = new String(Files.readAllBytes(filePath));
            this.LoadObject(new JSONObject(rawFile), null);
        }
        finally {
            return;
        }
    }

    private void LoadObject(JSONObject object, String prefix) throws Exception {
        for (String name : object.keySet()) {
            Object value = object.get(name);
            if (value instanceof JSONObject) {
                this.LoadObject((JSONObject)value, this.GetName(prefix, name));
                continue;
            }
            this.SetValue(this.GetName(prefix, name), value);
        }
    }

    private String GetName(String prefix, String name) {
        if (null != prefix && !prefix.equals("")) {
            return prefix + "$" + name;
        }
        return name;
    }

    private void SetValue(String name, Object value) throws Exception {
        this.getClass().getDeclaredField(name).set(this, value);
    }
}

