/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class RookOptions
implements Serializable {
    public String token = null;
    public String host = null;
    public Integer port = null;
    public Boolean debug = null;
    public Boolean throw_errors = null;
    public String log_level = null;
    public Boolean log_to_stderr = null;
    public Boolean log_to_file = null;
    public String log_file = null;
    public String git_commit = null;
    public String git_origin = null;
    public String[] tags = null;
    public HashMap<String, String> labels = null;
    public Boolean reload_classes = null;
    public Boolean disable_class_transform = null;
    private static String propPrefix = "com.rookout.rook.";

    public Properties serialize() throws Exception {
        Field[] fields;
        Properties props = new Properties();
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            String fieldName = field.getName();
            Object fieldValue = field.get(this);
            if (fieldValue == null) continue;
            if (field.getType().isArray()) {
                Object[] arr = (Object[])fieldValue;
                if (arr.length == 0) continue;
                StringBuilder out = new StringBuilder();
                for (Object obj : arr) {
                    out.append(obj.toString());
                    out.append(';');
                }
                out.deleteCharAt(out.length() - 1);
                props.setProperty(propPrefix + fieldName, out.toString());
                continue;
            }
            if (field.getType().equals(HashMap.class)) {
                HashMap map = (HashMap)fieldValue;
                for (Map.Entry entry : map.entrySet()) {
                    if (((String)entry.getKey()).isEmpty()) continue;
                    props.setProperty(propPrefix + fieldName + "." + (String)entry.getKey(), (String)entry.getValue());
                }
                continue;
            }
            props.setProperty(propPrefix + fieldName, fieldValue.toString());
        }
        return props;
    }

    public static RookOptions deserialize(Properties props) {
        Field[] fields;
        RookOptions opts = new RookOptions();
        for (Field field : fields = RookOptions.class.getDeclaredFields()) {
            String fieldName = field.getName();
            Class<?> fieldType = field.getType();
            try {
                if (field.getType().equals(HashMap.class)) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        String propName = (String)entry.getKey();
                        if (!propName.startsWith(propPrefix + fieldName)) continue;
                        String key = propName.substring((propPrefix + fieldName).length() + 1);
                        String value = (String)entry.getValue();
                        map.put(key, value);
                    }
                    if (map.size() == 0) continue;
                    field.set(opts, map);
                    continue;
                }
                String propValue = props.getProperty(propPrefix + fieldName, null);
                if (propValue == null) continue;
                if (field.getType().isArray()) {
                    Class<?> component = field.getType().getComponentType();
                    if (!component.equals(String.class)) continue;
                    field.set(opts, propValue.split(";"));
                    continue;
                }
                if (fieldType.equals(String.class)) {
                    field.set(opts, propValue);
                    continue;
                }
                if (fieldType.equals(Integer.class)) {
                    field.set(opts, Integer.parseInt(propValue));
                    continue;
                }
                if (!fieldType.equals(Boolean.class)) continue;
                field.set(opts, Boolean.parseBoolean(propValue));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return opts;
    }
}

