/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.ComWs;

import com.rookout.EnvelopeOuterClass;
import com.rookout.rook.Com.AgentCom;
import com.rookout.rook.Com.OutputBase;
import com.rookout.rook.ComWs.BytesToWebSocketFrameCodec;
import com.rookout.rook.ComWs.EnvelopeDecoder;
import com.rookout.rook.ComWs.EnvelopeWrapper;
import com.rookout.rook.ComWs.IncomingMessageHandler;
import com.rookout.rook.ComWs.Information;
import com.rookout.rook.ComWs.KeepaliveHandler;
import com.rookout.rook.ComWs.RookoutProtocolHandler;
import com.rookout.rook.ComWs.WebSocketHandler;
import com.rookout.rook.Config;
import com.rookout.rook.Exceptions;
import com.rookout.rook.RookLogger;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import rook.com.google.protobuf.Any;
import rook.com.google.protobuf.Message;
import rook.io.netty.bootstrap.Bootstrap;
import rook.io.netty.channel.Channel;
import rook.io.netty.channel.ChannelFuture;
import rook.io.netty.channel.ChannelFutureListener;
import rook.io.netty.channel.ChannelHandlerContext;
import rook.io.netty.channel.ChannelInboundHandlerAdapter;
import rook.io.netty.channel.ChannelInitializer;
import rook.io.netty.channel.ChannelPipeline;
import rook.io.netty.channel.ChannelPromise;
import rook.io.netty.channel.nio.NioEventLoopGroup;
import rook.io.netty.channel.socket.SocketChannel;
import rook.io.netty.channel.socket.nio.NioSocketChannel;
import rook.io.netty.handler.codec.http.DefaultHttpHeaders;
import rook.io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import rook.io.netty.handler.codec.protobuf.ProtobufDecoder;
import rook.io.netty.handler.codec.protobuf.ProtobufEncoder;
import rook.io.netty.handler.proxy.HttpProxyHandler;
import rook.io.netty.handler.ssl.SslContext;
import rook.io.netty.handler.ssl.SslContextBuilder;
import rook.io.netty.handler.timeout.IdleStateHandler;
import rook.io.netty.util.concurrent.DefaultThreadFactory;

public class AgentComWs
implements AgentCom,
IncomingMessageHandler {
    protected String agentId;
    private Double currentBackoff;
    private OutputBase output;
    private URI agentUri;
    private String token;
    private int retries = 0;
    private ScheduledFuture backOffResetTask;
    private HashMap<String, List<MessageCallback>> callbacks;
    private Channel channel;
    private NioEventLoopGroup eventLoop;
    private Config config = Config.Instance();
    private Bootstrap bootstrap;
    private Information info;
    private RookLogger logger = RookLogger.Instance();
    private final List<EnvelopeOuterClass.Envelope> pendingMessages;

    public AgentComWs(OutputBase output, String agentHost, int agentPort, String token, Map<String, String> labels, String[] tags) throws URISyntaxException, SSLException {
        this.output = output;
        this.agentUri = new URI(String.format("%s:%d/v1", agentHost, agentPort));
        this.resetId();
        this.output.setAgentId(this.agentId);
        this.currentBackoff = this.config.AgentComConfiguration$BACK_OFF;
        this.token = token;
        this.callbacks = new HashMap();
        this.eventLoop = new NioEventLoopGroup(0, new DefaultThreadFactory("rookout-agentCom", true));
        this.info = Information.Collect();
        this.info.agentId = this.agentId;
        this.info.labels = labels;
        this.info.tags = tags;
        this.bootstrap = this.buildClient();
        this.pendingMessages = new ArrayList<EnvelopeOuterClass.Envelope>();
        this.channel = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToPending(EnvelopeOuterClass.Envelope envelope) {
        List<EnvelopeOuterClass.Envelope> list = this.pendingMessages;
        synchronized (list) {
            this.pendingMessages.add(envelope);
        }
    }

    private void add(final EnvelopeOuterClass.Envelope envelope) {
        if (this.channel == null) {
            this.addToPending(envelope);
            return;
        }
        this.channel.write(envelope).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) {
                if (!future.isSuccess()) {
                    AgentComWs.this.addToPending(envelope);
                }
            }
        });
    }

    public <T extends Message> void add(T message) {
        this.add(EnvelopeWrapper.envelope(message));
    }

    public void on(String messageName, Callable callback) {
        this.registerCallback(messageName, callback, true);
    }

    public void once(String messageName, Callable callback) {
        this.registerCallback(messageName, callback, false);
    }

    private void registerCallback(String messageName, Callable callback, Boolean persistent) {
        MessageCallback messageCallback = new MessageCallback(callback, persistent);
        if (!this.callbacks.containsKey(messageName)) {
            this.callbacks.put(messageName, new ArrayList());
        }
        this.callbacks.get(messageName).add(messageCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPendingMessages() {
        ArrayList<EnvelopeOuterClass.Envelope> localPendingMessages;
        List<EnvelopeOuterClass.Envelope> list = this.pendingMessages;
        synchronized (list) {
            localPendingMessages = new ArrayList<EnvelopeOuterClass.Envelope>(this.pendingMessages);
        }
        for (EnvelopeOuterClass.Envelope envelope : localPendingMessages) {
            this.add(envelope);
        }
    }

    private ChannelFuture connect(final boolean reconnect) {
        this.logger.info("Connecting to %s", this.agentUri);
        ChannelFuture future = this.bootstrap.connect(this.agentUri.getHost(), this.agentUri.getPort());
        future.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) {
                if (future.isSuccess()) {
                    future.channel().pipeline().get(RookoutProtocolHandler.class).gotInitialAugs.addListener(new ChannelFutureListener(){

                        @Override
                        public void operationComplete(ChannelFuture future) {
                            AgentComWs.this.channel = future.channel();
                            AgentComWs.this.logger.info("Connected successfully", new Object[0]);
                            AgentComWs.this.backOffResetTask = AgentComWs.this.channel.eventLoop().schedule(new ResetBackoffTask(), 60L, TimeUnit.SECONDS);
                            AgentComWs.this.sendPendingMessages();
                        }
                    });
                }
                if (reconnect) {
                    future.channel().closeFuture().addListener(new ChannelFutureListener(){

                        @Override
                        public void operationComplete(ChannelFuture future) {
                            AgentComWs.this.scheduleReconnection();
                        }
                    });
                }
            }
        });
        return future;
    }

    private void scheduleReconnection() {
        try {
            if (this.eventLoop.isShuttingDown()) {
                return;
            }
            if (this.backOffResetTask != null) {
                this.backOffResetTask.cancel(false);
            }
            ++this.retries;
            this.currentBackoff = Math.min(this.currentBackoff * 2.0, (double)this.config.AgentCom$MAX_SLEEP.intValue());
            RookLogger.Instance().info(String.format("Reconnecting, retry = #%d, waiting %.2fs", this.retries, this.currentBackoff), new Object[0]);
            final AgentComWs self = this;
            this.eventLoop.schedule(new Runnable(){

                @Override
                public void run() {
                    self.connect(true).addListener(new ChannelFutureListener(){

                        @Override
                        public void operationComplete(ChannelFuture future) {
                            if (!future.isSuccess()) {
                                AgentComWs.this.logger.warn("Reconnection failed: " + future.cause().toString(), new Object[0]);
                            }
                        }
                    });
                }
            }, (long)(this.currentBackoff * 1000.0), TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            this.logger.fatal("Error during reconnection: %s: %s", ex.getClass().getName(), ex.getMessage());
        }
    }

    private void initialConnect() throws IOException, InterruptedException, Exceptions.RookInvalidToken {
        Throwable ex;
        ChannelFuture connectionFuture = this.connect(false);
        Channel newChannel = connectionFuture.channel();
        final ChannelPromise initializationFuture = newChannel.newPromise();
        connectionFuture.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) {
                if (!future.isSuccess()) {
                    initializationFuture.setFailure(future.cause());
                    return;
                }
                ChannelPromise gotInitialAugs = future.channel().pipeline().get(RookoutProtocolHandler.class).gotInitialAugs;
                gotInitialAugs.addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future) {
                        if (future.isSuccess()) {
                            AgentComWs.this.channel = future.channel();
                            initializationFuture.setSuccess();
                        } else {
                            initializationFuture.setFailure(future.cause());
                        }
                    }
                });
            }
        });
        boolean done = initializationFuture.await(this.config.AgentCom$WS_CONNECTION_TIMEOUT.intValue(), TimeUnit.SECONDS);
        if (done && !initializationFuture.isSuccess() && (ex = initializationFuture.cause()) instanceof Exceptions.RookInvalidToken) {
            throw new Exceptions.RookInvalidToken(this.token);
        }
        newChannel.closeFuture().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) {
                AgentComWs.this.scheduleReconnection();
            }
        });
        if (!done) {
            throw new IOException("Failed to connect to the controller. Will keep trying");
        }
    }

    @Override
    public void ConnectToAgent() throws Exceptions.RookInvalidToken, IOException {
        try {
            this.initialConnect();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void handleIncomingMessage(Any message) {
        String[] splittedEnvelopeType = message.getTypeUrl().split("\\.", -1);
        String partialTypeName = splittedEnvelopeType[splittedEnvelopeType.length - 1];
        this.callAllCallbacks(partialTypeName, message);
    }

    private void callAllCallbacks(String messageType, Any message) {
        List<MessageCallback> cb = this.callbacks.get(messageType);
        ArrayList<MessageCallback> remainingCallbacks = new ArrayList<MessageCallback>();
        for (MessageCallback messageCallback : cb) {
            messageCallback.callback.call(message);
            if (!messageCallback.persistent.booleanValue()) continue;
            remainingCallbacks.add(messageCallback);
        }
        this.callbacks.put(messageType, remainingCallbacks);
    }

    private HttpProxyHandler buildProxy() {
        URL url;
        String proxyFromEnv = System.getenv("ROOKOUT_PROXY");
        if (proxyFromEnv == null) {
            return null;
        }
        try {
            url = new URL(proxyFromEnv);
        }
        catch (MalformedURLException e) {
            return null;
        }
        InetSocketAddress proxyAddress = new InetSocketAddress(url.getHost(), url.getPort());
        RookLogger.Instance().debug("Connecting via proxy: %s", proxyAddress.toString());
        return new HttpProxyHandler(proxyAddress);
    }

    private Bootstrap buildClient() throws SSLException {
        final SslContext sslContext = this.agentUri.getScheme().equalsIgnoreCase("wss") ? SslContextBuilder.forClient().build() : null;
        final DefaultHttpHeaders headers = new DefaultHttpHeaders();
        headers.add("User-Agent", (Object)String.format("RookoutAgent/%s+%s", Config.Instance().VersionConfiguration$VERSION, Config.Instance().VersionConfiguration$COMMIT));
        if (this.token != null) {
            headers.add("X-Rookout-Token", (Object)this.token);
        }
        final AgentComWs self = this;
        Bootstrap b = new Bootstrap();
        ((Bootstrap)((Bootstrap)b.group(this.eventLoop)).channel(NioSocketChannel.class)).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            public void initChannel(SocketChannel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                HttpProxyHandler proxy = AgentComWs.this.buildProxy();
                if (proxy != null) {
                    pipeline.addLast(proxy);
                }
                if (sslContext != null) {
                    pipeline.addLast(sslContext.newHandler(ch.alloc(), AgentComWs.this.agentUri.getHost(), AgentComWs.this.agentUri.getPort()));
                }
                pipeline.addLast(new WebSocketHandler(AgentComWs.this.agentUri, headers));
                pipeline.addLast(new WebSocketFrameAggregator(65536));
                pipeline.addLast(new IdleStateHandler(((AgentComWs)AgentComWs.this).config.AgentCom$WS_PING_INTERVAL, 0, 0));
                pipeline.addLast(new KeepaliveHandler(((AgentComWs)AgentComWs.this).config.AgentCom$WS_PING_TIMEOUT.intValue()));
                pipeline.addLast(new BytesToWebSocketFrameCodec());
                pipeline.addLast(new ProtobufDecoder(EnvelopeOuterClass.Envelope.getDefaultInstance()));
                pipeline.addLast(new ProtobufEncoder());
                pipeline.addLast(new EnvelopeDecoder());
                pipeline.addLast(new RookoutProtocolHandler(AgentComWs.this.info, self));
                pipeline.addLast(new ChannelInboundHandlerAdapter(){

                    @Override
                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        AgentComWs.this.logger.warn("Error while processing message: %s: %s", cause.getClass().getName(), cause.getMessage());
                        ctx.close();
                    }
                });
            }
        });
        return b;
    }

    @Override
    public void Close() {
        this.eventLoop.shutdownGracefully();
        this.output.FlushMessages();
        this.output.StopSendingMessages();
        if (this.channel != null) {
            this.channel.flush();
            this.channel.close();
        }
    }

    private void resetId() {
        this.agentId = UUID.randomUUID().toString().replace("-", "");
    }

    private class MessageCallback {
        Callable callback;
        Boolean persistent;

        MessageCallback(Callable callback, Boolean persistent) {
            this.callback = callback;
            this.persistent = persistent;
        }
    }

    class ResetBackoffTask
    implements Runnable {
        ResetBackoffTask() {
        }

        @Override
        public void run() {
            if (AgentComWs.this.channel.isActive()) {
                AgentComWs.this.retries = 0;
                AgentComWs.this.currentBackoff = ((AgentComWs)AgentComWs.this).config.AgentComConfiguration$BACK_OFF;
            }
        }
    }

    public static interface Callable {
        public void call(Any var1);
    }
}

