/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.ComWs;

import com.rookout.AgentInfo;
import com.rookout.EnvelopeOuterClass;
import com.rookout.Messages;
import com.rookout.rook.Com.AgentCom;
import com.rookout.rook.Com.OutputBase;
import com.rookout.rook.ComWs.IncomingMessageHandler;
import com.rookout.rook.ComWs.Information;
import com.rookout.rook.ComWs.WSProtocolHandler;
import com.rookout.rook.Config;
import com.rookout.rook.Exceptions;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Utils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.net.ssl.SSLException;
import rook.com.google.protobuf.Any;
import rook.com.google.protobuf.InvalidProtocolBufferException;
import rook.com.google.protobuf.Message;
import rook.io.netty.bootstrap.Bootstrap;
import rook.io.netty.buffer.ByteBuf;
import rook.io.netty.buffer.ByteBufAllocator;
import rook.io.netty.channel.Channel;
import rook.io.netty.channel.ChannelFuture;
import rook.io.netty.channel.ChannelFutureListener;
import rook.io.netty.channel.ChannelInitializer;
import rook.io.netty.channel.ChannelPipeline;
import rook.io.netty.channel.nio.NioEventLoopGroup;
import rook.io.netty.channel.socket.SocketChannel;
import rook.io.netty.channel.socket.nio.NioSocketChannel;
import rook.io.netty.handler.codec.http.DefaultHttpHeaders;
import rook.io.netty.handler.codec.http.HttpClientCodec;
import rook.io.netty.handler.codec.http.HttpObjectAggregator;
import rook.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import rook.io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import rook.io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import rook.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import rook.io.netty.handler.ssl.SslContext;
import rook.io.netty.handler.ssl.SslContextBuilder;
import rook.io.netty.handler.timeout.IdleStateHandler;
import rook.io.netty.util.concurrent.DefaultThreadFactory;

public class AgentComWs
implements AgentCom,
IncomingMessageHandler {
    private Map<String, String> labels;
    private String[] tags;
    protected String agentId;
    private boolean connected;
    private boolean stopping;
    private Double currentBackoff;
    private OutputBase output;
    private URI agentUri;
    private String token;
    private int retries = 0;
    private long lastSuccessfulConnection = 0L;
    private final List<EnvelopeOuterClass.Envelope> pendingMessages;
    private HashMap<String, List<MessageCallback>> callbacks;
    private Channel channel;
    private WSProtocolHandler protocolHandler;
    private NioEventLoopGroup eventLoop;

    public AgentComWs(OutputBase output, String agentHost, int agentPort, String token, Map<String, String> labels, String[] tags) throws URISyntaxException {
        Config config = Config.Instance();
        this.output = output;
        this.agentUri = new URI(String.format("%s:%d/v1", agentHost, agentPort));
        this.labels = labels;
        this.tags = tags;
        this.resetId();
        this.output.setAgentId(this.agentId);
        this.currentBackoff = config.AgentComConfiguration$BACK_OFF;
        this.token = token;
        this.callbacks = new HashMap();
        this.pendingMessages = new ArrayList<EnvelopeOuterClass.Envelope>();
        this.eventLoop = new NioEventLoopGroup(0, new DefaultThreadFactory("rookout-agentCom", true));
    }

    public <T extends Message> void add(T message) {
        final EnvelopeOuterClass.Envelope envelope = this.wrapInEnvelope(message);
        this.eventLoop.execute(new Runnable(){

            @Override
            public void run() {
                AgentComWs.this.send(envelope);
            }
        });
    }

    public void on(String messageName, Callable callback) {
        this.registerCallback(messageName, callback, true);
    }

    public void once(String messageName, Callable callback) {
        this.registerCallback(messageName, callback, false);
    }

    private void registerCallback(String messageName, Callable callback, Boolean persistent) {
        MessageCallback messageCallback = new MessageCallback(callback, persistent);
        if (!this.callbacks.containsKey(messageName)) {
            this.callbacks.put(messageName, new ArrayList());
        }
        this.callbacks.get(messageName).add(messageCallback);
    }

    private CountDownLatch awaitMessage(String messageName) {
        final CountDownLatch latch = new CountDownLatch(1);
        this.once(messageName, new Callable(){

            @Override
            public void call(Any any) {
                latch.countDown();
            }
        });
        return latch;
    }

    private void registerAgent() throws IOException {
        Information info = Information.Collect();
        info.agentId = this.agentId;
        info.labels = this.labels;
        info.tags = this.tags;
        AgentInfo.AgentInformation packedInfo = Information.PackAgentInfo(info);
        CountDownLatch gotInitialAugsCommand = this.awaitMessage("InitialAugsCommand");
        Messages.NewAgentMessage.Builder m = Messages.NewAgentMessage.newBuilder();
        m.setAgentInfo(packedInfo);
        this.connected = true;
        this.lastSuccessfulConnection = System.currentTimeMillis();
        this.send(this.wrapInEnvelope(m.build()));
        try {
            gotInitialAugsCommand.await(Config.Instance().AgentCom$WS_CONNECTION_TIMEOUT.intValue(), TimeUnit.SECONDS);
        }
        catch (InterruptedException exc) {
            throw new IOException("Failed to sync with agent. Will keep trying");
        }
    }

    protected <T extends Message> EnvelopeOuterClass.Envelope wrapInEnvelope(T message) {
        EnvelopeOuterClass.Envelope.Builder envelope = EnvelopeOuterClass.Envelope.newBuilder();
        envelope.setTimestamp(Utils.dateToTimestamp(new Date()));
        envelope.setMsg(Any.pack(message));
        return envelope.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void send(EnvelopeOuterClass.Envelope envelope) {
        if (!this.connected) {
            List<EnvelopeOuterClass.Envelope> list = this.pendingMessages;
            synchronized (list) {
                if (this.pendingMessages.size() < Config.Instance().AgentComConfiguration$MAX_QUEUED_MESSAGES) {
                    this.pendingMessages.add(envelope);
                    return;
                }
            }
        }
        ByteBuf b = ByteBufAllocator.DEFAULT.buffer();
        b.writeBytes(envelope.toByteArray());
        this.channel.writeAndFlush(new BinaryWebSocketFrame(b));
    }

    private void waitForConnection() throws Exceptions.RookInvalidToken, IOException {
        try {
            Throwable exc;
            ChannelFuture future = this.protocolHandler.handshakeFuture();
            boolean done = future.await(Config.Instance().AgentCom$WS_CONNECTION_TIMEOUT.intValue(), TimeUnit.SECONDS);
            if (!done) {
                throw new IOException("Failed to connect to agent. Will keep trying");
            }
            if (!future.isSuccess() && (exc = future.cause()) instanceof Exceptions.RookInvalidToken) {
                throw new Exceptions.RookInvalidToken(this.token);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ConnectToAgent() throws Exceptions.RookInvalidToken {
        try {
            ArrayList<EnvelopeOuterClass.Envelope> copyPendingMessages;
            this.BuildClient();
            this.waitForConnection();
            this.registerAgent();
            List<EnvelopeOuterClass.Envelope> list = this.pendingMessages;
            synchronized (list) {
                copyPendingMessages = new ArrayList<EnvelopeOuterClass.Envelope>(this.pendingMessages);
                this.pendingMessages.clear();
            }
            for (EnvelopeOuterClass.Envelope env : copyPendingMessages) {
                this.send(env);
            }
        }
        catch (Exceptions.RookInvalidToken e) {
            throw e;
        }
        catch (IOException e) {
            this.eventLoop.execute(new Runnable(){

                @Override
                public void run() {
                    AgentComWs.this.reconnect(e.getMessage());
                }
            });
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void handleIncomingMessage(ByteBuffer data) {
        EnvelopeOuterClass.Envelope envelope;
        try {
            envelope = EnvelopeOuterClass.Envelope.parseFrom(data.array());
        }
        catch (InvalidProtocolBufferException exc) {
            RookLogger.Instance().log(Level.SEVERE, "Invalid protocol exception", exc, new Object[0]);
            return;
        }
        String[] splittedEnvelopeType = envelope.getMsg().getTypeUrl().split("\\.", -1);
        String partialTypeName = splittedEnvelopeType[splittedEnvelopeType.length - 1];
        this.callAllCallbacks(partialTypeName, envelope.getMsg());
    }

    private void callAllCallbacks(String messageType, Any message) {
        List<MessageCallback> cb = this.callbacks.get(messageType);
        ArrayList<MessageCallback> remainingCallbacks = new ArrayList<MessageCallback>();
        for (MessageCallback messageCallback : cb) {
            messageCallback.callback.call(message);
            if (!messageCallback.persistent.booleanValue()) continue;
            remainingCallbacks.add(messageCallback);
        }
        this.callbacks.put(messageType, remainingCallbacks);
    }

    private void BuildClient() throws SSLException, InterruptedException {
        RookLogger.Instance().info("Connecting to controller: %s", this.agentUri);
        Bootstrap bootstrap = new Bootstrap();
        final SslContext sslContext = this.agentUri.getScheme().equalsIgnoreCase("wss") ? SslContextBuilder.forClient().build() : null;
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        headers.add("User-Agent", (Object)String.format("RookoutAgent/%s+%s", Config.Instance().VersionConfiguration$VERSION, Config.Instance().VersionConfiguration$COMMIT));
        if (this.token != null) {
            headers.add("X-Rookout-Token", (Object)this.token);
        }
        this.protocolHandler = new WSProtocolHandler(WebSocketClientHandshakerFactory.newHandshaker(this.agentUri, WebSocketVersion.V13, null, false, headers), this);
        ((Bootstrap)((Bootstrap)bootstrap.group(this.eventLoop)).channel(NioSocketChannel.class)).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new IdleStateHandler(30, 0, 0));
                if (sslContext != null) {
                    pipeline.addLast(sslContext.newHandler(ch.alloc(), AgentComWs.this.agentUri.getHost(), AgentComWs.this.agentUri.getPort()));
                }
                pipeline.addLast(new HttpClientCodec());
                pipeline.addLast(new HttpObjectAggregator(65536));
                pipeline.addLast(new WebSocketFrameAggregator(65536));
                pipeline.addLast(AgentComWs.this.protocolHandler);
            }
        });
        this.channel = bootstrap.connect(this.agentUri.getHost(), this.agentUri.getPort()).sync().channel();
        this.channel.closeFuture().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) {
                AgentComWs.this.eventLoop.execute(new Runnable(){

                    @Override
                    public void run() {
                        AgentComWs.this.reconnect("Disconnected");
                    }
                });
            }
        });
    }

    private void reconnect(String reason) {
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.stopping) {
            return;
        }
        long MaxSleepMs = Config.Instance().AgentCom$WS_RESET_BACKOFF_TIMEOUT * 1000;
        if (this.connected && System.currentTimeMillis() > this.lastSuccessfulConnection + MaxSleepMs) {
            this.retries = 0;
            this.currentBackoff = Config.Instance().AgentComConfiguration$BACK_OFF;
        }
        this.connected = false;
        ++this.retries;
        this.currentBackoff = Math.min(this.currentBackoff * 2.0, (double)Config.Instance().AgentCom$MAX_SLEEP.intValue());
        RookLogger.Instance().info(String.format("Connection failed; reason = %s, retry = #%d, waiting %.2fs", reason, this.retries, this.currentBackoff), new Object[0]);
        this.eventLoop.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    AgentComWs.this.ConnectToAgent();
                }
                catch (Exceptions.RookInvalidToken e) {
                    RookLogger.Instance().log(Level.SEVERE, "Failed to connect to the agent: ", e.getMessage());
                }
            }
        }, (long)(this.currentBackoff * 1000.0), TimeUnit.MILLISECONDS);
    }

    @Override
    public void Close() {
        this.stopping = true;
        this.output.FlushMessages();
        this.output.StopSendingMessages();
        this.channel.close();
    }

    private void resetId() {
        this.agentId = UUID.randomUUID().toString().replace("-", "");
    }

    private class MessageCallback {
        Callable callback;
        Boolean persistent;

        public MessageCallback(Callable callback, Boolean persistent) {
            this.callback = callback;
            this.persistent = persistent;
        }
    }

    public static interface Callable {
        public void call(Any var1);
    }
}

