/*
 * Decompiled with CFR 0.152.
 */
package rook.io.grpc.internal;

import com.rookout.java.util.logging.Logger;
import java.util.logging.Level;
import rook.com.google.common.base.Preconditions;
import rook.io.grpc.internal.MoreThrowables;

public final class LogExceptionRunnable
implements Runnable {
    private static final Logger log = Logger.getLogger(LogExceptionRunnable.class.getName());
    private final Runnable task;

    public LogExceptionRunnable(Runnable task) {
        this.task = Preconditions.checkNotNull(task, "task");
    }

    @Override
    public void run() {
        try {
            this.task.run();
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Exception while executing runnable " + this.task, t);
            MoreThrowables.throwIfUnchecked(t);
            throw new AssertionError((Object)t);
        }
    }

    public String toString() {
        return "LogExceptionRunnable(" + this.task + ")";
    }
}

