/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.ComWs;

import com.rookout.rook.ComWs.IncomingMessageHandler;
import com.rookout.rook.Exceptions;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import rook.io.netty.channel.Channel;
import rook.io.netty.channel.ChannelFuture;
import rook.io.netty.channel.ChannelHandlerContext;
import rook.io.netty.channel.ChannelPromise;
import rook.io.netty.channel.SimpleChannelInboundHandler;
import rook.io.netty.handler.codec.http.FullHttpResponse;
import rook.io.netty.handler.codec.http.HttpResponseStatus;
import rook.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import rook.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import rook.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import rook.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import rook.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import rook.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import rook.io.netty.handler.timeout.IdleState;
import rook.io.netty.handler.timeout.IdleStateEvent;

public class WSProtocolHandler
extends SimpleChannelInboundHandler<Object> {
    private final WebSocketClientHandshaker handshaker;
    private ChannelPromise handshakeFuture;
    private final IncomingMessageHandler messageHandler;
    private boolean waitingPing;

    public WSProtocolHandler(WebSocketClientHandshaker handshaker, IncomingMessageHandler messageHandler) {
        this.handshaker = handshaker;
        this.messageHandler = messageHandler;
    }

    public ChannelFuture handshakeFuture() {
        return this.handshakeFuture;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.handshakeFuture = ctx.newPromise();
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.handshaker.handshake(ctx.channel());
    }

    @Override
    public void userEventTriggered(final ChannelHandlerContext ctx, Object evt) {
        IdleStateEvent idleEvent;
        if (evt instanceof IdleStateEvent && (idleEvent = (IdleStateEvent)evt).state() == IdleState.READER_IDLE) {
            this.waitingPing = true;
            ctx.channel().writeAndFlush(new PingWebSocketFrame());
            ctx.executor().schedule(new Runnable(){

                @Override
                public void run() {
                    if (WSProtocolHandler.this.waitingPing) {
                        ctx.channel().close();
                    }
                }
            }, 10L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void channelRead0(ChannelHandlerContext ctx, Object msg) {
        Channel ch = ctx.channel();
        if (!this.handshaker.isHandshakeComplete()) {
            FullHttpResponse response = (FullHttpResponse)msg;
            if (response.status() == HttpResponseStatus.FORBIDDEN) {
                this.handshakeFuture.setFailure(new Exceptions.RookInvalidToken());
            } else {
                this.handshaker.finishHandshake(ch, (FullHttpResponse)msg);
                this.handshakeFuture.setSuccess();
            }
            return;
        }
        WebSocketFrame frame = (WebSocketFrame)msg;
        if (frame instanceof CloseWebSocketFrame) {
            ch.close();
        } else if (frame instanceof PingWebSocketFrame) {
            PingWebSocketFrame ping = (PingWebSocketFrame)frame;
            ch.writeAndFlush(new PongWebSocketFrame(ping.content().retain()));
        } else if (frame instanceof PongWebSocketFrame) {
            this.waitingPing = false;
        } else if (frame instanceof BinaryWebSocketFrame) {
            BinaryWebSocketFrame binaryFrame = (BinaryWebSocketFrame)frame;
            ByteBuffer buf = ByteBuffer.allocate(binaryFrame.content().readableBytes());
            frame.content().readBytes(buf);
            this.messageHandler.handleIncomingMessage(buf);
        }
    }
}

