/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Augs;

import com.rookout.rook.Augs.Actions.Action;
import com.rookout.rook.Augs.Conditions.Condition;
import com.rookout.rook.Augs.Locations.Location;
import com.rookout.rook.Augs.WarningCache;
import com.rookout.rook.Com.Output;
import com.rookout.rook.Com.OutputBase;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import com.rookout.rook.Processor.Namespaces.FrameNamespace;
import com.rookout.rook.Processor.Namespaces.JavaUtilsNamespace;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.Processor.Namespaces.StackNamespace;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Services.Frame;
import com.rookout.rook.TriggerServices;
import com.rookout.rook.UserWarnings;
import com.rookout.rook.Utils;
import com.rookout.rook.WarningReporter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;

public class Aug
implements WarningReporter {
    public String augId;
    private Location location;
    private Action action;
    private OutputBase output;
    private double minTimeBetweenHits;
    private double maxAugTime;
    private double lastExecuted = 0.0;
    private Condition condition;
    private String status = "";
    private boolean enabled = true;
    private WarningCache warningCache;

    public Aug(String augId, Location location, Action action, Output output) {
        this(augId, location, action, null, output, 0.0, 0.0);
    }

    public Aug(String augId, Location location, Action action, Condition condition, OutputBase output, double minTimeBetweenHits, double maxAugTime) {
        this.augId = augId;
        this.location = location;
        this.action = action;
        this.output = output;
        this.minTimeBetweenHits = minTimeBetweenHits;
        this.maxAugTime = maxAugTime;
        this.condition = condition;
        this.warningCache = new WarningCache(10);
    }

    public void AddAug(TriggerServices triggerServices) {
        try {
            this.location.AddAug(triggerServices, this);
        }
        catch (Throwable e) {
            String message = "Exception when adding aug";
            RookLogger.Instance().log(Level.SEVERE, message, e);
            this.SetError(new RookError(e, message));
        }
    }

    public void Execute(final Frame frame, final Namespace extracted) {
        if (!this.enabled) {
            return;
        }
        try (UserWarnings reporter = new UserWarnings(this);){
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() {
                    boolean executed = false;
                    try {
                        double now = Utils.getTimeInMillisDouble();
                        Namespace fixedExtracted = extracted;
                        if (null == fixedExtracted) {
                            fixedExtracted = new ContainerNamespace();
                        }
                        ContainerNamespace namespace = new ContainerNamespace();
                        namespace.WriteAttribute("frame", new FrameNamespace(frame));
                        namespace.WriteAttribute("stack", new StackNamespace(frame));
                        namespace.WriteAttribute("extracted", fixedExtracted);
                        namespace.WriteAttribute("store", new ContainerNamespace());
                        namespace.WriteAttribute("temp", new ContainerNamespace());
                        namespace.WriteAttribute("utils", new JavaUtilsNamespace());
                        if (Aug.this.condition == null || Aug.this.condition.evaluate(namespace)) {
                            executed = true;
                            if (now < Aug.this.lastExecuted + Aug.this.minTimeBetweenHits) {
                                RookLogger.Instance().log(Level.WARNING, "Removing rule due to rate limiting - " + Aug.this.augId);
                                Aug.this.enabled = false;
                                Aug.this.SetError(new RookError(new Exceptions.RookRuleRateLimited()));
                                Object var6_6 = null;
                                return var6_6;
                            }
                            RookLogger.Instance().log(Level.INFO, "Executing aug - " + Aug.this.augId);
                            Aug.this.action.Execute(Aug.this.augId, namespace, Aug.this.output);
                        }
                        if (Aug.this.maxAugTime > 0.0 && Utils.getTimeInMillisDouble() > now + Aug.this.maxAugTime) {
                            RookLogger.Instance().log(Level.WARNING, "Removing rule because max execution time was reached - " + Aug.this.augId);
                            Aug.this.enabled = false;
                            Aug.this.SetError(new RookError(new Exceptions.RookRuleMaxExecutionTimeReached()));
                            Object var6_7 = null;
                            return var6_7;
                        }
                    }
                    catch (Throwable e) {
                        String message = "Exception while processing Aug";
                        RookLogger.Instance().log(Level.SEVERE, message, e);
                        Aug.this.SendWarning(new RookError(e, message));
                    }
                    finally {
                        if (executed) {
                            Aug.this.lastExecuted = Utils.getTimeInMillisDouble();
                        }
                    }
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void SetActive() {
        this.SendRuleStatus("Active", null);
    }

    public void SetPending() {
        this.SendRuleStatus("Pending", null);
    }

    public void SetRemoved() {
        this.SendRuleStatus("Deleted", null);
    }

    public void SetError(RookError error) {
        this.SendRuleStatus("Error", error);
    }

    public void SetUnknown(RookError error) {
        this.SendRuleStatus("Unknown", error);
    }

    @Override
    public void SendWarning(RookError error) {
        if (this.ShouldSilenceWarning(error)) {
            RookLogger.Instance().log(Level.FINE, "Silencing warning " + error.getMessage() + " for rule: " + this.augId);
            return;
        }
        RookLogger.Instance().log(Level.WARNING, error.getMessage());
        this.output.SendWarning(this.augId, error);
    }

    @Override
    public void SendError(RookError error) {
        RookLogger.Instance().log(Level.SEVERE, error.getMessage());
        this.SetError(error);
    }

    protected void SendRuleStatus(String status, RookError error) {
        if (this.status.equals(status)) {
            return;
        }
        RookLogger.Instance().log(Level.INFO, "Updating rule status for: " + this.augId + " to " + status);
        this.status = status;
        this.output.SendRuleStatus(this.augId, status, error);
    }

    private boolean ShouldSilenceWarning(RookError error) {
        String message = error.getMessage();
        if (this.warningCache.isFull() || this.warningCache.contains(message)) {
            return true;
        }
        this.warningCache.put(message);
        return false;
    }
}

