/*
 * Decompiled with CFR 0.152.
 */
package rook.org.glassfish.tyrus.core;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import javax.websocket.Extension;
import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import rook.org.glassfish.tyrus.core.AsyncMessageHandler;
import rook.org.glassfish.tyrus.core.BasicMessageHandler;
import rook.org.glassfish.tyrus.core.BinaryBuffer;
import rook.org.glassfish.tyrus.core.DebugContext;
import rook.org.glassfish.tyrus.core.ExecutorServiceProvider;
import rook.org.glassfish.tyrus.core.InputStreamBuffer;
import rook.org.glassfish.tyrus.core.MessageHandlerManager;
import rook.org.glassfish.tyrus.core.MessageTooBigException;
import rook.org.glassfish.tyrus.core.ReaderBuffer;
import rook.org.glassfish.tyrus.core.TextBuffer;
import rook.org.glassfish.tyrus.core.TyrusEndpointWrapper;
import rook.org.glassfish.tyrus.core.TyrusRemoteEndpoint;
import rook.org.glassfish.tyrus.core.TyrusWebSocket;
import rook.org.glassfish.tyrus.core.cluster.ClusterContext;
import rook.org.glassfish.tyrus.core.cluster.DistributedSession;
import rook.org.glassfish.tyrus.core.cluster.RemoteSession;
import rook.org.glassfish.tyrus.core.cluster.SessionEventListener;
import rook.org.glassfish.tyrus.core.coder.CoderWrapper;
import rook.org.glassfish.tyrus.core.l10n.LocalizationMessages;

public class TyrusSession
implements Session,
DistributedSession {
    private static final Logger LOGGER = Logger.getLogger(TyrusSession.class.getName());
    private final WebSocketContainer container;
    private final TyrusEndpointWrapper endpointWrapper;
    private final TyrusRemoteEndpoint.Basic basicRemote;
    private final TyrusRemoteEndpoint.Async asyncRemote;
    private final boolean isSecure;
    private final URI requestURI;
    private final String queryString;
    private final Map<String, String> pathParameters;
    private final Principal userPrincipal;
    private final Map<String, List<String>> requestParameterMap;
    private final Object idleTimeoutLock = new Object();
    private final String id;
    private final String connectionId;
    private final Map<String, Object> userProperties;
    private final MessageHandlerManager handlerManager;
    private final AtomicReference<State> state = new AtomicReference<State>(State.RUNNING);
    private final TextBuffer textBuffer = new TextBuffer();
    private final BinaryBuffer binaryBuffer = new BinaryBuffer();
    private final List<Extension> negotiatedExtensions;
    private final String negotiatedSubprotocol;
    private final String remoteAddr;
    private final DebugContext debugContext;
    private final Map<RemoteSession.DistributedMapKey, Object> distributedPropertyMap;
    private final Map<String, Object> distributedUserProperties;
    private volatile long maxIdleTimeout = 0L;
    private volatile ScheduledFuture<?> idleTimeoutFuture = null;
    private int maxBinaryMessageBufferSize = Integer.MAX_VALUE;
    private int maxTextMessageBufferSize = Integer.MAX_VALUE;
    private ScheduledExecutorService service;
    private ReaderBuffer readerBuffer;
    private InputStreamBuffer inputStreamBuffer;
    private volatile long heartbeatInterval;
    private volatile ScheduledFuture<?> heartbeatTask;

    TyrusSession(WebSocketContainer container, TyrusWebSocket socket, TyrusEndpointWrapper endpointWrapper, String subprotocol, List<Extension> extensions, boolean isSecure, URI requestURI, String queryString, Map<String, String> pathParameters, Principal principal, Map<String, List<String>> requestParameterMap, ClusterContext clusterContext, String connectionId, String remoteAddr, DebugContext debugContext) {
        this.container = container;
        this.endpointWrapper = endpointWrapper;
        this.negotiatedExtensions = extensions == null ? Collections.emptyList() : Collections.unmodifiableList(extensions);
        this.negotiatedSubprotocol = subprotocol == null ? "" : subprotocol;
        this.isSecure = isSecure;
        this.requestURI = requestURI;
        this.queryString = queryString;
        this.pathParameters = pathParameters == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, String>(pathParameters));
        this.basicRemote = new TyrusRemoteEndpoint.Basic(this, socket, endpointWrapper);
        this.asyncRemote = new TyrusRemoteEndpoint.Async(this, socket, endpointWrapper);
        this.handlerManager = MessageHandlerManager.fromDecoderInstances(endpointWrapper.getDecoders());
        this.userPrincipal = principal;
        this.requestParameterMap = requestParameterMap == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, List<String>>(requestParameterMap));
        this.connectionId = connectionId;
        this.remoteAddr = remoteAddr;
        this.debugContext = debugContext;
        if (container != null) {
            this.maxTextMessageBufferSize = container.getDefaultMaxTextMessageBufferSize();
            this.maxBinaryMessageBufferSize = container.getDefaultMaxBinaryMessageBufferSize();
            this.service = ((ExecutorServiceProvider)((Object)container)).getScheduledExecutorService();
            this.setMaxIdleTimeout(container.getDefaultMaxSessionIdleTimeout());
        }
        if (clusterContext != null) {
            this.id = clusterContext.createSessionId();
            this.distributedPropertyMap = clusterContext.getDistributedSessionProperties(this.id);
            this.distributedPropertyMap.put(RemoteSession.DistributedMapKey.NEGOTIATED_SUBPROTOCOL, this.negotiatedSubprotocol);
            this.distributedPropertyMap.put(RemoteSession.DistributedMapKey.NEGOTIATED_EXTENSIONS, this.negotiatedExtensions);
            this.distributedPropertyMap.put(RemoteSession.DistributedMapKey.SECURE, isSecure);
            this.distributedPropertyMap.put(RemoteSession.DistributedMapKey.MAX_IDLE_TIMEOUT, this.maxIdleTimeout);
            this.distributedPropertyMap.put(RemoteSession.DistributedMapKey.MAX_BINARY_MESSAGE_BUFFER_SIZE, this.maxBinaryMessageBufferSize);
            this.distributedPropertyMap.put(RemoteSession.DistributedMapKey.MAX_TEXT_MESSAGE_BUFFER_SIZE, this.maxTextMessageBufferSize);
            this.distributedPropertyMap.put(RemoteSession.DistributedMapKey.REQUEST_URI, requestURI);
            this.distributedPropertyMap.put(RemoteSession.DistributedMapKey.REQUEST_PARAMETER_MAP, requestParameterMap);
            this.distributedPropertyMap.put(RemoteSession.DistributedMapKey.QUERY_STRING, queryString == null ? "" : queryString);
            this.distributedPropertyMap.put(RemoteSession.DistributedMapKey.PATH_PARAMETERS, this.pathParameters);
            this.distributedPropertyMap.put(RemoteSession.DistributedMapKey.CONNECTION_ID, this.connectionId);
            if (this.userPrincipal != null) {
                this.distributedPropertyMap.put(RemoteSession.DistributedMapKey.USER_PRINCIPAL, this.userPrincipal);
            }
            this.distributedUserProperties = clusterContext.getDistributedUserProperties(connectionId);
            clusterContext.registerSession(this.id, endpointWrapper.getEndpointPath(), new SessionEventListener(this));
        } else {
            this.id = UUID.randomUUID().toString();
            this.distributedPropertyMap = null;
            this.distributedUserProperties = new HashMap<String, Object>();
        }
        debugContext.setSessionId(this.id);
        this.userProperties = new HashMap<String, Object>();
    }

    @Override
    public String getProtocolVersion() {
        return "13";
    }

    @Override
    public String getNegotiatedSubprotocol() {
        return this.negotiatedSubprotocol;
    }

    @Override
    public RemoteEndpoint.Async getAsyncRemote() {
        this.checkConnectionState(State.CLOSED);
        return this.asyncRemote;
    }

    @Override
    public RemoteEndpoint.Basic getBasicRemote() {
        this.checkConnectionState(State.CLOSED);
        return this.basicRemote;
    }

    @Override
    public boolean isOpen() {
        return this.state.get() != State.CLOSED;
    }

    @Override
    public void close() throws IOException {
        this.cleanAfterClose();
        this.changeStateToClosed();
        this.basicRemote.close(new CloseReason(CloseReason.CloseCodes.NORMAL_CLOSURE, null));
    }

    @Override
    public void close(CloseReason closeReason) throws IOException {
        this.cleanAfterClose();
        this.checkConnectionState(State.CLOSED);
        this.changeStateToClosed();
        this.basicRemote.close(closeReason);
    }

    @Override
    public int getMaxBinaryMessageBufferSize() {
        return this.maxBinaryMessageBufferSize;
    }

    @Override
    public void setMaxBinaryMessageBufferSize(int maxBinaryMessageBufferSize) {
        this.checkConnectionState(State.CLOSED);
        this.maxBinaryMessageBufferSize = maxBinaryMessageBufferSize;
        if (this.distributedPropertyMap != null) {
            this.distributedPropertyMap.put(RemoteSession.DistributedMapKey.MAX_BINARY_MESSAGE_BUFFER_SIZE, maxBinaryMessageBufferSize);
        }
    }

    @Override
    public int getMaxTextMessageBufferSize() {
        return this.maxTextMessageBufferSize;
    }

    @Override
    public void setMaxTextMessageBufferSize(int maxTextMessageBufferSize) {
        this.checkConnectionState(State.CLOSED);
        this.maxTextMessageBufferSize = maxTextMessageBufferSize;
        if (this.distributedPropertyMap != null) {
            this.distributedPropertyMap.put(RemoteSession.DistributedMapKey.MAX_TEXT_MESSAGE_BUFFER_SIZE, maxTextMessageBufferSize);
        }
    }

    @Override
    public Set<Session> getOpenSessions() {
        HashSet<TyrusSession> openSessions = new HashSet<TyrusSession>();
        openSessions.addAll(this.endpointWrapper.getOpenSessions());
        return Collections.unmodifiableSet(openSessions);
    }

    public Set<RemoteSession> getRemoteSessions() {
        return this.endpointWrapper.getRemoteSessions();
    }

    public Set<DistributedSession> getAllSessions() {
        HashSet<DistributedSession> result = new HashSet<DistributedSession>();
        result.addAll(this.endpointWrapper.getOpenSessions());
        result.addAll(this.endpointWrapper.getRemoteSessions());
        return Collections.unmodifiableSet(result);
    }

    @Override
    public List<Extension> getNegotiatedExtensions() {
        return this.negotiatedExtensions;
    }

    @Override
    public long getMaxIdleTimeout() {
        return this.maxIdleTimeout;
    }

    @Override
    public void setMaxIdleTimeout(long maxIdleTimeout) {
        this.checkConnectionState(State.CLOSED);
        this.maxIdleTimeout = maxIdleTimeout;
        this.restartIdleTimeoutExecutor();
        if (this.distributedPropertyMap != null) {
            this.distributedPropertyMap.put(RemoteSession.DistributedMapKey.MAX_IDLE_TIMEOUT, maxIdleTimeout);
        }
    }

    @Override
    public boolean isSecure() {
        return this.isSecure;
    }

    @Override
    public WebSocketContainer getContainer() {
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessageHandler(MessageHandler handler) {
        this.checkConnectionState(State.CLOSED);
        MessageHandlerManager messageHandlerManager = this.handlerManager;
        synchronized (messageHandlerManager) {
            this.handlerManager.addMessageHandler(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void addMessageHandler(Class<T> clazz, MessageHandler.Whole<T> handler) {
        this.checkConnectionState(State.CLOSED);
        MessageHandlerManager messageHandlerManager = this.handlerManager;
        synchronized (messageHandlerManager) {
            this.handlerManager.addMessageHandler(clazz, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void addMessageHandler(Class<T> clazz, MessageHandler.Partial<T> handler) {
        this.checkConnectionState(State.CLOSED);
        MessageHandlerManager messageHandlerManager = this.handlerManager;
        synchronized (messageHandlerManager) {
            this.handlerManager.addMessageHandler(clazz, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<MessageHandler> getMessageHandlers() {
        MessageHandlerManager messageHandlerManager = this.handlerManager;
        synchronized (messageHandlerManager) {
            return this.handlerManager.getMessageHandlers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMessageHandler(MessageHandler handler) {
        this.checkConnectionState(State.CLOSED);
        MessageHandlerManager messageHandlerManager = this.handlerManager;
        synchronized (messageHandlerManager) {
            this.handlerManager.removeMessageHandler(handler);
        }
    }

    @Override
    public URI getRequestURI() {
        return this.requestURI;
    }

    @Override
    public Map<String, List<String>> getRequestParameterMap() {
        return this.requestParameterMap;
    }

    @Override
    public Map<String, String> getPathParameters() {
        return this.pathParameters;
    }

    @Override
    public Map<String, Object> getUserProperties() {
        return this.userProperties;
    }

    @Override
    public Map<String, Object> getDistributedProperties() {
        return this.distributedUserProperties;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public Map<Session, Future<?>> broadcast(String message) {
        return this.endpointWrapper.broadcast(message);
    }

    public Map<Session, Future<?>> broadcast(ByteBuffer message) {
        return this.endpointWrapper.broadcast(message);
    }

    public long getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void setHeartbeatInterval(long heartbeatInterval) {
        this.checkConnectionState(State.CLOSED);
        this.heartbeatInterval = heartbeatInterval;
        this.cancelHeartBeatTask();
        if (heartbeatInterval < 1L) {
            return;
        }
        this.heartbeatTask = this.service.scheduleAtFixedRate(new HeartbeatCommand(), heartbeatInterval, heartbeatInterval, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restartIdleTimeoutExecutor() {
        if (this.maxIdleTimeout < 1L) {
            Object object = this.idleTimeoutLock;
            synchronized (object) {
                if (this.idleTimeoutFuture != null) {
                    this.idleTimeoutFuture.cancel(true);
                }
                return;
            }
        }
        Object object = this.idleTimeoutLock;
        synchronized (object) {
            if (this.idleTimeoutFuture != null) {
                this.idleTimeoutFuture.cancel(false);
            }
            this.idleTimeoutFuture = this.service.schedule(new IdleTimeoutCommand(), this.getMaxIdleTimeout(), TimeUnit.MILLISECONDS);
        }
    }

    private void checkConnectionState(State ... states) {
        State sessionState = this.state.get();
        for (State s : states) {
            if (sessionState != s) continue;
            throw new IllegalStateException(LocalizationMessages.CONNECTION_HAS_BEEN_CLOSED());
        }
    }

    private void checkMessageSize(Object message, long maxMessageSize) {
        long messageSize;
        if (maxMessageSize != -1L && (messageSize = (long)(message instanceof String ? ((String)message).getBytes(Charset.defaultCharset()).length : ((ByteBuffer)message).remaining())) > maxMessageSize) {
            throw new MessageTooBigException(LocalizationMessages.MESSAGE_TOO_LONG(maxMessageSize, messageSize));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyMessageHandlers(Object message, List<CoderWrapper<Decoder>> availableDecoders) throws DecodeException, IOException {
        List<Map.Entry<Class<?>, MessageHandler>> orderedMessageHandlers;
        boolean decoded = false;
        if (availableDecoders.isEmpty()) {
            LOGGER.warning(LocalizationMessages.NO_DECODER_FOUND());
        }
        MessageHandlerManager messageHandlerManager = this.handlerManager;
        synchronized (messageHandlerManager) {
            orderedMessageHandlers = this.handlerManager.getOrderedWholeMessageHandlers();
        }
        for (CoderWrapper<Decoder> decoder : availableDecoders) {
            for (Map.Entry<Class<?>, MessageHandler> entry : orderedMessageHandlers) {
                Object object;
                MessageHandler mh = entry.getValue();
                Class<?> type = entry.getKey();
                if (!type.isAssignableFrom(decoder.getType())) continue;
                if (mh instanceof BasicMessageHandler) {
                    this.checkMessageSize(message, ((BasicMessageHandler)mh).getMaxMessageSize());
                }
                if ((object = this.endpointWrapper.decodeCompleteMessage(this, message, type, decoder)) == null) continue;
                State currentState = this.state.get();
                if (currentState != State.CLOSED) {
                    ((MessageHandler.Whole)mh).onMessage(object);
                }
                decoded = true;
                break;
            }
            if (!decoded) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> MessageHandler.Whole<T> getMessageHandler(Class<T> c) {
        List<Map.Entry<Class<?>, MessageHandler>> orderedMessageHandlers;
        MessageHandlerManager messageHandlerManager = this.handlerManager;
        synchronized (messageHandlerManager) {
            orderedMessageHandlers = this.handlerManager.getOrderedWholeMessageHandlers();
        }
        for (Map.Entry<Class<?>, MessageHandler> entry : orderedMessageHandlers) {
            if (!entry.getKey().equals(c)) continue;
            return (MessageHandler.Whole)entry.getValue();
        }
        return null;
    }

    void notifyMessageHandlers(Object message, boolean last) {
        boolean handled = false;
        for (MessageHandler handler : this.getMessageHandlers()) {
            State currentState;
            if (!(handler instanceof MessageHandler.Partial) || !MessageHandlerManager.getHandlerType(handler).isAssignableFrom(message.getClass())) continue;
            if (handler instanceof AsyncMessageHandler) {
                this.checkMessageSize(message, ((AsyncMessageHandler)handler).getMaxMessageSize());
            }
            if ((currentState = this.state.get()) != State.CLOSED) {
                ((MessageHandler.Partial)handler).onMessage(message, last);
            }
            handled = true;
            break;
        }
        if (!handled) {
            if (message instanceof ByteBuffer) {
                this.notifyMessageHandlers((Object)((ByteBuffer)message).array(), last);
            } else {
                LOGGER.warning(LocalizationMessages.UNHANDLED_TEXT_MESSAGE(this));
            }
        }
    }

    void notifyPongHandler(PongMessage pongMessage) {
        Set<MessageHandler> messageHandlers = this.getMessageHandlers();
        for (MessageHandler handler : messageHandlers) {
            if (!MessageHandlerManager.getHandlerType(handler).equals(PongMessage.class)) continue;
            ((MessageHandler.Whole)handler).onMessage(pongMessage);
        }
    }

    boolean isWholeTextHandlerPresent() {
        return this.handlerManager.isWholeTextHandlerPresent();
    }

    boolean isWholeBinaryHandlerPresent() {
        return this.handlerManager.isWholeBinaryHandlerPresent();
    }

    boolean isPartialTextHandlerPresent() {
        return this.handlerManager.isPartialTextHandlerPresent();
    }

    boolean isPartialBinaryHandlerPresent() {
        return this.handlerManager.isPartialBinaryHandlerPresent();
    }

    boolean isReaderHandlerPresent() {
        return this.handlerManager.isReaderHandlerPresent();
    }

    boolean isInputStreamHandlerPresent() {
        return this.handlerManager.isInputStreamHandlerPresent();
    }

    boolean isPongHandlerPresent() {
        return this.handlerManager.isPongHandlerPresent();
    }

    State getState() {
        return this.state.get();
    }

    String getConnectionId() {
        return this.connectionId;
    }

    DebugContext getDebugContext() {
        return this.debugContext;
    }

    void setState(State state) {
        if (!state.equals((Object)this.state.get())) {
            this.checkConnectionState(State.CLOSED);
            this.state.set(state);
            if (state.equals((Object)State.CLOSED)) {
                this.cleanAfterClose();
            }
        }
    }

    TextBuffer getTextBuffer() {
        return this.textBuffer;
    }

    BinaryBuffer getBinaryBuffer() {
        return this.binaryBuffer;
    }

    ReaderBuffer getReaderBuffer() {
        return this.readerBuffer;
    }

    void setReaderBuffer(ReaderBuffer readerBuffer) {
        this.readerBuffer = readerBuffer;
    }

    InputStreamBuffer getInputStreamBuffer() {
        return this.inputStreamBuffer;
    }

    void setInputStreamBuffer(InputStreamBuffer inputStreamBuffer) {
        this.inputStreamBuffer = inputStreamBuffer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TyrusSession");
        sb.append("{uri=").append(this.requestURI);
        sb.append(", id='").append(this.id).append('\'');
        sb.append(", endpointWrapper=").append(this.endpointWrapper);
        sb.append('}');
        return sb.toString();
    }

    private void changeStateToClosed() {
        this.state.compareAndSet(State.RUNNING, State.CLOSED);
        this.state.compareAndSet(State.RECEIVING_BINARY, State.CLOSED);
        this.state.compareAndSet(State.RECEIVING_TEXT, State.CLOSED);
    }

    private void cancelHeartBeatTask() {
        if (this.heartbeatTask != null && !this.heartbeatTask.isCancelled()) {
            this.heartbeatTask.cancel(true);
        }
    }

    private void cleanAfterClose() {
        if (this.readerBuffer != null) {
            this.readerBuffer.onSessionClosed();
        }
        if (this.inputStreamBuffer != null) {
            this.inputStreamBuffer.onSessionClosed();
        }
        this.cancelHeartBeatTask();
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    private class HeartbeatCommand
    implements Runnable {
        private HeartbeatCommand() {
        }

        @Override
        public void run() {
            TyrusSession session = TyrusSession.this;
            if (session.isOpen() && session.getHeartbeatInterval() > 0L) {
                try {
                    session.getBasicRemote().sendPong(null);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "Pong could not have been sent " + e.getMessage());
                }
            } else {
                TyrusSession.this.cancelHeartBeatTask();
            }
        }
    }

    private class IdleTimeoutCommand
    implements Runnable {
        private IdleTimeoutCommand() {
        }

        @Override
        public void run() {
            TyrusSession session = TyrusSession.this;
            if (session.getMaxIdleTimeout() > 0L && session.isOpen()) {
                try {
                    session.close(new CloseReason(CloseReason.CloseCodes.CLOSED_ABNORMALLY, LocalizationMessages.SESSION_CLOSED_IDLE_TIMEOUT()));
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "Session could not been closed. " + e.getMessage());
                }
            }
        }
    }

    static enum State {
        RUNNING,
        RECEIVING_TEXT,
        RECEIVING_BINARY,
        CLOSED;

    }
}

