/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Processor.Namespaces;

import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.Namespaces.Namespace;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class JavaObjectNamespace
extends Namespace {
    public Object obj;
    public ObjectDumpConfig objectDumpConfig;

    public JavaObjectNamespace(Object obj) {
        this.obj = obj;
        this.objectDumpConfig = ObjectDumpConfig.GetDefaultDumpConfig();
    }

    public JavaObjectNamespace(Object obj, ObjectDumpConfig objectDumpConfig) {
        this.obj = obj;
        this.objectDumpConfig = objectDumpConfig;
    }

    @Override
    public Namespace CallMethod(String name, String args) throws Exceptions.ToolException {
        switch (name) {
            case "type": {
                return new JavaObjectNamespace(this.obj.getClass().toString());
            }
            case "size": {
                if (null != this.obj) {
                    if (this.obj.getClass().isArray()) {
                        return new JavaObjectNamespace(Array.getLength(this.obj));
                    }
                    if (this.obj instanceof Collection) {
                        return new JavaObjectNamespace(((Collection)this.obj).size());
                    }
                    if (this.obj instanceof Map) {
                        return new JavaObjectNamespace(((Map)this.obj).size());
                    }
                    throw new Exceptions.RookInvalidObjectForAccess(this.obj.getClass(), "size()");
                }
                throw new Exceptions.RookInvalidObjectForAccess(null, "size()");
            }
            case "depth": {
                this.objectDumpConfig.max_depth = Integer.parseInt(args);
                return this;
            }
            case "width": {
                this.objectDumpConfig.max_width = Integer.parseInt(args);
                return this;
            }
            case "collection_dump": {
                this.objectDumpConfig.max_collection_depth = Integer.parseInt(args);
                return this;
            }
            case "string": {
                this.objectDumpConfig.max_string = Integer.parseInt(args);
                return this;
            }
        }
        return super.CallMethod(name, args);
    }

    @Override
    public Namespace ReadAttribute(String name) throws Exceptions.ToolException {
        Field field = null;
        Class<?> cls = this.obj.getClass();
        while (true) {
            try {
                field = cls.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                if (null != (cls = cls.getSuperclass())) continue;
            }
            break;
        }
        if (field == null) {
            throw new Exceptions.RookAttributeNotFound(name);
        }
        try {
            field.setAccessible(true);
            return new JavaObjectNamespace(field.get(this.obj));
        }
        catch (Throwable e) {
            throw new Exceptions.RookAttributeNotFound(name);
        }
    }

    @Override
    public Namespace ReadKey(Object key) throws Exceptions.ToolException {
        if (this.obj.getClass().isArray()) {
            if (!(key instanceof Integer)) {
                throw new Exceptions.RookInvalidKeyType(key, "Integer");
            }
            int index = (Integer)key;
            if (index >= Array.getLength(this.obj)) {
                throw new Exceptions.RookKeyNotFound(key);
            }
            return new JavaObjectNamespace(Array.get(this.obj, index));
        }
        if (this.obj instanceof List) {
            List listObj = (List)this.obj;
            if (!(key instanceof Integer)) {
                throw new Exceptions.RookInvalidKeyType(key, "Integer");
            }
            int index = (Integer)key;
            if (index >= listObj.size()) {
                throw new Exceptions.RookKeyNotFound(key);
            }
            return new JavaObjectNamespace(listObj.get(index));
        }
        if (this.obj instanceof Map) {
            Map mapObj = (Map)this.obj;
            if (!mapObj.containsKey(key)) {
                throw new Exceptions.RookKeyNotFound(key);
            }
            return new JavaObjectNamespace(mapObj.get(key));
        }
        throw new Exceptions.RookInvalidObjectForAccess(this.obj.getClass(), "ReadKey");
    }

    public boolean IsDefaultDumpConfig() {
        return this.objectDumpConfig.max_depth == 3 && this.objectDumpConfig.max_width == 20 && this.objectDumpConfig.max_collection_depth == 2 && this.objectDumpConfig.max_string == 512;
    }

    public static class ObjectDumpConfig {
        public static final int DEFAULT_MAX_DEPTH = 3;
        public static final int DEFAULT_MAX_WIDTH = 20;
        public static final int DEFAULT_MAX_COLLECTION_DEPTH = 2;
        public static final int DEFAULT_MAX_STRING = 512;
        public static final int CONSERVATIVE_MAX_DEPTH = 5;
        public static final int CONSERVATIVE_MAX_WIDTH = 20;
        public static final int CONSERVATIVE_MAX_COLLECTION_DEPTH = 2;
        public static final int CONSERVATIVE_MAX_STRING = 256;
        static final int UNLIMITED_STRING = 65536;
        public static final int UNLIMITED_COLLECTION_WIDTH = 100;
        public int max_depth;
        public int max_width;
        public int max_collection_depth;
        public int max_string;

        public ObjectDumpConfig(int max_depth, int max_width, int max_collection_depth, int max_string) {
            this.max_depth = max_depth;
            this.max_width = max_width;
            this.max_collection_depth = max_collection_depth;
            this.max_string = max_string;
        }

        public static ObjectDumpConfig GetDefaultDumpConfig() {
            return new ObjectDumpConfig(3, 20, 2, 512);
        }

        public static ObjectDumpConfig GetConservative() {
            return new ObjectDumpConfig(5, 20, 2, 256);
        }

        public static ObjectDumpConfig TailorLimits(Object object) {
            if (object instanceof String) {
                return new ObjectDumpConfig(1, 0, 0, 65536);
            }
            if (object instanceof Collection || object instanceof Map) {
                return new ObjectDumpConfig(3, 100, 2, 512);
            }
            return ObjectDumpConfig.GetDefaultDumpConfig();
        }
    }
}

