/*
 * Decompiled with CFR 0.152.
 */
package rook.org.glassfish.tyrus.container.grizzly.client;

import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import rook.org.glassfish.tyrus.container.grizzly.client.GrizzlyClientSocket;

class GrizzlyTransportTimeoutFilter
extends BaseFilter {
    private static final Logger LOGGER = Logger.getLogger(GrizzlyTransportTimeoutFilter.class.getName());
    private static final AtomicInteger connectionCounter = new AtomicInteger(0);
    private static final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("tyrus-grizzly-container-idle-timeout");
            thread.setDaemon(true);
            return thread;
        }
    });
    private static volatile long lastAccessed;
    private static volatile boolean closed;
    private static volatile ScheduledFuture<?> timeoutTask;
    private final int timeout;

    public GrizzlyTransportTimeoutFilter(int timeout) {
        this.timeout = timeout;
        closed = false;
    }

    public static void touch() {
        lastAccessed = System.currentTimeMillis();
    }

    @Override
    public NextAction handleConnect(FilterChainContext ctx) throws IOException {
        connectionCounter.incrementAndGet();
        GrizzlyTransportTimeoutFilter.touch();
        return super.handleConnect(ctx);
    }

    @Override
    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        int connectionCount = connectionCounter.decrementAndGet();
        GrizzlyTransportTimeoutFilter.touch();
        if (connectionCount == 0 && timeoutTask == null) {
            LOGGER.log(Level.FINER, "Scheduling IdleTimeoutTransportTask: " + this.timeout + " seconds.");
            timeoutTask = executorService.schedule(new IdleTimeoutTransportTask(connectionCounter), (long)this.timeout, TimeUnit.SECONDS);
        }
        return super.handleClose(ctx);
    }

    private class IdleTimeoutTransportTask
    implements Runnable {
        private final AtomicInteger connectionCounter;

        private IdleTimeoutTransportTask(AtomicInteger connectionCounter) {
            this.connectionCounter = connectionCounter;
        }

        @Override
        public void run() {
            if (this.connectionCounter.get() == 0 && !closed) {
                long currentTime = System.currentTimeMillis();
                if (lastAccessed + (long)(GrizzlyTransportTimeoutFilter.this.timeout * 1000) < currentTime) {
                    closed = true;
                    timeoutTask = null;
                    GrizzlyClientSocket.closeSharedTransport();
                } else {
                    long delay = lastAccessed + (long)(GrizzlyTransportTimeoutFilter.this.timeout * 1000) - currentTime;
                    LOGGER.log(Level.FINER, "Scheduling IdleTimeoutTransportTask: " + delay / 1000L + " seconds.");
                    timeoutTask = executorService.schedule(new IdleTimeoutTransportTask(this.connectionCounter), delay, TimeUnit.MILLISECONDS);
                }
            }
        }
    }
}

