/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Com;

import com.rookout.rook.Com.AgentCom;
import com.rookout.rook.Com.AgentComGrpc;
import com.rookout.rook.Com.OutputBase;
import com.rookout.rook.Config;
import com.rookout.rook.Processor.NamespaceSerializer;
import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import com.rookout.rook.Processor.Namespaces.JavaObjectNamespace;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Utils;
import com.rookout.rook.protobuf.Rook;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import rook.com.google.protobuf.Timestamp;

public class Output
implements OutputBase {
    private String rookId = "";
    private AgentComGrpc agentCom;
    private String[] tags = new String[0];
    private HashMap<String, String> labels = new HashMap();
    private Rook.RookMessages.Builder rookMessages = Output.getBuilder();
    private boolean messageLimitReached = false;
    private boolean logLimitReached = false;
    private boolean statusUpdateLimitReached = false;
    private boolean closing = false;
    private Thread thread;

    public Output() {
        RookLogger.RegisterOutput(this);
    }

    @Override
    public void Close() {
        RookLogger.RemoveOutput(this);
        this.StopSendingMessages();
    }

    @Override
    public void setAgentCom(AgentCom agentCom) {
        this.agentCom = (AgentComGrpc)agentCom;
    }

    @Override
    public void setAgentId(String agentId) {
        this.rookId = agentId;
    }

    @Override
    public void SendWarning(String ruleId, RookError error) {
        this.SendRuleStatus(ruleId, "Warning", error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void SendRuleStatus(String ruleId, String active, RookError error) {
        try {
            Rook.RookMessages.Builder builder = this.rookMessages;
            synchronized (builder) {
                if (this.rookMessages.getRuleStatusUpdatesCount() >= Config.Instance().OutputConfiguration$MAX_STATUS_UPDATES) {
                    if (!this.statusUpdateLimitReached) {
                        this.statusUpdateLimitReached = true;
                        RookLogger.Instance().log(Level.SEVERE, "Limit reached (%d), dropping status updates", Config.Instance().OutputConfiguration$MAX_STATUS_UPDATES);
                    }
                    return;
                }
                Rook.RuleStatusUpdate.Builder ruleStatusUpdate = Rook.RuleStatusUpdate.newBuilder();
                ruleStatusUpdate.setRookId(this.rookId);
                ruleStatusUpdate.setRuleId(ruleId);
                ruleStatusUpdate.setActive(active);
                ruleStatusUpdate.setTime(Utils.dateToTimestamp(new Date()));
                if (null != error) {
                    ruleStatusUpdate.setError(error.dumps());
                }
                this.rookMessages.addRuleStatusUpdates(ruleStatusUpdate);
            }
        }
        catch (Throwable e) {
            RookLogger.Instance().log(Level.SEVERE, "Failed to report rule status", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void SendUserMessage(String augId, Namespace arguments) {
        Rook.RookMessages.Builder builder = this.rookMessages;
        synchronized (builder) {
            if (this.rookMessages.getUserMessagesCount() >= Config.Instance().OutputConfiguration$MAX_ITEMS) {
                if (!this.messageLimitReached) {
                    this.messageLimitReached = true;
                    RookLogger.Instance().log(Level.SEVERE, "Limit reached (%d), dropping user messages", Config.Instance().OutputConfiguration$MAX_ITEMS);
                }
                return;
            }
            Rook.UserMessage.Builder userMessage = Rook.UserMessage.newBuilder();
            userMessage.setAugId(augId);
            userMessage.setTime(Utils.dateToTimestamp(new Date()));
            if (null != arguments) {
                NamespaceSerializer serializer = new NamespaceSerializer();
                userMessage.setArguments(serializer.Dump(arguments));
            }
            this.rookMessages.addUserMessages(userMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void SendLogMessage(int level, long timeInMillis, String className, String methodName, String text, String formattedMessage, ContainerNamespace arguments) {
        Rook.RookMessages.Builder builder = this.rookMessages;
        synchronized (builder) {
            if (this.rookMessages.getLogMessagesCount() >= Config.Instance().OutputConfiguration$MAX_LOG_ITEMS) {
                if (!this.logLimitReached) {
                    this.logLimitReached = true;
                    try {
                        level = Level.SEVERE.intValue();
                        className = this.getClass().getName();
                        methodName = "SendLogMessage";
                        formattedMessage = text = "Limit reached (%d), dropping log messages";
                        arguments = new ContainerNamespace();
                        arguments.WriteAttribute("args", new JavaObjectNamespace(Config.Instance().OutputConfiguration$MAX_LOG_ITEMS));
                    }
                    catch (Throwable e) {
                        System.out.println("Error when handling output queue size limit");
                        return;
                    }
                } else {
                    return;
                }
            }
            Rook.RookLogMessage.Builder logMessage = Rook.RookLogMessage.newBuilder();
            logMessage.setLevel(level);
            Timestamp.Builder timestamp = Timestamp.newBuilder();
            long seconds = timeInMillis / 1000L;
            long nanos = (timeInMillis - seconds * 1000L) * 1000L;
            timestamp.setSeconds(seconds);
            timestamp.setNanos((int)nanos);
            logMessage.setTime(timestamp);
            logMessage.setClassName(className);
            logMessage.setMethodName(methodName);
            logMessage.setText(text);
            logMessage.setFormattedMessage(formattedMessage);
            if (null != arguments && arguments.namespaces.size() > 0) {
                NamespaceSerializer serializer = new NamespaceSerializer();
                logMessage.setArguments(serializer.Dump((Namespace)arguments, false));
            }
            this.rookMessages.addLogMessages(logMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void FlushMessages() {
        Rook.RookMessages.Builder builder;
        Rook.RookMessages.Builder builder2 = this.rookMessages;
        synchronized (builder2) {
            builder = this.rookMessages;
            this.rookMessages = Output.getBuilder();
        }
        if (builder.getLogMessagesCount() > 0 || builder.getUserMessagesCount() > 0 || builder.getRuleStatusUpdatesCount() > 0) {
            try {
                builder.setRookId(this.rookId);
                this.agentCom.SendRookMessages(builder.build());
                this.messageLimitReached = false;
                this.logLimitReached = false;
            }
            catch (Throwable e) {
                RookLogger.Instance().log(Level.SEVERE, "Error while sending rook messages", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void StartSendingMessages() {
        Output output = this;
        synchronized (output) {
            if (null != this.thread) {
                return;
            }
            this.closing = false;
            this.thread = new Thread((Runnable)new WorkerRunnable(), Config.Instance().OutputConfiguration$THREAD_NAME);
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void StopSendingMessages() {
        Output output = this;
        synchronized (output) {
            this.closing = true;
            try {
                if (null != this.thread) {
                    this.thread.join();
                    this.thread = null;
                }
            }
            catch (InterruptedException e) {
                RookLogger.Instance().log(Level.SEVERE, "Error while closing output", e);
            }
        }
    }

    public Rook.RookInformation GetRookInfo() {
        Rook.RookInformation.Builder message = Rook.RookInformation.newBuilder();
        message.setRookId(this.rookId);
        try {
            message.setVersion(Config.Instance().VersionConfiguration$VERSION);
            message.setCommit(Config.Instance().VersionConfiguration$COMMIT);
            message.setPlatform("java");
            message.setPlatformType(System.getProperty("java.vendor"));
            message.setPlatformVersion(System.getProperty("java.version"));
            message.setExecutable(Utils.GetExecutalbePath());
            message.addAllCommandArguments(Utils.GetCommandLine());
            for (String tag : this.tags) {
                message.addTags(tag.trim());
            }
            message.putAllLabels(this.labels);
            String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();
            String pid = nameOfRunningVM.substring(0, nameOfRunningVM.indexOf(64));
            message.setProcessId(pid);
            try {
                InetAddress ip = InetAddress.getLocalHost();
                message.setIp(ip.getHostAddress());
                message.setHostname(ip.getHostName());
            }
            catch (Throwable e) {
                RookLogger.Instance().log(Level.SEVERE, "Failed machine network", e);
            }
            message.setUserCommit(Output.GetUserSuppliedValue("ROOKOUT_COMMIT"));
            message.setUserRemoteOrigin(Output.GetUserSuppliedValue("ROOKOUT_REMOTE_ORIGIN"));
            message.setOs(System.getProperty("os.name"));
            message.setOsVersion(System.getProperty("os.version"));
            message.setOsRelease(System.getProperty("os.version"));
        }
        catch (Throwable e) {
            RookLogger.Instance().log(Level.SEVERE, "Unexpected exception when building rook info", e);
        }
        return message.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String GetUserSuppliedValue(String name) {
        String value = System.getenv(name);
        if (null != value) {
            return value;
        }
        String executable = Utils.GetExecutalbePath();
        if (!executable.endsWith(".jar")) {
            if (!(executable.endsWith(".war") | executable.endsWith(".ear"))) return "";
        }
        try (JarFile file = new JarFile(executable);){
            ZipEntry entry = file.getEntry("META-INF/MANIFEST.MF");
            if (null == entry) {
                throw new IOException("Failed to get manifest file");
            }
            byte[] manifestBytes = Utils.getEntryBytes(file, entry);
            if (null == manifestBytes) {
                throw new IOException("Failed to get manifest file contents");
            }
            String manifestString = new String(manifestBytes);
            Pattern pattern = Pattern.compile("^" + name + ":\\s+(.*)$", 8);
            Matcher matcher = pattern.matcher(manifestString);
            if (!matcher.find()) {
                throw new IOException("Failed to find manifest tag");
            }
            String string = matcher.group(1);
            return string;
        }
        catch (IOException e) {
            RookLogger.Instance().log(Level.WARNING, "Failed to get jar commit", e);
        }
        return "";
    }

    private static Rook.RookMessages.Builder getBuilder() {
        return Rook.RookMessages.newBuilder();
    }

    @Override
    public void setTags(String[] tags, HashMap<String, String> labels) {
        if (tags != null) {
            this.tags = tags;
        }
        if (labels != null) {
            this.labels = labels;
        }
    }

    private class WorkerRunnable
    implements Runnable {
        private WorkerRunnable() {
        }

        @Override
        public void run() {
            boolean errorReported = false;
            while (!Output.this.closing) {
                block5: {
                    try {
                        Output.this.FlushMessages();
                        errorReported = false;
                    }
                    catch (Exception e) {
                        if (errorReported) break block5;
                        RookLogger.Instance().log(Level.SEVERE, "Error while flushing messages", e);
                        errorReported = true;
                    }
                }
                try {
                    Thread.sleep((long)(Config.Instance().OutputConfiguration$FLUSH_TIME_INTERVAL * 1000.0));
                }
                catch (InterruptedException e) {
                    RookLogger.Instance().log(Level.SEVERE, "Error while sleeping", e);
                }
            }
        }
    }
}

