/*
 * Decompiled with CFR 0.152.
 */
package rook.org.glassfish.tyrus.container.grizzly.client;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TaskProcessor {
    private final Queue<Task> taskQueue = new ConcurrentLinkedQueue<Task>();
    private final Condition condition;
    private final Lock taskLock = new ReentrantLock();

    public TaskProcessor(Condition condition) {
        this.condition = condition;
    }

    public TaskProcessor() {
        this.condition = null;
    }

    public void processTask(Task task) {
        this.taskQueue.offer(task);
        this.processTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTask() {
        if (!this.taskLock.tryLock()) {
            return;
        }
        try {
            while (!this.taskQueue.isEmpty()) {
                if (this.condition != null && !this.condition.isValid()) {
                    return;
                }
                Task first = this.taskQueue.poll();
                if (first == null) continue;
                first.execute();
            }
        }
        finally {
            this.taskLock.unlock();
        }
        if (!this.taskQueue.isEmpty()) {
            this.processTask();
        }
    }

    public static interface Condition {
        public boolean isValid();
    }

    public static abstract class Task {
        public abstract void execute();
    }
}

