/*
 * Decompiled with CFR 0.152.
 */
package rook.io.grpc.internal;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import rook.com.google.common.annotations.VisibleForTesting;
import rook.com.google.common.base.Preconditions;
import rook.io.grpc.Attributes;
import rook.io.grpc.ConnectivityState;
import rook.io.grpc.ConnectivityStateInfo;
import rook.io.grpc.EquivalentAddressGroup;
import rook.io.grpc.InternalChannelz;
import rook.io.grpc.LoadBalancer;
import rook.io.grpc.PickFirstBalancerFactory;
import rook.io.grpc.Status;
import rook.io.grpc.internal.ChannelTracer;
import rook.io.grpc.internal.GrpcAttributes;
import rook.io.grpc.internal.ServiceConfigUtil;
import rook.io.grpc.internal.TimeProvider;
import rook.javax.annotation.CheckForNull;
import rook.javax.annotation.Nullable;

final class AutoConfiguredLoadBalancerFactory
extends LoadBalancer.Factory {
    @VisibleForTesting
    static final String ROUND_ROBIN_LOAD_BALANCER_FACTORY_NAME = "rook.io.grpc.util.RoundRobinLoadBalancerFactory";
    @VisibleForTesting
    static final String GRPCLB_LOAD_BALANCER_FACTORY_NAME = "rook.io.grpc.grpclb.GrpclbLoadBalancerFactory";
    @Nullable
    private final ChannelTracer channelTracer;
    @Nullable
    private final TimeProvider timeProvider;

    AutoConfiguredLoadBalancerFactory(@Nullable ChannelTracer channelTracer, @Nullable TimeProvider timeProvider) {
        this.channelTracer = channelTracer;
        this.timeProvider = timeProvider;
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new AutoConfiguredLoadBalancer(helper, this.channelTracer, this.timeProvider);
    }

    private static final class FailingPicker
    extends LoadBalancer.SubchannelPicker {
        private final Status failure;

        FailingPicker(Status failure) {
            this.failure = failure;
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            return LoadBalancer.PickResult.withError(this.failure);
        }
    }

    private static final class EmptyPicker
    extends LoadBalancer.SubchannelPicker {
        private EmptyPicker() {
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            return LoadBalancer.PickResult.withNoResult();
        }
    }

    @VisibleForTesting
    static final class AutoConfiguredLoadBalancer
    extends LoadBalancer {
        private final LoadBalancer.Helper helper;
        private LoadBalancer delegate;
        private LoadBalancer.Factory delegateFactory;
        @CheckForNull
        private ChannelTracer channelTracer;
        @Nullable
        private final TimeProvider timeProvider;

        AutoConfiguredLoadBalancer(LoadBalancer.Helper helper, @Nullable ChannelTracer channelTracer, @Nullable TimeProvider timeProvider) {
            this.helper = helper;
            this.delegateFactory = PickFirstBalancerFactory.getInstance();
            this.delegate = this.delegateFactory.newLoadBalancer(helper);
            this.channelTracer = channelTracer;
            this.timeProvider = timeProvider;
            if (channelTracer != null) {
                Preconditions.checkNotNull(timeProvider, "timeProvider");
            }
        }

        @Override
        public void handleResolvedAddressGroups(List<EquivalentAddressGroup> servers, Attributes attributes) {
            LoadBalancer.Factory newlbf;
            Map<String, Object> configMap = attributes.get(GrpcAttributes.NAME_RESOLVER_SERVICE_CONFIG);
            try {
                newlbf = AutoConfiguredLoadBalancer.decideLoadBalancerFactory(servers, configMap);
            }
            catch (RuntimeException e) {
                Status s = Status.INTERNAL.withDescription("Failed to pick a load balancer from service config").withCause(e);
                this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new FailingPicker(s));
                this.delegate.shutdown();
                this.delegateFactory = null;
                this.delegate = new NoopLoadBalancer();
                return;
            }
            if (newlbf != null && newlbf != this.delegateFactory) {
                this.helper.updateBalancingState(ConnectivityState.CONNECTING, new EmptyPicker());
                this.delegate.shutdown();
                this.delegateFactory = newlbf;
                LoadBalancer old = this.delegate;
                this.delegate = this.delegateFactory.newLoadBalancer(this.helper);
                if (this.channelTracer != null) {
                    this.channelTracer.reportEvent(new InternalChannelz.ChannelTrace.Event.Builder().setDescription("Load balancer changed from " + old + " to " + this.delegate).setSeverity(InternalChannelz.ChannelTrace.Event.Severity.CT_INFO).setTimestampNanos(this.timeProvider.currentTimeNanos()).build());
                }
            }
            this.getDelegate().handleResolvedAddressGroups(servers, attributes);
        }

        @Override
        public void handleNameResolutionError(Status error) {
            this.getDelegate().handleNameResolutionError(error);
        }

        @Override
        public void handleSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo stateInfo) {
            this.getDelegate().handleSubchannelState(subchannel, stateInfo);
        }

        @Override
        public void shutdown() {
            this.delegate.shutdown();
            this.delegate = null;
        }

        @VisibleForTesting
        LoadBalancer getDelegate() {
            return this.delegate;
        }

        @VisibleForTesting
        void setDelegate(LoadBalancer lb) {
            this.delegate = lb;
        }

        @VisibleForTesting
        LoadBalancer.Factory getDelegateFactory() {
            return this.delegateFactory;
        }

        @Nullable
        @VisibleForTesting
        static LoadBalancer.Factory decideLoadBalancerFactory(List<EquivalentAddressGroup> servers, @Nullable Map<String, Object> config) {
            boolean haveBalancerAddress = false;
            for (EquivalentAddressGroup s : servers) {
                if (s.getAttributes().get(GrpcAttributes.ATTR_LB_ADDR_AUTHORITY) == null) continue;
                haveBalancerAddress = true;
                break;
            }
            if (haveBalancerAddress) {
                try {
                    Class<?> lbFactoryClass = Class.forName(AutoConfiguredLoadBalancerFactory.GRPCLB_LOAD_BALANCER_FACTORY_NAME);
                    Method getInstance = lbFactoryClass.getMethod("getInstance", new Class[0]);
                    return (LoadBalancer.Factory)getInstance.invoke(null, new Object[0]);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException("Can't get GRPCLB, but balancer addresses were present", e);
                }
            }
            String serviceConfigChoiceBalancingPolicy = null;
            if (config != null) {
                serviceConfigChoiceBalancingPolicy = ServiceConfigUtil.getLoadBalancingPolicyFromServiceConfig(config);
            }
            if (serviceConfigChoiceBalancingPolicy != null) {
                if (serviceConfigChoiceBalancingPolicy.toUpperCase(Locale.ROOT).equals("ROUND_ROBIN")) {
                    try {
                        Class<?> lbFactoryClass = Class.forName(AutoConfiguredLoadBalancerFactory.ROUND_ROBIN_LOAD_BALANCER_FACTORY_NAME);
                        Method getInstance = lbFactoryClass.getMethod("getInstance", new Class[0]);
                        return (LoadBalancer.Factory)getInstance.invoke(null, new Object[0]);
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Can't get Round Robin LB", e);
                    }
                }
                throw new IllegalArgumentException("Unknown service config policy: " + serviceConfigChoiceBalancingPolicy);
            }
            return PickFirstBalancerFactory.getInstance();
        }
    }

    private static final class NoopLoadBalancer
    extends LoadBalancer {
        private NoopLoadBalancer() {
        }

        @Override
        public void handleResolvedAddressGroups(List<EquivalentAddressGroup> s, Attributes a) {
        }

        @Override
        public void handleNameResolutionError(Status error) {
        }

        @Override
        public void handleSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo stateInfo) {
        }

        @Override
        public void shutdown() {
        }
    }
}

