/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.Augs.Aug;
import com.rookout.rook.Config;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Services.Instrumentation.Augs;
import com.rookout.rook.Services.Instrumentation.Files;
import com.rookout.rook.UserWarnings;
import java.lang.instrument.Instrumentation;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.logging.Level;

public class ClassReloader {
    private static long sleepInterval;
    private Thread thread;
    private boolean closing = false;
    private Instrumentation inst;
    private Augs augs;
    private Files files;
    private Queue queue;

    ClassReloader(Instrumentation inst, Augs augs, Files files) {
        this.inst = inst;
        this.augs = augs;
        this.files = files;
        sleepInterval = Config.Instance().ClassReloaderConfiguration$SLEEP_TIME_INTERVAL_IN_MS.intValue();
        if (sleepInterval > 0L) {
            this.queue = new Queue();
            this.thread = new Thread((Runnable)new WorkerRunnable(this.inst, this.augs, this.files), Config.Instance().ClassReloaderConfiguration$THREAD_NAME);
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    void Stop() {
        this.closing = true;
        if (null != this.queue) {
            this.queue.Stop();
        }
        try {
            if (null != this.thread) {
                this.thread.join();
                this.thread = null;
            }
        }
        catch (InterruptedException e) {
            RookLogger.Instance().log(Level.SEVERE, "Error while closing output", e);
        }
        this.queue = null;
    }

    void AddAug(String fileName, int lineno, String hash, Aug aug) {
        aug.SetPending();
        Augs.AugWithFileName augWithFileName = new Augs.AugWithFileName(aug, fileName);
        this.InstructReload(new augContext(augWithFileName, lineno, hash, true));
    }

    void RemoveAug(String augId) {
        this.InstructReload(new augContext(augId, false));
    }

    void InstructReload(augContext context) {
        if (sleepInterval > 0L && !this.closing) {
            this.queue.Insert(context);
            return;
        }
        ClassReloader.ApplyAugAndReloadClass(context, this.inst, this.augs, this.files);
    }

    private static void ApplyAugAndReloadClass(augContext context, Instrumentation inst, Augs augs, Files files) {
        String fileName;
        Aug warningReporter = null;
        if (context.addAction.booleanValue()) {
            augs.AddAug(context.augWithFileName.aug, context.augWithFileName.fileName, context.lineno, context.hash);
            fileName = context.augWithFileName.fileName;
            warningReporter = context.augWithFileName.aug;
        } else {
            Augs.AugWithFileName augWithFileName = augs.RemoveAug(context.augId);
            if (augWithFileName.aug != null) {
                augWithFileName.aug.SetRemoved();
                fileName = augWithFileName.fileName;
            } else {
                RookLogger.Instance().log(Level.WARNING, "Aug not found - skipping");
                return;
            }
        }
        try (UserWarnings reporter = new UserWarnings(warningReporter);){
            if (files.IsLoaded(fileName)) {
                Files.ClassSet classes = files.GetClasses(fileName);
                for (Files.ClassObject cls : classes) {
                    ClassReloader.ReloadClass(context, cls, inst);
                    try {
                        Thread.sleep(sleepInterval);
                    }
                    catch (InterruptedException e) {
                        RookLogger.Instance().log(Level.SEVERE, "Error while sleeping", e);
                    }
                }
            }
        }
    }

    private static void ReloadClass(augContext context, Files.ClassObject classObject, Instrumentation inst) {
        block6: {
            Class<?> cls;
            String javaName = classObject.className.replace("/", ".");
            try {
                cls = Class.forName(javaName, true, classObject.classLoader);
            }
            catch (ClassNotFoundException e) {
                return;
            }
            catch (Error e) {
                RookLogger.Instance().log(Level.SEVERE, "Failed to get class", e);
                return;
            }
            if (!inst.isModifiableClass(cls)) {
                return;
            }
            try {
                inst.retransformClasses(cls);
            }
            catch (Throwable e) {
                String message = "Error while reloading file";
                RookLogger.Instance().log(Level.SEVERE, message, e);
                if (null == context.augWithFileName.aug) break block6;
                context.augWithFileName.aug.SetError(new RookError(e, message));
            }
        }
    }

    private class augContext {
        Augs.AugWithFileName augWithFileName;
        int lineno;
        String hash;
        Boolean addAction;
        String augId;

        augContext(Augs.AugWithFileName aug, int lineno, String hash, Boolean addAction) {
            this.augWithFileName = aug;
            this.lineno = lineno;
            this.hash = hash;
            this.addAction = addAction;
            this.augId = aug.aug.augId;
        }

        augContext(String augId, Boolean addAction) {
            this.augId = augId;
            this.augWithFileName = null;
            this.lineno = -1;
            this.hash = "";
            this.addAction = addAction;
        }
    }

    private class Queue {
        boolean closing = false;
        LinkedHashSet augContextSet = new LinkedHashSet();

        Queue() {
        }

        synchronized void Stop() {
            this.closing = true;
            this.notify();
        }

        synchronized void Insert(augContext item) {
            this.augContextSet.add(item);
            if (1 <= this.augContextSet.size()) {
                this.notify();
            }
        }

        synchronized augContext Pop() {
            while (this.IsEmpty() && !this.closing) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    RookLogger.Instance().log(Level.SEVERE, "Error while waiting", e);
                }
            }
            if (this.closing) {
                return null;
            }
            Iterator i = this.augContextSet.iterator();
            augContext next = (augContext)i.next();
            i.remove();
            return next;
        }

        synchronized boolean IsEmpty() {
            return this.augContextSet.size() == 0;
        }
    }

    private class WorkerRunnable
    implements Runnable {
        Instrumentation inst;
        Augs augs;
        Files files;

        WorkerRunnable(Instrumentation inst, Augs augs, Files files) {
            this.inst = inst;
            this.augs = augs;
            this.files = files;
        }

        @Override
        public void run() {
            while (!ClassReloader.this.closing) {
                augContext context = ClassReloader.this.queue.Pop();
                if (null == context) {
                    return;
                }
                ClassReloader.ApplyAugAndReloadClass(context, this.inst, this.augs, this.files);
            }
        }
    }
}

