/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Com;

import com.rookout.Messages;
import com.rookout.VariantOuterClass;
import com.rookout.rook.Com.AgentCom;
import com.rookout.rook.Com.AgentComWs;
import com.rookout.rook.Com.OutputBase;
import com.rookout.rook.Config;
import com.rookout.rook.Processor.NamespaceSerializer;
import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import rook.com.google.protobuf.Timestamp;

public class OutputWs
implements OutputBase {
    HashMap<Integer, Messages.LogMessage.LogLevel> logLevels = new HashMap<Integer, Messages.LogMessage.LogLevel>(){
        {
            this.put(Level.ALL.intValue(), Messages.LogMessage.LogLevel.DEBUG);
            this.put(Level.INFO.intValue(), Messages.LogMessage.LogLevel.INFO);
            this.put(Level.WARNING.intValue(), Messages.LogMessage.LogLevel.WARNING);
            this.put(Level.SEVERE.intValue(), Messages.LogMessage.LogLevel.FATAL);
        }
    };
    private String agentId = "";
    private AgentComWs agentCom;
    private String[] tags = new String[0];
    private HashMap<String, String> labels = new HashMap();
    private boolean closing = false;
    private Thread thread;
    TokenBucket ruleStatusUpdatesBucket;
    TokenBucket userMessageBucket;
    TokenBucket logMessageBucket;

    public OutputWs() {
        Config config = Config.Instance();
        this.ruleStatusUpdatesBucket = new TokenBucket(config.OutputWsConfiguration$MAX_STATUS_UPDATES, config.OutputWsConfiguration$BUCKET_WINDOW, new Callable(){

            @Override
            public void call() {
                RookLogger.Instance().log(Level.SEVERE, "Limit reached, dropping status updates");
            }
        });
        this.userMessageBucket = new TokenBucket(config.OutputWsConfiguration$MAX_ITEMS, config.OutputWsConfiguration$BUCKET_WINDOW, new Callable(){

            @Override
            public void call() {
                RookLogger.Instance().log(Level.SEVERE, "Limit reached, dropping aug report messages");
            }
        });
        this.logMessageBucket = new TokenBucket(config.OutputWsConfiguration$MAX_LOG_ITEMS, config.OutputWsConfiguration$BUCKET_WINDOW, new Callable(){

            @Override
            public void call() {
                OutputWs.this.internalSendLogMessage(3, System.currentTimeMillis(), "", "", "Limit reached, dropping log messages", "Limit reached, dropping log messages", null);
            }
        });
        RookLogger.RegisterOutput(this);
    }

    @Override
    public void Close() {
        this.closing = true;
        RookLogger.RemoveOutput(this);
        this.StopSendingMessages();
    }

    @Override
    public void setAgentCom(AgentCom agentCom) {
        this.agentCom = (AgentComWs)agentCom;
    }

    @Override
    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    @Override
    public void SendWarning(String ruleId, RookError error) {
        this.SendRuleStatus(ruleId, "Warning", error);
    }

    @Override
    public void SendRuleStatus(final String ruleId, final String active, final RookError error) {
        if (this.closing) {
            return;
        }
        this.ruleStatusUpdatesBucket.doIfAvailable(new Callable(){

            @Override
            public void call() {
                Messages.RuleStatusMessage.Builder ruleStatusMessage = Messages.RuleStatusMessage.newBuilder();
                ruleStatusMessage.setAgentId(OutputWs.this.agentId);
                ruleStatusMessage.setRuleId(ruleId);
                ruleStatusMessage.setActive(active);
                if (error != null) {
                    try {
                        ruleStatusMessage.setError(VariantOuterClass.Error.parseFrom(error.dumps().toByteArray()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                OutputWs.this.agentCom.add(ruleStatusMessage.build());
            }
        });
    }

    @Override
    public void SendUserMessage(final String augId, final Namespace arguments) {
        if (this.closing) {
            return;
        }
        this.userMessageBucket.doIfAvailable(new Callable(){

            @Override
            public void call() {
                Messages.AugReportMessage.Builder augReportMessage = Messages.AugReportMessage.newBuilder();
                augReportMessage.setAgentId(OutputWs.this.agentId);
                augReportMessage.setAugId(augId);
                if (null != arguments) {
                    NamespaceSerializer serializer = new NamespaceSerializer();
                    try {
                        augReportMessage.setArguments(VariantOuterClass.Variant.parseFrom(serializer.Dump(arguments).build().toByteArray()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                OutputWs.this.agentCom.add(augReportMessage.build());
            }
        });
    }

    @Override
    public void SendLogMessage(final int level, final long timeInMillis, final String className, final String methodName, final String text, final String formattedMesage, final ContainerNamespace arguments) {
        if (this.closing) {
            return;
        }
        this.logMessageBucket.doIfAvailable(new Callable(){

            @Override
            public void call() {
                OutputWs.this.internalSendLogMessage(level, timeInMillis, className, methodName, text, formattedMesage, arguments);
            }
        });
    }

    private void internalSendLogMessage(int level, long timeInMillis, String className, String methodName, String text, String formattedMesage, ContainerNamespace arguments) {
        if (this.agentCom == null) {
            return;
        }
        Messages.LogMessage.Builder logMessage = Messages.LogMessage.newBuilder();
        Timestamp.Builder timestamp = Timestamp.newBuilder();
        long seconds = timeInMillis / 1000L;
        long nanos = (timeInMillis - seconds * 1000L) * 1000L;
        timestamp.setSeconds(seconds);
        timestamp.setNanos((int)nanos);
        logMessage.setTimestamp(timestamp);
        logMessage.setAgentId(this.agentId);
        Messages.LogMessage.LogLevel msgLevel = this.logLevels.get(level);
        if (msgLevel == null) {
            msgLevel = Messages.LogMessage.LogLevel.WARNING;
        }
        logMessage.setLevel(msgLevel);
        logMessage.setClassName(className);
        logMessage.setMethodName(methodName);
        logMessage.setText(text);
        logMessage.setFormattedMessage(formattedMesage);
        if (null != arguments) {
            NamespaceSerializer serializer = new NamespaceSerializer();
            try {
                logMessage.setLegacyArguments(VariantOuterClass.Variant.parseFrom(serializer.Dump(arguments).build().toByteArray()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.agentCom.add(logMessage.build());
    }

    @Override
    public void FlushMessages() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void StartSendingMessages() {
        OutputWs outputWs = this;
        synchronized (outputWs) {
            if (null != this.thread) {
                return;
            }
            this.closing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void StopSendingMessages() {
        OutputWs outputWs = this;
        synchronized (outputWs) {
            this.closing = true;
            try {
                if (null != this.thread) {
                    this.thread.join();
                    this.thread = null;
                }
            }
            catch (InterruptedException e) {
                RookLogger.Instance().log(Level.SEVERE, "Error while closing output", e);
            }
        }
    }

    @Override
    public void setTags(String[] tags, HashMap<String, String> labels) {
        if (tags != null) {
            this.tags = tags;
        }
        if (labels != null) {
            this.labels = labels;
        }
    }

    class TokenBucket {
        Timer timer;
        int remaining;
        int intervalInSeconds;
        Callable doOnceWhenExhausted;
        boolean doOnceWhenExhaustedPerformed;

        TokenBucket(final int limit, int intervalInSeconds, Callable doOnceWhenExhausted) {
            this.remaining = limit;
            this.intervalInSeconds = intervalInSeconds;
            this.doOnceWhenExhausted = doOnceWhenExhausted;
            this.doOnceWhenExhaustedPerformed = false;
            this.timer = new Timer();
            final TokenBucket tb = this;
            this.timer.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    TokenBucket tokenBucket = tb;
                    synchronized (tokenBucket) {
                        TokenBucket.this.remaining = limit;
                        TokenBucket.this.doOnceWhenExhaustedPerformed = false;
                    }
                }
            }, TimeUnit.SECONDS.toMillis(this.intervalInSeconds), TimeUnit.SECONDS.toMillis(this.intervalInSeconds));
        }

        public boolean isExhausted() {
            return this.remaining < 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doIfAvailable(Callable func) {
            TokenBucket tokenBucket = this;
            synchronized (tokenBucket) {
                --this.remaining;
                if (this.isExhausted()) {
                    if (this.doOnceWhenExhausted != null && !this.doOnceWhenExhaustedPerformed) {
                        this.doOnceWhenExhaustedPerformed = true;
                        this.doOnceWhenExhausted.call();
                    }
                    return;
                }
            }
            func.call();
        }
    }

    public static interface Callable {
        public void call();
    }
}

