/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook;

import com.rookout.rook.Exceptions;
import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import rook.io.grpc.netty.GrpcSslContexts;
import rook.io.netty.handler.ssl.SslContextBuilder;
import rook.io.netty.handler.ssl.SslProvider;
import rook.io.netty.internal.tcnative.SSL;
import rook.io.netty.util.internal.NativeLibraryLoader;
import rook.io.netty.util.internal.PlatformDependent;

public class RuntimeVersionVerifier {
    public static void CheckVersionSupported() throws Exceptions.RookUnSupportedEnvironment, Exceptions.RookJVMVersionParsingFailed {
        versionHolder currentVersion = new versionHolder();
        RuntimeVersionVerifier.VerifyJvmDistribution(currentVersion);
        RuntimeVersionVerifier.VerifyOs(currentVersion);
        RuntimeVersionVerifier.VerifyJvmVersion(currentVersion);
    }

    private static void VerifyJvmDistribution(versionHolder currentVersion) throws Exceptions.RookUnSupportedEnvironment {
        if (!(currentVersion.distributionName.contains("oracle") || currentVersion.distributionName.contains("amazon.com") || currentVersion.distributionName.equals("adoptopenjdk"))) {
            throw new Exceptions.RookUnSupportedEnvironment(currentVersion.fullVersion, currentVersion.distributionName, currentVersion.updateVersion);
        }
    }

    private static void loadTcNative() throws Exception {
        String os = PlatformDependent.normalizedOs();
        String arch = PlatformDependent.normalizedArch();
        LinkedHashSet<String> libNames = new LinkedHashSet<String>(4);
        String staticLibName = "netty_tcnative";
        libNames.add(staticLibName + "_" + os + '_' + arch);
        if ("linux".equalsIgnoreCase(os)) {
            libNames.add(staticLibName + "_" + os + '_' + arch + "_fedora");
        }
        libNames.add(staticLibName + "_" + arch);
        libNames.add(staticLibName);
        NativeLibraryLoader.loadFirstAvailable(SSL.class.getClassLoader(), libNames.toArray(new String[0]));
    }

    private static void VerifyOs(versionHolder currentVersion) throws Exceptions.RookUnSupportedEnvironment {
        try {
            try {
                RuntimeVersionVerifier.loadTcNative();
                GrpcSslContexts.configure(SslContextBuilder.forClient(), SslProvider.OPENSSL).build();
            }
            catch (Throwable e) {
                RuntimeVersionVerifier.impersonateAlpine(new Runnable(){

                    @Override
                    public void run() throws Throwable {
                        RuntimeVersionVerifier.loadTcNative();
                        GrpcSslContexts.configure(SslContextBuilder.forClient(), SslProvider.OPENSSL).build();
                    }
                });
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new Exceptions.RookUnSupportedEnvironment(currentVersion.fullVersion, currentVersion.distributionName, currentVersion.updateVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void impersonateAlpine(Runnable action) throws Throwable {
        Class<PlatformDependent> cls = PlatformDependent.class;
        Field field = cls.getDeclaredField("NORMALIZED_OS");
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.setAccessible(true);
        String originalOs = (String)field.get(null);
        field.set(null, "alpine");
        try {
            action.run();
        }
        finally {
            field.set(null, originalOs);
        }
    }

    private static void VerifyJvmVersion(versionHolder currentVersion) throws Exceptions.RookUnSupportedEnvironment {
        switch (currentVersion.majorVersion) {
            case "7": {
                if (currentVersion.updateVersion >= 111) {
                    return;
                }
            }
            case "8": {
                if (currentVersion.updateVersion >= 74) {
                    return;
                }
            }
            case "9": {
                return;
            }
            case "9-Debian": {
                return;
            }
            case "10": {
                return;
            }
            case "11": {
                return;
            }
            case "12": {
                return;
            }
        }
        throw new Exceptions.RookUnSupportedEnvironment(currentVersion.fullVersion, currentVersion.distributionName, currentVersion.updateVersion);
    }

    private static abstract class Runnable {
        private Runnable() {
        }

        public abstract void run() throws Throwable;
    }

    private static class versionHolder {
        public String fullVersion = System.getProperty("java.version");
        public String majorVersion;
        public int updateVersion;
        public String distributionName;

        public versionHolder() throws Exceptions.RookUnSupportedEnvironment, Exceptions.RookJVMVersionParsingFailed {
            try {
                String major;
                String update;
                block14: {
                    String minor;
                    String[] javaVersionElements;
                    block13: {
                        this.distributionName = System.getProperty("java.vm.vendor").toLowerCase();
                        javaVersionElements = this.fullVersion.split("\\.|_|-b");
                        if (javaVersionElements.length == 0) {
                            throw new Exceptions.RookUnSupportedEnvironment(this.fullVersion, this.distributionName, this.updateVersion);
                        }
                        minor = "0";
                        update = "0";
                        String prefix = javaVersionElements[0];
                        if (0 != prefix.compareTo("1")) break block13;
                        switch (javaVersionElements.length) {
                            case 4: {
                                update = javaVersionElements[3].split("-")[0];
                            }
                            case 3: {
                                minor = javaVersionElements[2];
                            }
                            case 2: {
                                prefix = javaVersionElements[0];
                                major = javaVersionElements[1];
                                break block14;
                            }
                            default: {
                                throw new Exceptions.RookUnSupportedEnvironment(this.fullVersion, this.distributionName, this.updateVersion);
                            }
                        }
                    }
                    switch (javaVersionElements.length) {
                        case 3: {
                            minor = javaVersionElements[2];
                        }
                        case 1: {
                            major = javaVersionElements[0];
                            break;
                        }
                        default: {
                            throw new Exceptions.RookUnSupportedEnvironment(this.fullVersion, this.distributionName, this.updateVersion);
                        }
                    }
                }
                this.majorVersion = major;
                this.updateVersion = Integer.parseInt(update, 10);
            }
            catch (Exceptions.RookUnSupportedEnvironment e) {
                throw e;
            }
            catch (Throwable e) {
                throw new Exceptions.RookJVMVersionParsingFailed(this.fullVersion);
            }
        }
    }
}

