/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook;

import com.rookout.rook.Exceptions;
import java.io.File;
import java.lang.reflect.Field;
import rook.io.grpc.netty.GrpcSslContexts;
import rook.io.netty.handler.ssl.SslContextBuilder;
import rook.io.netty.handler.ssl.SslProvider;
import rook.io.netty.util.internal.PlatformDependent;

public class RuntimeVersionVerifier {
    public static void CheckVersionSupported() throws Exceptions.RookUnSupportedEnvironment {
        versionHolder currentVersion = new versionHolder();
        RuntimeVersionVerifier.VerifyJvmDistribution(currentVersion);
        RuntimeVersionVerifier.VerifyOs(currentVersion);
        RuntimeVersionVerifier.VerifyJvmVersion(currentVersion);
    }

    private static void VerifyJvmDistribution(versionHolder currentVersion) throws Exceptions.RookUnSupportedEnvironment {
        if (!currentVersion.distributionName.contains("oracle") && !currentVersion.distributionName.contains("amazon.com")) {
            throw new Exceptions.RookUnSupportedEnvironment(currentVersion.fullVersion, currentVersion.distributionName);
        }
    }

    private static void VerifyOs(versionHolder currentVersion) throws Exceptions.RookUnSupportedEnvironment {
        try {
            if (new File("/etc/alpine-release").isFile()) {
                RuntimeVersionVerifier.impersonateAlpine(new Runnable(){

                    @Override
                    public void run() throws Throwable {
                        GrpcSslContexts.configure(SslContextBuilder.forClient(), SslProvider.OPENSSL).build();
                    }
                });
            } else {
                GrpcSslContexts.configure(SslContextBuilder.forClient(), SslProvider.OPENSSL).build();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new Exceptions.RookUnSupportedEnvironment(currentVersion.fullVersion, currentVersion.distributionName);
        }
    }

    private static void impersonateAlpine(Runnable action) throws Throwable {
        Class<PlatformDependent> cls = PlatformDependent.class;
        Field field = cls.getDeclaredField("NORMALIZED_OS");
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.setAccessible(true);
        String originalOs = (String)field.get(null);
        field.set(null, "alpine");
        action.run();
        field.set(null, originalOs);
    }

    private static void VerifyJvmVersion(versionHolder currentVersion) throws Exceptions.RookUnSupportedEnvironment {
        switch (currentVersion.majorVersion) {
            case "7": {
                if (currentVersion.updateVersion >= 111) {
                    return;
                }
            }
            case "8": {
                if (currentVersion.updateVersion < 74) break;
                return;
            }
        }
        throw new Exceptions.RookUnSupportedEnvironment(currentVersion.fullVersion, currentVersion.distributionName);
    }

    private static abstract class Runnable {
        private Runnable() {
        }

        public abstract void run() throws Throwable;
    }

    private static class versionHolder {
        public String fullVersion;
        public String majorVersion;
        public int updateVersion;
        public String distributionName;

        public versionHolder() throws Exceptions.RookUnSupportedEnvironment {
            String major;
            String update;
            block11: {
                String minor;
                String[] javaVersionElements;
                block10: {
                    this.fullVersion = System.getProperty("java.version");
                    this.distributionName = System.getProperty("java.vm.vendor").toLowerCase();
                    javaVersionElements = this.fullVersion.split("\\.|_|-b");
                    if (javaVersionElements.length == 0) {
                        throw new Exceptions.RookUnSupportedEnvironment(this.fullVersion, this.distributionName);
                    }
                    minor = "0";
                    update = "0";
                    String prefix = javaVersionElements[0];
                    if (0 != prefix.compareTo("1")) break block10;
                    switch (javaVersionElements.length) {
                        case 4: {
                            update = javaVersionElements[3];
                        }
                        case 3: {
                            minor = javaVersionElements[2];
                        }
                        case 2: {
                            prefix = javaVersionElements[0];
                            major = javaVersionElements[1];
                            break block11;
                        }
                        default: {
                            throw new Exceptions.RookUnSupportedEnvironment(this.fullVersion, this.distributionName);
                        }
                    }
                }
                switch (javaVersionElements.length) {
                    case 3: {
                        minor = javaVersionElements[2];
                    }
                    case 1: {
                        major = javaVersionElements[0];
                        break;
                    }
                    default: {
                        throw new Exceptions.RookUnSupportedEnvironment(this.fullVersion, this.distributionName);
                    }
                }
            }
            this.majorVersion = major;
            this.updateVersion = Integer.parseInt(update.split("-")[0]);
        }
    }
}

