/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Processor.Paths;

import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.Processor.Paths.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import rook.org.json.JSONObject;

public class BasicPath
implements Path {
    private static final Pattern MATCHER = Pattern.compile("[\\w\\[][\\w'\\\"\\(\\)]*\\]?");
    private List<PathOperation> pathOperationList;
    private PathOperation lastOperation;

    public BasicPath(String path) throws Exceptions.ToolException {
        this.ParsePath(path);
    }

    public BasicPath(JSONObject object) throws Exceptions.ToolException {
        String path = object.getString("path");
        this.ParsePath(path);
    }

    @Override
    public Namespace ReadFrom(Namespace namespace) throws Exceptions.ToolException {
        for (PathOperation operation : this.pathOperationList) {
            namespace = operation.Read(namespace, false);
        }
        return this.lastOperation.Read(namespace, false);
    }

    @Override
    public void WriteTo(Namespace namespace, Namespace value) throws Exceptions.ToolException {
        for (PathOperation operation : this.pathOperationList) {
            namespace = operation.Read(namespace, true);
        }
        this.lastOperation.Write(namespace, value);
    }

    private void ParsePath(String path) throws Exceptions.ToolException {
        this.pathOperationList = new ArrayList<PathOperation>();
        Matcher rawOperations = MATCHER.matcher(path);
        while (rawOperations.find()) {
            String value = path.substring(rawOperations.start(), rawOperations.end());
            if (value.isEmpty()) continue;
            this.pathOperationList.add(this.BuildOperation(value));
        }
        if (this.pathOperationList.size() <= 0) {
            throw new Exceptions.RookInvalidBasicPath(path);
        }
        this.lastOperation = this.pathOperationList.get(this.pathOperationList.size() - 1);
        this.pathOperationList.remove(this.pathOperationList.size() - 1);
    }

    private PathOperation BuildOperation(String rawOperation) {
        if (rawOperation.startsWith("[")) {
            return new LookupOperation(rawOperation.substring(1, rawOperation.length() - 1));
        }
        if (rawOperation.contains("(")) {
            int splitter = rawOperation.indexOf("(");
            String name = rawOperation.substring(0, splitter);
            String args = rawOperation.substring(splitter + 1, rawOperation.length() - 1);
            return new FunctionOperation(name, args);
        }
        return new AttributeOperation(rawOperation);
    }

    private static class FunctionOperation
    implements PathOperation {
        private String functionName;
        private String args;

        FunctionOperation(String functionName, String args) {
            this.functionName = functionName;
            this.args = args;
        }

        @Override
        public Namespace Read(Namespace namespace, boolean create) throws Exceptions.ToolException {
            return namespace.CallMethod(this.functionName, this.args);
        }

        @Override
        public void Write(Namespace namespace, Namespace value) throws Exceptions.ToolException {
            throw new Exceptions.RookOperationReadOnly(this.getClass());
        }
    }

    private static class LookupOperation
    implements PathOperation {
        private Object key;

        LookupOperation(String name) {
            this.key = name.startsWith("'") && name.endsWith("'") || name.startsWith("\"") && name.endsWith("\"") ? name.substring(1, name.length() - 1) : Integer.valueOf(Integer.parseInt(name));
        }

        @Override
        public Namespace Read(Namespace namespace, boolean create) throws Exceptions.ToolException {
            return namespace.ReadKey(this.key);
        }

        @Override
        public void Write(Namespace namespace, Namespace value) throws Exceptions.ToolException {
            throw new Exceptions.RookOperationReadOnly(this.getClass());
        }
    }

    private static class AttributeOperation
    implements PathOperation {
        private String name;

        AttributeOperation(String name) {
            this.name = name;
        }

        @Override
        public Namespace Read(Namespace namespace, boolean create) throws Exceptions.ToolException {
            try {
                return namespace.ReadAttribute(this.name);
            }
            catch (Exceptions.RookAttributeNotFound e) {
                if (create) {
                    ContainerNamespace newNamespace = new ContainerNamespace();
                    namespace.WriteAttribute(this.name, newNamespace);
                    return newNamespace;
                }
                throw e;
            }
        }

        @Override
        public void Write(Namespace namespace, Namespace value) throws Exceptions.ToolException {
            namespace.WriteAttribute(this.name, value);
        }
    }

    private static interface PathOperation {
        public Namespace Read(Namespace var1, boolean var2) throws Exceptions.ToolException;

        public void Write(Namespace var1, Namespace var2) throws Exceptions.ToolException;
    }
}

