/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook;

import java.util.HashMap;

public class Exceptions {

    public static class RookInvalidStackTrace
    extends ToolException {
        public RookInvalidStackTrace() {
            super("StackTrace is not valid");
        }
    }

    public static class RookScriptEngineUnavailable
    extends ToolException {
        public RookScriptEngineUnavailable() {
            super("Script engine is not available");
        }
    }

    public static class RookInvalidKeyType
    extends ToolException {
        public RookInvalidKeyType(Object key, String expected) {
            super("Invalid key type");
            this.parameters.put("key", key);
            this.parameters.put("expected", expected);
        }
    }

    public static class RookInvalidLabel
    extends ToolException {
        public RookInvalidLabel(String label) {
            super("Invalid label: must not start with the '$' character");
            this.parameters.put("label", label);
        }
    }

    public static class RookInvalidOptions
    extends ToolException {
        public RookInvalidOptions(String message) {
            super(message);
        }
    }

    public static class RookInvalidArithmeticPath
    extends ToolException {
        public RookInvalidArithmeticPath(String configuration, Exception innerException) {
            super("Invalid arithmetic path configuration");
            this.parameters.put("configuration", configuration);
            this.parameters.put("innerException", innerException);
        }
    }

    public static class RookInvalidPositionException
    extends ToolException {
        public RookInvalidPositionException() {
            super("Code position is not breakable");
        }
    }

    public static class RookMissingToken
    extends ToolException {
        public RookMissingToken() {
            super("Rookout token was not supplied");
        }
    }

    public static class RookInvalidToken
    extends ToolException {
        public RookInvalidToken() {
            super("Rookout token was rejected");
        }
    }

    public static class RookClassQueueIsEmpty
    extends ToolException {
        public RookClassQueueIsEmpty() {
            super("Class queue is empty");
        }
    }

    public static class RookUnsupportedLocation
    extends ToolException {
        public RookUnsupportedLocation(String name) {
            super("Unsupported aug location was specified");
            this.parameters.put("location", name);
        }
    }

    public static class RookUnSupportedEnvironment
    extends ToolException {
        public RookUnSupportedEnvironment(String jvmVersion, String distributionName) {
            super("Rook is not supported in this environment");
            this.parameters.put("jvmVersion", jvmVersion);
            this.parameters.put("distribution", distributionName);
        }
    }

    public static class RookRuleRateLimited
    extends ToolException {
        public RookRuleRateLimited() {
            super("Rule was disabled due to rate-limiting");
        }
    }

    public static class RookFailedToGetClass
    extends ToolException {
        public RookFailedToGetClass(Throwable cause) {
            super("class.ForName failed", cause);
        }
    }

    public static class RookJvmVerificationError
    extends ToolException {
        public RookJvmVerificationError(Throwable cause) {
            super("JVM verification failed", cause);
        }
    }

    public static class RookLoggingServiceUnavailable
    extends ToolException {
        public RookLoggingServiceUnavailable() {
            super("JVM Logging service is unavailable");
        }
    }

    public static class RookInstrumentationUnavailable
    extends ToolException {
        public RookInstrumentationUnavailable() {
            super("JVM Instrumentation is unavailable");
        }
    }

    public static class RookOperationReadOnly
    extends ToolException {
        public RookOperationReadOnly(Class operation) {
            super("Operation does not support write");
            this.parameters.put("operation", operation.toString());
        }
    }

    public static class RookMethodFailed
    extends ToolException {
        public RookMethodFailed(String method, String arguments, Throwable t) {
            super("Namespace method failed", t);
            this.parameters.put("method", method);
            this.parameters.put("arguments", arguments);
        }
    }

    public static class RookInvalidMethodArguments
    extends ToolException {
        public RookInvalidMethodArguments(String method, String arguments) {
            super("Bad method arguments");
            this.parameters.put("method", method);
            this.parameters.put("arguments", arguments);
        }
    }

    public static class RookInvalidObjectForAccess
    extends ToolException {
        public RookInvalidObjectForAccess(Class object_type, String access) {
            super("Namespace does not support access");
            if (null != object_type) {
                this.parameters.put("object", object_type.toString());
            } else {
                this.parameters.put("object", null);
            }
            this.parameters.put("access", access);
        }
    }

    public static class RookWriteAttributeNotSupported
    extends ToolException {
        public RookWriteAttributeNotSupported(Class namespace_type, String attribute) {
            super("Namespace does not support write");
            this.parameters.put("namespace", namespace_type.toString());
            this.parameters.put("attribute", attribute);
        }
    }

    public static class RookMethodNotFound
    extends ToolException {
        public RookMethodNotFound(Class namespace_type, String method) {
            super("Namespace method not found");
            this.parameters.put("namespace", namespace_type.toString());
            this.parameters.put("method", method);
        }
    }

    public static class RookKeyNotFound
    extends ToolException {
        public RookKeyNotFound(Object key) {
            super("Failed to get key");
            this.parameters.put("key", key);
        }
    }

    public static class RookAttributeNotFound
    extends ToolException {
        public RookAttributeNotFound(String attribute) {
            super("Failed to get attribute");
            this.parameters.put("attribute", attribute);
        }
    }

    public static class RookMultipleSoruceFilesFound
    extends ToolException {
        public RookMultipleSoruceFilesFound(String file_name) {
            super("Multiple files found ");
            this.parameters.put("file_name", file_name);
        }
    }

    public static class RookSourceFileNotFound
    extends ToolException {
        public RookSourceFileNotFound(String file_name) {
            super("Failed to find file");
            this.parameters.put("file_name", file_name);
        }
    }

    public static class RookInvalidBasicPath
    extends ToolException {
        public RookInvalidBasicPath(String configuration) {
            super("Invalid basic path configuration");
            this.parameters.put("configuration", configuration);
        }
    }

    public static class RookInvalidObjectConfiguration
    extends ToolException {
        public RookInvalidObjectConfiguration(String object_name, String object_config, Throwable cause) {
            super("Invalid object configuration", cause);
            this.parameters.put("object_name", object_name);
            this.parameters.put("object_config", object_config);
        }
    }

    public static class RookUnknownObject
    extends ToolException {
        public RookUnknownObject(String object_name) {
            super("Encountered unknown object");
            this.parameters.put("object_name", object_name);
        }
    }

    public static class RookObjectNameMissing
    extends ToolException {
        public RookObjectNameMissing(String configuration, Throwable cause) {
            super("Failed to find object name", cause);
            this.parameters.put("configuration", configuration);
        }
    }

    public static class RookAugInvalidKey
    extends ToolException {
        public RookAugInvalidKey(String key, String configuration, Throwable cause) {
            super("Invalid aug key", cause);
            this.parameters.put("key", key);
            this.parameters.put("configuration", configuration);
        }
    }

    public static class RookHashMismatchException
    extends ToolException {
        public RookHashMismatchException(String filepath, String expected, String calculated) {
            super("File hashes do not match!");
            this.parameters.put("filepath", filepath);
            this.parameters.put("expected", expected);
            this.parameters.put("calculated", calculated);
        }
    }

    public static abstract class ToolException
    extends Exception {
        protected HashMap<String, Object> parameters = new HashMap();

        public ToolException() {
        }

        public ToolException(String message) {
            super(message);
        }

        public ToolException(Throwable cause) {
            super(cause);
        }

        public ToolException(String message, Throwable cause) {
            super(message, cause);
        }

        public ToolException(String message, HashMap<String, Object> parameters) {
            super(message);
            this.parameters = parameters;
        }

        public ToolException(String message, HashMap<String, Object> parameters, Throwable cause) {
            super(message, cause);
            this.parameters = parameters;
        }

        public String getType() {
            return this.getClass().getSimpleName();
        }

        public HashMap getParameters() {
            return this.parameters;
        }
    }
}

