/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Augs;

import com.rookout.rook.Augs.Actions.Action;
import com.rookout.rook.Augs.Conditions.Condition;
import com.rookout.rook.Augs.Locations.Location;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Output;
import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import com.rookout.rook.Processor.Namespaces.FrameNamespace;
import com.rookout.rook.Processor.Namespaces.JavaUtilsNamespace;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.Processor.Namespaces.StackNamespace;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Services.Frame;
import com.rookout.rook.Services.Instrumentation.InstrumentationService;
import com.rookout.rook.TriggerServices;
import com.rookout.rook.UserWarnings;
import com.rookout.rook.WarningReporter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;

public class Aug
implements WarningReporter {
    public String augId;
    private Location location;
    private Action action;
    private Output output;
    private long minTimeBetweenHits;
    private long lastExecuted = 0L;
    private Condition condition;
    private String active = "";

    public Aug(String augId, Location location, Action action, Output output) {
        this(augId, location, action, null, output, 0L);
    }

    public Aug(String augId, Location location, Action action, Condition condition, Output output, long minTimeBetweenHits) {
        this.augId = augId;
        this.location = location;
        this.action = action;
        this.output = output;
        this.minTimeBetweenHits = minTimeBetweenHits;
        this.condition = condition;
    }

    public void AddAug(TriggerServices triggerServices) {
        try {
            this.location.AddAug(triggerServices, this);
        }
        catch (Throwable e) {
            String message = "Exception when adding aug";
            RookLogger.Instance().log(Level.SEVERE, message, e);
            this.SetError(new RookError(e, message));
        }
    }

    public void Execute(final Frame frame, final Namespace extracted) {
        if (!this.active.equals("Active")) {
            return;
        }
        try (UserWarnings reporter = new UserWarnings(this);){
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() {
                    boolean executed = false;
                    try {
                        long now = System.currentTimeMillis();
                        Namespace fixedExtracted = extracted;
                        if (null == fixedExtracted) {
                            fixedExtracted = new ContainerNamespace();
                        }
                        ContainerNamespace namespace = new ContainerNamespace();
                        namespace.WriteAttribute("frame", new FrameNamespace(frame));
                        namespace.WriteAttribute("stack", new StackNamespace(frame));
                        namespace.WriteAttribute("extracted", fixedExtracted);
                        namespace.WriteAttribute("store", new ContainerNamespace());
                        namespace.WriteAttribute("temp", new ContainerNamespace());
                        namespace.WriteAttribute("utils", new JavaUtilsNamespace());
                        if (Aug.this.condition == null || Aug.this.condition.evaluate(namespace)) {
                            executed = true;
                            if (now < Aug.this.lastExecuted + Aug.this.minTimeBetweenHits) {
                                RookLogger.Instance().log(Level.WARNING, "Removing rule due to rate limiting - " + Aug.this.augId);
                                Aug.this.SetError(new RookError(new Exceptions.RookRuleRateLimited()));
                                InstrumentationService.instance.RemoveAug(Aug.this.augId);
                                Object var6_6 = null;
                                return var6_6;
                            }
                            RookLogger.Instance().log(Level.INFO, "Executing aug - " + Aug.this.augId);
                            Aug.this.action.Execute(Aug.this.augId, namespace, Aug.this.output);
                        }
                    }
                    catch (Throwable e) {
                        String message = "Exception while processing Aug";
                        RookLogger.Instance().log(Level.SEVERE, message, e);
                        Aug.this.SendWarning(new RookError(e, message));
                    }
                    finally {
                        if (executed) {
                            Aug.this.lastExecuted = System.currentTimeMillis();
                        }
                    }
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void SetActive() {
        this.SendRuleStatus("Active", null);
    }

    public void SetPending() {
        this.SendRuleStatus("Pending", null);
    }

    public void SetRemoved() {
        this.SendRuleStatus("Deleted", null);
    }

    public void SetError(RookError error) {
        this.SendRuleStatus("Error", error);
    }

    public void SetUnknown(RookError error) {
        this.SendRuleStatus("Unknown", error);
    }

    @Override
    public void SendWarning(RookError error) {
        RookLogger.Instance().log(Level.WARNING, error.getMessage());
        this.output.SendWarning(this.augId, error);
    }

    protected void SendRuleStatus(String active, RookError error) {
        if (this.active.equals(active)) {
            return;
        }
        RookLogger.Instance().log(Level.INFO, "Updating rule status for: " + this.augId + " to " + active);
        this.active = active;
        this.output.SendRuleStatus(this.augId, active, error);
    }
}

