/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Processor.Paths;

import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.Namespaces.JavaObjectNamespace;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.Processor.Paths.ArithmeticPathInternal.Maps;
import com.rookout.rook.Processor.Paths.ArithmeticPathInternal.ParseError;
import com.rookout.rook.Processor.Paths.ArithmeticPathInternal.TreeNode;
import com.rookout.rook.Processor.Paths.Array;
import com.rookout.rook.Processor.Paths.MapsActions;
import com.rookout.rook.Processor.Paths.NamespaceResult;
import com.rookout.rook.Processor.Paths.Path;
import com.rookout.rook.Processor.Paths.ToolException;
import java.util.ArrayList;
import rook.org.json.JSONObject;

public class ArithmeticPath
implements Path {
    private String path;

    public ArithmeticPath(String path) {
        this.path = path;
    }

    public ArithmeticPath(JSONObject object) {
        this.path = object.getString("path");
    }

    @Override
    public Namespace ReadFrom(Namespace namespace) throws Exceptions.ToolException {
        try {
            TreeNode result = Maps.parse(this.path, new MapsActions(namespace));
            return this.normalizeResult(result);
        }
        catch (ParseError e) {
            throw new Exceptions.NewRookInvalidArithmeticPathException(this.path, e);
        }
    }

    private Namespace normalizeResult(TreeNode result) throws Exceptions.ToolException {
        String className;
        switch (className = result.getClass().getSimpleName()) {
            case "Array": {
                ArrayList<String> arr = new ArrayList<String>();
                for (TreeNode res : ((Array)result).list) {
                    arr.add(res.toString());
                }
                return new JavaObjectNamespace(arr);
            }
            case "NamespaceResult": {
                return ((NamespaceResult)result).namespace;
            }
            case "ToolException": {
                throw new Exceptions.NewRookInvalidArithmeticPathException(this.path, ((ToolException)result).exc);
            }
        }
        if (result.toString().equals("true") || result.toString().equals("false")) {
            return new JavaObjectNamespace(Boolean.parseBoolean(result.toString()));
        }
        return new JavaObjectNamespace(result.toString());
    }

    @Override
    public void WriteTo(Namespace namespace, Namespace value) throws Exceptions.ToolException {
        throw new Exceptions.RookWriteAttributeNotSupported(this.getClass(), "");
    }
}

