/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook;

import com.rookout.rook.AugManager;
import com.rookout.rook.Com.AgentCom;
import com.rookout.rook.Config;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Output;
import com.rookout.rook.RookLogger;
import com.rookout.rook.RookOptions;
import com.rookout.rook.RuntimeVersionVerifier;
import com.rookout.rook.Services.Instrumentation.InstrumentationService;
import com.rookout.rook.TriggerServices;
import java.lang.instrument.Instrumentation;
import java.util.logging.Level;

public class Singleton {
    private static Singleton instance;
    private Output output = new Output();
    private boolean servicesStarted = false;
    private TriggerServices triggerServices = null;
    private AugManager augManager = null;
    private AgentCom agentCom = null;
    private RookOptions opts;

    public static void init(RookOptions opts, Instrumentation instrumentation) {
        InstrumentationService.SetInstrumentation(instrumentation, opts.reload_classes);
        Singleton.Instance().opts = opts;
    }

    public static void start() throws Exception {
        block19: {
            Singleton s = Singleton.Instance();
            RookOptions opts = s.opts;
            if (s.servicesStarted) {
                throw new RuntimeException("Rook started multiple times");
            }
            try {
                try {
                    RuntimeVersionVerifier.CheckVersionSupported();
                    if (opts.token == null && opts.host == null) {
                        throw new Exceptions.RookMissingToken();
                    }
                    Config config = Config.Instance();
                    if (opts.log_file != null) {
                        config.LoggingConfiguration$FILE_NAME = opts.log_file;
                    }
                    if (opts.log_level != null) {
                        config.LoggingConfiguration$LOG_LEVEL = opts.log_level;
                    }
                    if (opts.log_to_stderr != null) {
                        config.LoggingConfiguration$LOG_TO_STDERR = opts.log_to_stderr;
                    }
                    if (opts.debug != null && opts.debug.booleanValue()) {
                        config.LoggingConfiguration$LOG_LEVEL = "DEBUG";
                        config.LoggingConfiguration$LOG_TO_STDERR = true;
                        config.LoggingConfiguration$DEBUG = true;
                    }
                    if (opts.host == null) {
                        opts.host = config.AgentAddress$HOST;
                    }
                    if (opts.host.equals("staging.cloud.agent.rookout.com") || opts.host.equals("cloud.agent.rookout.com")) {
                        opts.host = "https://" + opts.host;
                    }
                    if (opts.port == null) {
                        opts.port = config.AgentAddress$PORT;
                    }
                    RookLogger.Instance().info("Rookout Singleton Starting");
                    Singleton.Instance().Connect();
                }
                catch (Exceptions.RookUnSupportedEnvironment e) {
                    if (!s.opts.throw_errors.booleanValue()) {
                        System.err.println("[Rookout] Unsupported JVM. Rookout supports Java 7, 8 on Oracle Java or Oracle OpenJDK");
                    }
                    throw e;
                }
                catch (Exceptions.RookInvalidToken | Exceptions.RookMissingToken e) {
                    if (!s.opts.throw_errors.booleanValue()) {
                        System.err.println("[Rookout] Failed to connect to the agent: " + e.toString());
                    }
                    throw e;
                }
                catch (Throwable e) {
                    if (!s.opts.throw_errors.booleanValue()) {
                        System.err.println("[Rookout] Failed to connect to the agent - will continue attempting in the background");
                    }
                    throw e;
                }
            }
            catch (Throwable e) {
                if (s.opts.debug.booleanValue()) {
                    e.printStackTrace();
                }
                if (!s.opts.throw_errors.booleanValue()) break block19;
                throw e;
            }
        }
    }

    public static Singleton Instance() {
        if (null == instance) {
            instance = new Singleton();
        }
        return instance;
    }

    private Singleton() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    RookLogger.Instance().log(Level.INFO, "Exit handler called - flushing");
                    if (Singleton.this.servicesStarted) {
                        Singleton.this.Flush();
                    }
                }
                catch (Throwable t) {
                    RookLogger.Instance().log(Level.WARNING, "Flush failed", t);
                }
                RookLogger.Instance().log(Level.INFO, "Exit handler finished");
            }
        }));
    }

    public void StartServices() {
        if (this.servicesStarted) {
            return;
        }
        this.triggerServices = new TriggerServices();
        this.augManager = new AugManager(this.triggerServices, this.output);
        this.servicesStarted = true;
    }

    public void StopServices() {
        if (!this.servicesStarted) {
            return;
        }
        this.augManager = null;
        this.triggerServices.Close();
        this.triggerServices = null;
        this.servicesStarted = false;
    }

    void Connect() throws Exception {
        this.StartServices();
        RookLogger.Instance().info("Connecting to agent");
        this.output.setTags(this.opts.tags, this.opts.labels);
        this.agentCom = new AgentCom(this.augManager, this.output, this.opts.host, this.opts.port, this.opts.token);
        this.output.setAgentCom(this.agentCom);
        this.agentCom.ConnectToAgent();
    }

    public void Flush() {
        if (null != this.output && null != this.agentCom) {
            this.output.FlushMessages();
        }
    }

    public TriggerServices getTriggerServices() {
        return this.triggerServices;
    }
}

