/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Logging;

import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import com.rookout.rook.Processor.Namespaces.JULLogRecordNamespace;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Services.Frame;
import com.rookout.rook.Services.Logging.LoggingService;
import com.rookout.rook.Services.StackTrace;
import java.util.HashMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class RookoutJULHandler
extends Handler {
    private String name;
    private Logger logger;
    private LoggingService.Handler handler;

    public RookoutJULHandler(String name, LoggingService.Handler handler) {
        this.name = name;
        this.handler = handler;
        this.logger = Logger.getLogger(this.name);
        this.logger.addHandler(this);
    }

    @Override
    public void close() throws SecurityException {
        this.logger.removeHandler(this);
    }

    @Override
    public void publish(LogRecord record) {
        try {
            Frame frame = this.GetFrame(record);
            ContainerNamespace extracted = new ContainerNamespace();
            try {
                extracted.WriteAttribute("log_record", new JULLogRecordNamespace(record, this.getFormatter()));
            }
            catch (Throwable e) {
                RookLogger.Instance().log(Level.SEVERE, "Failed to prepare namespaces", e);
                return;
            }
            this.handler.runAugs(frame, extracted);
        }
        catch (Throwable e) {
            if (e instanceof AssertionError) {
                throw e;
            }
            RookLogger.Instance().log(Level.SEVERE, "Error while processing log record", e);
        }
    }

    @Override
    public void flush() {
    }

    private Frame GetFrame(LogRecord record) {
        StackTrace stackTrace = new StackTrace(new Throwable());
        stackTrace.baseFrame = 3;
        while (stackTrace.baseFrame < stackTrace.depth && this.isLoggerImplFrame(stackTrace.at(0).getClassName())) {
            ++stackTrace.baseFrame;
        }
        return new Frame(stackTrace, new HashMap<String, Object>());
    }

    private boolean isLoggerImplFrame(String cname) {
        return cname.equals("java.util.logging.Logger") || cname.startsWith("java.util.logging.LoggingProxyImpl") || cname.startsWith("sun.util.logging.");
    }
}

