/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Processor;

import com.rookout.rook.Processor.NamespaceSerializerExt;
import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import com.rookout.rook.Processor.Namespaces.JavaObjectNamespace;
import com.rookout.rook.Processor.Namespaces.ListNamespace;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Utils;
import com.rookout.rook.protobuf.Rook;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import rook.com.google.protobuf.ByteString;

public class NamespaceSerializer {
    private static NamespaceSerializerExt java8 = null;
    private static final Class[] primitiveClassesList;
    private static final Set<Class> primitiveClasses;

    private static boolean isPrimitive(Class cls) {
        return primitiveClasses.contains(cls) || null != java8 && java8.isPrimitive(cls);
    }

    public Rook.Variant.Builder Dump(Namespace namespace) {
        return this.Dump(namespace, true);
    }

    public Rook.Variant.Builder Dump(Namespace namespace, boolean logErrors) {
        Rook.Variant.Builder variant = Rook.Variant.newBuilder();
        this.Dump(namespace, variant, logErrors);
        return variant;
    }

    void Dump(Namespace namespace, Rook.Variant.Builder variant) {
        this.Dump(namespace, variant, true);
    }

    void Dump(Namespace namespace, Rook.Variant.Builder variant, boolean logErrors) {
        block5: {
            try {
                if (namespace instanceof ContainerNamespace) {
                    this.DumpContainerNamespace((ContainerNamespace)namespace, variant, logErrors);
                    break block5;
                }
                if (namespace instanceof JavaObjectNamespace) {
                    this.DumpJavaObjectNamespace((JavaObjectNamespace)namespace, variant, logErrors);
                    break block5;
                }
                if (namespace instanceof ListNamespace) {
                    this.DumpListNamespace((ListNamespace)namespace, variant, logErrors);
                    break block5;
                }
                throw new RuntimeException("Namespace not supported! " + namespace.getClass().toString());
            }
            catch (Throwable e) {
                String message = "Failed to serialize namespace";
                variant.clear();
                variant.setVariantType(Rook.Variant.Type.VARIANT_ERROR);
                if (!logErrors) break block5;
                variant.setErrorValue(new RookError(e, message).dumps());
                RookLogger.Instance().log(Level.SEVERE, message, e);
            }
        }
    }

    private void DumpContainerNamespace(ContainerNamespace namespace, Rook.Variant.Builder variant, boolean logErrors) {
        variant.setVariantType(Rook.Variant.Type.VARIANT_NAMESPACE);
        Rook.Variant.Namespace.Builder result = Rook.Variant.Namespace.newBuilder();
        for (Map.Entry<String, Namespace> entry : namespace.namespaces.entrySet()) {
            Rook.Variant.NamedValue.Builder value = Rook.Variant.NamedValue.newBuilder();
            value.setName(entry.getKey());
            value.setValue(this.Dump(entry.getValue(), logErrors));
            result.addAttributes(value);
        }
        variant.setNamespaceValue(result);
    }

    private void DumpJavaObjectNamespace(JavaObjectNamespace namespace, Rook.Variant.Builder variant, boolean logErrors) throws Exception {
        this.DumpJavaObject(namespace.obj, variant, 0, namespace.objectDumpConfig, logErrors);
    }

    private void DumpJavaObject(Object object, Rook.Variant.Builder variant, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        block2: {
            try {
                this.DumpJavaObjectUnsafe(object, variant, currentDepth, objectDumpConfig, logErrors);
            }
            catch (Throwable e) {
                String message = "Failed to serialize namespace";
                variant.clear();
                variant.setVariantType(Rook.Variant.Type.VARIANT_ERROR);
                if (!logErrors) break block2;
                variant.setErrorValue(new RookError(e, message).dumps());
                RookLogger.Instance().log(Level.SEVERE, message, e);
            }
        }
    }

    private void DumpJavaObjectUnsafe(Object object, Rook.Variant.Builder variant, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        if (currentDepth == objectDumpConfig.max_depth) {
            this.DumpMaxDepth(object, variant, currentDepth, objectDumpConfig);
        } else {
            this.DumpBaseObject(object, variant, currentDepth, objectDumpConfig, logErrors);
            if (null == object) {
                variant.setVariantType(Rook.Variant.Type.VARIANT_NONE);
            } else if (null != java8 && java8.isSupported(object)) {
                java8.DumpJavaObject(object, variant, currentDepth, objectDumpConfig);
            } else if (object instanceof Integer || object instanceof Short || object instanceof Byte || object instanceof Boolean) {
                if (object instanceof Short) {
                    object = ((Short)object).intValue();
                } else if (object instanceof Byte) {
                    object = ((Byte)object).intValue();
                } else if (object instanceof Boolean) {
                    object = (Boolean)object != false ? Integer.valueOf(1) : Integer.valueOf(0);
                }
                variant.setVariantType(Rook.Variant.Type.VARIANT_INT);
                variant.setIntValue((Integer)object);
            } else if (object instanceof Long) {
                variant.setVariantType(Rook.Variant.Type.VARIANT_LONG);
                variant.setLongValue((Long)object);
            } else if (object instanceof Double || object instanceof Float) {
                variant.setVariantType(Rook.Variant.Type.VARIANT_DOUBLE);
                if (object instanceof Double) {
                    variant.setDoubleValue((Double)object);
                } else {
                    variant.setDoubleValue(new BigDecimal(((Float)object).floatValue()).doubleValue());
                }
            } else if (object instanceof String || object instanceof Character) {
                if (object instanceof Character) {
                    object = ((Character)object).toString();
                }
                variant.setVariantType(Rook.Variant.Type.VARIANT_STRING);
                Rook.Variant.String.Builder stringBuilder = Rook.Variant.String.newBuilder();
                String string = (String)object;
                stringBuilder.setOriginalSize(string.length());
                if (string.length() > objectDumpConfig.max_string) {
                    string = string.substring(0, objectDumpConfig.max_string);
                }
                stringBuilder.setValue(string);
                variant.setStringValue(stringBuilder);
            } else if (object instanceof Date) {
                variant.setVariantType(Rook.Variant.Type.VARIANT_TIME);
                variant.setTimeValue(Utils.dateToTimestamp((Date)object));
            } else if (object instanceof byte[]) {
                variant.setVariantType(Rook.Variant.Type.VARIANT_BINARY);
                byte[] binary = (byte[])object;
                int size = Math.min(binary.length, objectDumpConfig.max_string);
                Rook.Variant.Binary.Builder binaryBuilder = Rook.Variant.Binary.newBuilder();
                binaryBuilder.setOriginalSize(binary.length);
                binaryBuilder.setValue(ByteString.copyFrom(binary, 0, size));
                variant.setBinaryValue(binaryBuilder);
            } else if (object.getClass().isArray()) {
                this.DumpArray(object, variant, currentDepth, objectDumpConfig, logErrors);
            } else if (object instanceof Collection) {
                this.DumpCollection((Collection)object, variant, currentDepth, objectDumpConfig, logErrors);
            } else if (object instanceof Map) {
                this.DumpMap((Map)object, variant, currentDepth, objectDumpConfig, logErrors);
            } else if (object instanceof Throwable) {
                this.DumpThrowable((Throwable)object, variant, currentDepth, objectDumpConfig, logErrors);
            } else {
                this.DumpUserClass(object, variant, currentDepth, objectDumpConfig);
            }
        }
    }

    private void DumpMaxDepth(Object object, Rook.Variant.Builder variant, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig) {
        variant.setVariantType(Rook.Variant.Type.VARIANT_MAX_DEPTH);
    }

    private void DumpBaseObject(Object object, Rook.Variant.Builder variant, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        if (null == object) {
            variant.setOriginalType("null");
            return;
        }
        Class<?> cls = null;
        try {
            cls = object.getClass();
        }
        catch (Throwable e) {
            RookLogger.Instance().log(Level.WARNING, "Failed to get class", e);
            return;
        }
        variant.setOriginalType(cls.toString());
        if (NamespaceSerializer.isPrimitive(cls)) {
            return;
        }
        do {
            Field[] fields;
            for (Field field : fields = cls.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || primitiveClasses.contains(field.getDeclaringClass()) || field.getName().equals("$outer")) continue;
                field.setAccessible(true);
                Rook.Variant.Builder value = Rook.Variant.newBuilder();
                this.DumpJavaObject(field.get(object), value, currentDepth + 1, objectDumpConfig, logErrors);
                Rook.Variant.NamedValue.Builder attribute = Rook.Variant.NamedValue.newBuilder();
                attribute.setName(field.getName());
                attribute.setValue(value);
                variant.addAttributes(attribute);
            }
        } while (null != (cls = cls.getSuperclass()));
    }

    private void DumpArray(Object collection, Rook.Variant.Builder variant, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        variant.setVariantType(Rook.Variant.Type.VARIANT_LIST);
        Rook.Variant.List.Builder list = Rook.Variant.List.newBuilder();
        list.setType(ListNamespace.GetCommonType(collection));
        list.setOriginalSize(Array.getLength(collection));
        if (currentDepth < objectDumpConfig.max_collection_depth) {
            int max_items = Math.min(Array.getLength(collection), objectDumpConfig.max_width);
            for (int i = 0; i < max_items; ++i) {
                Rook.Variant.Builder item = Rook.Variant.newBuilder();
                this.DumpJavaObject(Array.get(collection, i), item, currentDepth + 1, objectDumpConfig, logErrors);
                list.addValues(item);
            }
        }
        variant.setListValue(list);
    }

    private void DumpCollection(Collection collection, Rook.Variant.Builder variant, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        variant.setVariantType(Rook.Variant.Type.VARIANT_LIST);
        Rook.Variant.List.Builder list = Rook.Variant.List.newBuilder();
        list.setType(ListNamespace.GetCommonType(collection));
        list.setOriginalSize(collection.size());
        if (currentDepth < objectDumpConfig.max_collection_depth) {
            Iterator it = collection.iterator();
            for (int index = 0; index < objectDumpConfig.max_width && it.hasNext(); ++index) {
                Rook.Variant.Builder item = Rook.Variant.newBuilder();
                this.DumpJavaObject(it.next(), item, currentDepth + 1, objectDumpConfig, logErrors);
                list.addValues(item);
            }
        }
        variant.setListValue(list);
    }

    private void DumpMap(Map collection, Rook.Variant.Builder variant, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        variant.setVariantType(Rook.Variant.Type.VARIANT_MAP);
        Rook.Variant.Map.Builder map = Rook.Variant.Map.newBuilder();
        map.setOriginalSize(collection.size());
        if (currentDepth < objectDumpConfig.max_collection_depth) {
            int index = 0;
            Iterator it = collection.entrySet().iterator();
            while (index < objectDumpConfig.max_width && it.hasNext()) {
                Map.Entry entry = it.next();
                Rook.Variant.Builder first = Rook.Variant.newBuilder();
                this.DumpJavaObject(entry.getKey(), first, currentDepth + 1, objectDumpConfig, logErrors);
                Rook.Variant.Builder second = Rook.Variant.newBuilder();
                this.DumpJavaObject(entry.getValue(), second, currentDepth + 1, objectDumpConfig, logErrors);
                Rook.Variant.Pair.Builder pair = Rook.Variant.Pair.newBuilder();
                pair.setFirst(first);
                pair.setSecond(second);
                map.addPairs(pair);
            }
        }
        variant.setMapValue(map);
    }

    private void DumpThrowable(Throwable exception, Rook.Variant.Builder variant, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig, boolean logErrors) throws Exception {
        variant.setVariantType(Rook.Variant.Type.VARIANT_OBJECT);
        Rook.Variant.Builder messageValue = Rook.Variant.newBuilder();
        this.DumpJavaObject(exception.getMessage(), messageValue, currentDepth + 1, objectDumpConfig, logErrors);
        Rook.Variant.NamedValue.Builder messageAttribute = Rook.Variant.NamedValue.newBuilder();
        messageAttribute.setName("detailMessage");
        messageAttribute.setValue(messageValue);
        variant.addAttributes(messageAttribute);
        Rook.Variant.Builder causeValue = Rook.Variant.newBuilder();
        Throwable cause = exception.getCause();
        if (cause != exception) {
            this.DumpJavaObject(cause, causeValue, currentDepth + 1, objectDumpConfig, logErrors);
        } else {
            this.DumpJavaObject(null, causeValue, currentDepth + 1, objectDumpConfig, logErrors);
        }
        Rook.Variant.NamedValue.Builder causeAttribute = Rook.Variant.NamedValue.newBuilder();
        causeAttribute.setName("cause");
        causeAttribute.setValue(causeValue);
        variant.addAttributes(causeAttribute);
        Rook.Variant.Builder tracebackValue = Rook.Variant.newBuilder();
        this.DumpJavaObject(exception.getStackTrace(), tracebackValue, currentDepth + 1, objectDumpConfig, logErrors);
        Rook.Variant.NamedValue.Builder tracebackAttribute = Rook.Variant.NamedValue.newBuilder();
        tracebackAttribute.setName("stackTrace");
        tracebackAttribute.setValue(tracebackValue);
        variant.addAttributes(tracebackAttribute);
    }

    private void DumpUserClass(Object exception, Rook.Variant.Builder variant, int currentDepth, JavaObjectNamespace.ObjectDumpConfig objectDumpConfig) {
        variant.setVariantType(Rook.Variant.Type.VARIANT_OBJECT);
    }

    private void DumpListNamespace(ListNamespace namespace, Rook.Variant.Builder variant, boolean logErrors) {
        variant.setVariantType(Rook.Variant.Type.VARIANT_LIST);
        variant.setOriginalType(namespace.originalType);
        Rook.Variant.List.Builder result = Rook.Variant.List.newBuilder();
        result.setType(namespace.commonType);
        result.setOriginalSize(namespace.originalSize);
        Iterator<Namespace> it = namespace.list.iterator();
        while (it.hasNext()) {
            result.addValues(this.Dump(it.next(), logErrors));
        }
        variant.setListValue(result);
    }

    static {
        try {
            Class<?> namespaceSerializerJava8Ext = Class.forName("com.rookout.rook.Processor.NamespaceSerializerJava8Ext");
            java8 = (NamespaceSerializerExt)namespaceSerializerJava8Ext.newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        primitiveClassesList = new Class[]{Integer.class, Long.class, Double.class, Float.class, Character.class, Boolean.class, Byte.class, Short.class, String.class, ArrayList.class, LinkedList.class, CopyOnWriteArrayList.class, Vector.class, HashMap.class, ConcurrentHashMap.class, Hashtable.class, LinkedHashMap.class, TreeMap.class, WeakHashMap.class, Throwable.class, Date.class, Object.class};
        primitiveClasses = new HashSet<Class>(Arrays.asList(primitiveClassesList));
    }
}

