/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Augs.Actions;

import com.rookout.rook.Augs.Actions.Action;
import com.rookout.rook.Output;
import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import com.rookout.rook.Processor.Namespaces.FrameNamespace;
import com.rookout.rook.Processor.Namespaces.JavaUtilsNamespace;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.Processor.Namespaces.StackNamespace;
import com.rookout.rook.Processor.Processor;
import com.rookout.rook.Processor.ProcessorFactory;
import com.rookout.rook.Services.Frame;
import rook.org.json.JSONObject;

public class ActionRunProcessor
implements Action {
    private Processor processor;
    private Processor post_processor;

    public ActionRunProcessor(String arguments, ProcessorFactory processorFactory) {
        this(new JSONObject(arguments), processorFactory);
    }

    public ActionRunProcessor(JSONObject arguments, ProcessorFactory processorFactory) {
        this.processor = processorFactory.getProcessor(arguments.getJSONArray("operations"));
        this.post_processor = arguments.has("post_operations") ? processorFactory.getProcessor(arguments.getJSONArray("post_operations")) : null;
    }

    @Override
    public void Execute(String augId, Frame frame, Namespace extracted, Output output) throws Exception {
        if (null == extracted) {
            extracted = new ContainerNamespace();
        }
        ContainerNamespace store = new ContainerNamespace();
        ContainerNamespace namespace = new ContainerNamespace();
        namespace.WriteAttribute("frame", new FrameNamespace(frame));
        namespace.WriteAttribute("stack", new StackNamespace(frame));
        namespace.WriteAttribute("extracted", extracted);
        namespace.WriteAttribute("store", store);
        namespace.WriteAttribute("temp", new ContainerNamespace());
        namespace.WriteAttribute("utils", new JavaUtilsNamespace());
        this.processor.Process(namespace);
        output.SendUserMessage(augId, store);
        if (null != this.post_processor) {
            output.FlushMessages();
            this.post_processor.Process(namespace);
        }
    }
}

