/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Logging;

import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import com.rookout.rook.Processor.Namespaces.Log4JLogEventNamespace;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Services.Frame;
import com.rookout.rook.Services.Logging.LoggingService;
import com.rookout.rook.Services.StackTrace;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationListener;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Reconfigurable;

class Log4JHandlerFactory {
    private static final String NULL_CONFIGURATION_FACTORY_NAME = "com.rookout.rook.Services.Logging.Log4JHandlerFactory$NullConfigurationFactory";
    private static final String[] SUPPORTED_MAJOR_VERSIONS = new String[]{"log4j-core-2.7", "log4j-core-2.8", "log4j-core-2.9"};
    private static Log4JHandlerFactory instance;
    private boolean active = false;
    private InternalHandlerFactory actualFactory = null;
    private HashMap<String, Log4JHandler> handlers = new HashMap();

    Log4JHandlerFactory() throws Exception {
        if (null != instance) {
            throw new RuntimeException("Cannot start multiple Log4JHandlerFactory instances");
        }
        this.verifyLog4j2VersionSupported();
        instance = this;
        if (null != System.getProperty("log4j.configurationFactory")) {
            RookLogger.Instance().warning("log4j.configurationFactory is in use. Not setting hook ");
            return;
        }
        System.setProperty("log4j.configurationFactory", NULL_CONFIGURATION_FACTORY_NAME);
        this.active = true;
    }

    void close() {
        if (null != this.actualFactory) {
            this.actualFactory.close();
        }
        if (this.active) {
            System.clearProperty("log4j.configurationFactory");
        }
        instance = null;
    }

    Log4JHandler getHandler(String name, LoggingService.Handler handler, boolean ignoreExceptions) {
        if (this.handlers.containsKey(name)) {
            return this.handlers.get(name);
        }
        Log4JHandler log4JHandler = new Log4JHandler(name, handler, ignoreExceptions);
        this.handlers.put(name, log4JHandler);
        if (null != this.actualFactory) {
            this.actualFactory.buildAppender(log4JHandler);
        }
        return log4JHandler;
    }

    void removeHandler(String name) {
        if (this.handlers.containsKey(name)) {
            Log4JHandler log4JHandler = this.handlers.get(name);
            if (null != this.actualFactory) {
                this.actualFactory.removeAppender(log4JHandler);
            }
            this.handlers.remove(name);
        }
    }

    private void verifyLog4j2VersionSupported() throws Exception {
        CodeSource codeSource = AbstractAppender.class.getProtectionDomain().getCodeSource();
        String fileName = Paths.get(codeSource.getLocation().toURI()).getFileName().toString();
        for (String version : SUPPORTED_MAJOR_VERSIONS) {
            if (!fileName.startsWith(version)) continue;
            return;
        }
        throw new RuntimeException("Unsuppported log4j2 version- " + fileName);
    }

    private void buildActualFactory() {
        this.actualFactory = new InternalHandlerFactory();
    }

    class RookoutLog4JAppender
    extends AbstractAppender {
        private LoggingService.Handler handler;

        RookoutLog4JAppender(LoggingService.Handler handler, String name, Filter filter, Layout layout, boolean ignoreExceptions) {
            super(name, filter, layout, ignoreExceptions);
            this.handler = handler;
        }

        public void append(LogEvent event) {
            try {
                Frame frame = this.GetFrame(event);
                ContainerNamespace extracted = new ContainerNamespace();
                try {
                    extracted.WriteAttribute("log_record", new Log4JLogEventNamespace(event));
                }
                catch (Throwable e) {
                    RookLogger.Instance().log(java.util.logging.Level.SEVERE, "Failed to prepare namespaces", e);
                    return;
                }
                this.handler.runAugs(frame, extracted);
            }
            catch (Throwable e) {
                if (e instanceof AssertionError) {
                    throw e;
                }
                RookLogger.Instance().log(java.util.logging.Level.SEVERE, "Error while processing log record", e);
            }
        }

        private Frame GetFrame(LogEvent record) {
            StackTrace stackTrace = new StackTrace(new Throwable());
            stackTrace.baseFrame = 3;
            while (stackTrace.baseFrame < stackTrace.depth && this.isLoggerImplFrame(stackTrace.at(0).getClassName())) {
                ++stackTrace.baseFrame;
            }
            return new Frame(stackTrace, new HashMap<String, Object>());
        }

        private boolean isLoggerImplFrame(String cname) {
            return cname.startsWith("org.apache.logging.log4j");
        }
    }

    private class InternalHandlerFactory {
        private ConfigurationFactory rootFactory = null;
        private ArrayList<ConfigurationInvocationHandler> configurations = new ArrayList();

        InternalHandlerFactory() {
            this.proxyRootFactory();
            this.buildAllAppenders();
        }

        private void close() {
            this.removeProxyRootFactory();
        }

        private void buildAllAppenders() {
            for (Log4JHandler log4JHandler : Log4JHandlerFactory.this.handlers.values()) {
                this.buildAppender(log4JHandler);
            }
        }

        private void buildAppender(Log4JHandler log4JHandler) {
            RookoutLog4JAppender appender = new RookoutLog4JAppender(log4JHandler.loggingHandler, "Rookout Appender - " + log4JHandler.name, null, null, log4JHandler.ignoreExceptions);
            appender.start();
            log4JHandler.appender = (Object)appender;
            for (Object configuration : this.configurations.toArray()) {
                ((ConfigurationInvocationHandler)configuration).registerAppender(log4JHandler.name, (Appender)appender);
            }
        }

        private void removeAppender(Log4JHandler log4JHandler) {
            if (null == log4JHandler.appender) {
                return;
            }
            RookoutLog4JAppender appender = (RookoutLog4JAppender)((Object)log4JHandler.appender);
            for (Object configuration : this.configurations.toArray()) {
                ((ConfigurationInvocationHandler)configuration).removeAppender(log4JHandler.name, (Appender)appender);
            }
            appender.stop();
        }

        private void proxyRootFactory() {
            try {
                Field rootConfigurationFactory = ConfigurationFactory.class.getDeclaredField("configFactory");
                rootConfigurationFactory.setAccessible(true);
                this.rootFactory = (ConfigurationFactory)rootConfigurationFactory.get(null);
            }
            catch (Throwable t) {
                RookLogger.Instance().log(java.util.logging.Level.WARNING, "Failed to integrate with log4j");
                return;
            }
            ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)new ConfigurationFactoryProxy());
        }

        private void removeProxyRootFactory() {
            if (null != this.rootFactory) {
                ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)this.rootFactory);
            }
        }

        private Configuration getConfigurationProxy(Configuration configuration) {
            ConfigurationInvocationHandler invocationHandler = new ConfigurationInvocationHandler(configuration);
            this.configurations.add(invocationHandler);
            return (Configuration)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Configuration.class, Reconfigurable.class}, (InvocationHandler)invocationHandler);
        }

        private class ConfigurationInvocationHandler
        implements InvocationHandler,
        ConfigurationListener {
            private Reconfigurable proxyObject;
            private Configuration configuration;
            private HashSet<ConfigurationListener> listeners = new HashSet();

            private ConfigurationInvocationHandler(Configuration configuration) {
                this.configuration = configuration;
                this.addAllAppendersToLogger();
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("addListener")) {
                    if (null == this.proxyObject) {
                        this.proxyObject = (Reconfigurable)proxy;
                        method.invoke((Object)this.configuration, this);
                    }
                    this.listeners.add((ConfigurationListener)args[0]);
                    return null;
                }
                if (method.getName().equals("removeListener")) {
                    this.listeners.remove((ConfigurationListener)args[0]);
                    if (this.listeners.isEmpty()) {
                        method.invoke((Object)this.configuration, this);
                    }
                    return null;
                }
                if (method.getName().equals("reconfigure")) {
                    if (this.configuration instanceof Reconfigurable) {
                        Configuration newConfiguration = ((Reconfigurable)this.configuration).reconfigure();
                        if (null != newConfiguration) {
                            return InternalHandlerFactory.this.getConfigurationProxy(newConfiguration);
                        }
                    } else {
                        return null;
                    }
                }
                return method.invoke((Object)this.configuration, args);
            }

            void registerAppender(String logger, Appender appender) {
                this.addAppenderToLogger(logger, appender);
                this.notifyListeners();
            }

            void removeAppender(String logger, Appender appender) {
                LoggerConfig config = logger.equals("") ? this.configuration.getRootLogger() : this.configuration.getLoggerConfig(logger);
                config.removeAppender(appender.getName());
                this.notifyListeners();
            }

            public void onChange(Reconfigurable reconfigurable) {
                this.addAllAppendersToLogger();
                for (ConfigurationListener listener : this.listeners) {
                    listener.onChange(this.proxyObject);
                }
            }

            private void addAllAppendersToLogger() {
                for (Map.Entry entry : Log4JHandlerFactory.this.handlers.entrySet()) {
                    this.addAppenderToLogger((String)entry.getKey(), (Appender)((Log4JHandler)entry.getValue()).appender);
                }
            }

            private void addAppenderToLogger(String logger, Appender appender) {
                if (logger.equals("")) {
                    LoggerConfig config = this.configuration.getRootLogger();
                    if (config.getAppenders().containsKey(appender.getName())) {
                        return;
                    }
                    config.addAppender(appender, config.getLevel(), config.getFilter());
                    return;
                }
                LoggerConfig config = (LoggerConfig)this.configuration.getLoggers().get(logger);
                if (null == config) {
                    config = new LoggerConfig(logger, Level.ALL, true);
                    config.addAppender(appender, config.getLevel(), config.getFilter());
                    this.configuration.addLogger(logger, config);
                } else {
                    if (config.getAppenders().containsKey(appender.getName())) {
                        return;
                    }
                    config.addAppender(appender, config.getLevel(), config.getFilter());
                }
            }

            private void notifyListeners() {
                for (ConfigurationListener listener : this.listeners) {
                    if (!(listener instanceof LoggerContext)) continue;
                    ((LoggerContext)listener).updateLoggers();
                }
            }
        }

        private class ConfigurationFactoryProxy
        extends ConfigurationFactory {
            ConfigurationFactoryProxy() {
            }

            public Configuration getConfiguration(LoggerContext loggerContext, String name, URI configLocation) {
                return InternalHandlerFactory.this.getConfigurationProxy(InternalHandlerFactory.this.rootFactory.getConfiguration(loggerContext, name, configLocation));
            }

            public String[] getSupportedTypes() {
                return new String[]{"*"};
            }

            public Configuration getConfiguration(LoggerContext loggerContext, ConfigurationSource source) {
                return InternalHandlerFactory.this.getConfigurationProxy(InternalHandlerFactory.this.rootFactory.getConfiguration(loggerContext, source));
            }
        }
    }

    static class NullConfigurationFactory
    extends ConfigurationFactory {
        NullConfigurationFactory() {
            RookLogger.Instance().log(java.util.logging.Level.INFO, "log4j initializer called");
            if (null != instance) {
                instance.buildActualFactory();
            }
        }

        public Configuration getConfiguration(LoggerContext loggerContext, String name, URI configLocation) {
            return null;
        }

        public String[] getSupportedTypes() {
            return new String[0];
        }

        public Configuration getConfiguration(LoggerContext loggerContext, ConfigurationSource source) {
            return null;
        }
    }

    class Log4JHandler {
        private String name;
        private LoggingService.Handler loggingHandler;
        private boolean ignoreExceptions;
        private Object appender = null;

        Log4JHandler(String name, LoggingService.Handler handler, boolean ignoreExceptions) {
            this.name = name;
            this.loggingHandler = handler;
            this.ignoreExceptions = ignoreExceptions;
        }

        void close() {
            Log4JHandlerFactory.this.removeHandler(this.name);
        }
    }
}

