/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Services.Instrumentation;

import com.rookout.rook.RookLogger;
import com.rookout.rook.Services.Frame;
import com.rookout.rook.Services.Instrumentation.Augs;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.logging.Level;
import rook.org.objectweb.asm.Type;

public class CallbackDispatcher {
    private static CallbackDispatcher instance;
    private static Method pCallback;
    private static Field pInstance;
    final Augs augs;
    static final String CallbackDescriptor;

    static void CreateCallbackDispatcher(Augs augs) {
        if (null != instance) {
            throw new RuntimeException("Cannot create CallbackDispatcher twice");
        }
        instance = new CallbackDispatcher(augs);
    }

    static void Close() {
        instance = null;
    }

    public static void StaticCallback(String fileName, int lineo, HashMap<String, Object> locals) {
        try {
            if (pInstance == null || pCallback == null) {
                return;
            }
            Object instance_value = pInstance.get(null);
            if (instance_value == null) {
                return;
            }
            pCallback.invoke(instance_value, fileName, lineo, locals, new Throwable());
        }
        catch (AssertionError t) {
            throw t;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void Callback(String fileName, int lineno, HashMap<String, Object> locals, Throwable t) throws Throwable {
        try {
            Augs.AugList augList = this.augs.GetAugs(fileName, lineno);
            Frame frame = new Frame(t, locals);
            frame.stackTrace.baseFrame = 1;
            if (null != augList) {
                for (Augs.HashedAug aug : augList) {
                    aug.aug.Execute(frame, null);
                }
            } else {
                RookLogger.Instance().severe("Failed to find aug for id: " + fileName + "@" + lineno);
            }
        }
        catch (Throwable e) {
            if (e instanceof AssertionError) {
                throw e;
            }
            RookLogger.Instance().log(Level.SEVERE, "Error while calling aug", e);
        }
    }

    private CallbackDispatcher(Augs augs) {
        this.augs = augs;
    }

    static {
        try {
            Class<?> pClass = ClassLoader.getSystemClassLoader().loadClass(CallbackDispatcher.class.getName());
            pCallback = pClass.getDeclaredMethod("Callback", String.class, Integer.TYPE, HashMap.class, Throwable.class);
            pCallback.setAccessible(true);
            pInstance = pClass.getDeclaredField("instance");
            pInstance.setAccessible(true);
        }
        catch (Throwable t) {
            pCallback = null;
            pInstance = null;
        }
        CallbackDescriptor = Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(String.class), Type.INT_TYPE, Type.getType(HashMap.class));
    }
}

