/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import rook.com.google.protobuf.Timestamp;

public class Utils {
    static final Pattern COMMAND_LINE_PARSER = Pattern.compile("\"(?:\\\\\"|[^\\\\(?=\")])*\"|[^ \"]+");
    private static final int MILLION = 1000000;

    static String GetExecutalbePath() {
        ArrayList<String> commandLine = Utils.GetCommandLine();
        if (commandLine.size() > 0) {
            return commandLine.get(0);
        }
        return "";
    }

    static ArrayList<String> GetCommandLine() {
        String commnadLine = System.getProperty("sun.java.command");
        if (null == commnadLine) {
            return new ArrayList<String>();
        }
        return Utils.ParseCommandLine(commnadLine);
    }

    static ArrayList<String> ParseCommandLine(String commandLine) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = COMMAND_LINE_PARSER.matcher(commandLine);
        while (matcher.find()) {
            String match = matcher.group();
            String argument = match.replaceAll("\"$", "").replaceAll("^\"", "").replace("\\\"", "\"");
            result.add(argument);
        }
        return result;
    }

    public static byte[] getEntryBytes(JarFile file, ZipEntry entry) throws IOException {
        byte[] a_by = null;
        try (DataInputStream dis = new DataInputStream(file.getInputStream(entry));){
            long lSize = entry.getSize();
            a_by = new byte[(int)lSize];
            dis.readFully(a_by);
        }
        return a_by;
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuffer result = new StringBuffer();
        for (byte b : bytes) {
            result.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }

    public static Timestamp.Builder dateToTimestamp(Date date) {
        long millis = date.getTime();
        return Timestamp.newBuilder().setSeconds(millis / 1000L).setNanos((int)(millis % 1000L) * 1000000);
    }

    public static Boolean IsColdFusionFile(String filePath) {
        return filePath.endsWith(".cfc") || filePath.endsWith(".cfm");
    }
}

