/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook;

import com.rookout.rook.RookOptions;
import com.rookout.rook.Singleton;
import java.lang.instrument.Instrumentation;

public class JavaAgent {
    private static RookOptions opts;

    public static void premain(String agentArgs, Instrumentation instrumentation) throws Exception {
        String disable = System.getenv("ROOKOUT_DISABLE_AUTOSTART");
        if (disable != null && !disable.equals("0")) {
            return;
        }
        opts = RookOptions.deserialize(System.getProperties());
        JavaAgent.opts.reload_classes = true;
        JavaAgent.InitRook(instrumentation);
        Singleton.start();
    }

    public static void agentmain(String agentArgs, Instrumentation instrumentation) {
        opts = RookOptions.deserialize(System.getProperties());
        if (JavaAgent.opts.reload_classes == null) {
            String v = System.getenv("ROOKOUT_DISABLE_CLASS_RELOADING");
            JavaAgent.opts.reload_classes = v != null ? Boolean.valueOf(v.equals("1")) : Boolean.valueOf(true);
        }
        JavaAgent.InitRook(instrumentation);
    }

    private static void InitRook(Instrumentation instrumentation) {
        JavaAgent.loadOptions();
        Singleton.init(opts, instrumentation);
    }

    private static void loadOptions() {
        String v;
        if (JavaAgent.opts.debug == null) {
            v = System.getenv("ROOKOUT_DEBUG");
            JavaAgent.opts.debug = v != null ? Boolean.valueOf(v.equals("1")) : Boolean.valueOf(false);
        }
        if (JavaAgent.opts.log_to_stderr == null && (v = System.getenv("ROOKOUT_LOG_TO_STDERR")) != null) {
            JavaAgent.opts.log_to_stderr = v.equals("1");
        }
        if (JavaAgent.opts.log_file == null && (v = System.getenv("ROOKOUT_LOG_FILE")) != null) {
            JavaAgent.opts.log_file = v;
        }
        if (JavaAgent.opts.log_level == null && (v = System.getenv("ROOKOUT_LOG_LEVEL")) != null) {
            JavaAgent.opts.log_level = v;
        }
        if (JavaAgent.opts.host == null && (v = System.getenv("ROOKOUT_AGENT_HOST")) != null) {
            JavaAgent.opts.host = v;
        }
        if (JavaAgent.opts.port == null && (v = System.getenv("ROOKOUT_AGENT_PORT")) != null) {
            try {
                JavaAgent.opts.port = Integer.parseInt(v);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (JavaAgent.opts.token == null && (v = System.getenv("ROOKOUT_TOKEN")) != null) {
            JavaAgent.opts.token = v;
        }
        if (JavaAgent.opts.tags == null && (v = System.getenv("ROOKOUT_ROOK_TAGS")) != null) {
            JavaAgent.opts.tags = v.split(";");
        }
    }
}

