/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook;

import com.rookout.rook.Config;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Output;
import com.rookout.rook.Processor.Namespaces.ContainerNamespace;
import com.rookout.rook.Processor.Namespaces.JavaObjectNamespace;
import com.rookout.rook.Utils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import rook.io.netty.util.internal.logging.InternalLogger;
import rook.io.netty.util.internal.logging.InternalLoggerFactory;
import rook.io.netty.util.internal.logging.JdkLoggerFactory;

public class RookLogger {
    private static Logger logger;
    private static Output output;

    public static Logger Instance() {
        if (null == logger) {
            logger = RookLogger.buildRookLogger();
            RookLogger.OverrideNettyLogger();
        }
        return logger;
    }

    static void RegisterOutput(Output output) {
        RookLogger.output = output;
    }

    static void RemoveOutput(Output output) {
        output = null;
    }

    private static Logger buildRookLogger() {
        String loggerName = Config.Instance().LoggingConfiguration$LOGGER_NAME;
        Logger logger = null == loggerName ? Logger.getAnonymousLogger() : Logger.getLogger(loggerName, null);
        String level = Config.Instance().LoggingConfiguration$LOG_LEVEL;
        Boolean logToStderr = Config.Instance().LoggingConfiguration$LOG_TO_STDERR;
        if (Utils.GetExecutalbePath().contains("worker.org.gradle.process.internal.worker.GradleWorkerMain")) {
            System.out.println("Rook running in test verbosity");
            level = "DEBUG";
            logToStderr = true;
        }
        logger.setLevel(RookLogger.getLevel(level));
        logger.setUseParentHandlers(Config.Instance().LoggingConfiguration$PROPAGATE_LOGS);
        if (logToStderr.booleanValue()) {
            logger.addHandler(new ConsoleHandler());
        }
        Handler rookHandler = new Handler(){

            @Override
            public void publish(LogRecord record) {
                if (null == output) {
                    return;
                }
                try {
                    ContainerNamespace arguments = new ContainerNamespace();
                    try {
                        Object[] parameters;
                        Throwable e = record.getThrown();
                        if (null != e) {
                            arguments.WriteAttribute("exc", new JavaObjectNamespace(e));
                        }
                        if (null != (parameters = record.getParameters()) && parameters.length > 0) {
                            arguments.WriteAttribute("args", new JavaObjectNamespace(parameters));
                        }
                    }
                    catch (Exceptions.ToolException e) {
                        // empty catch block
                    }
                    String formattedMessage = "";
                    try {
                        formattedMessage = this.getFormatter().formatMessage(record);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    output.SendLogMessage(record.getLevel().intValue(), record.getMillis(), record.getSourceClassName(), record.getSourceMethodName(), record.getMessage(), formattedMessage, arguments);
                }
                catch (Throwable e) {
                    System.out.println("Unexpected error when writing to log");
                    e.printStackTrace();
                }
            }

            @Override
            public void flush() {
                if (null != output) {
                    output.FlushMessages();
                }
            }

            @Override
            public void close() throws SecurityException {
            }
        };
        rookHandler.setFormatter(new SimpleFormatter());
        logger.addHandler(rookHandler);
        if (!"".equals(Config.Instance().LoggingConfiguration$FILE_NAME)) {
            try {
                Path logPath = Paths.get(Config.Instance().LoggingConfiguration$FILE_NAME, new String[0]);
                if (!logPath.isAbsolute()) {
                    String osName = System.getProperty("os.name").toLowerCase();
                    logPath = osName.contains("mac") ? Paths.get(System.getenv("HOME"), Config.Instance().LoggingConfiguration$FILE_NAME) : (osName.contains("win") ? Paths.get(System.getenv("USERPROFILE"), Config.Instance().LoggingConfiguration$FILE_NAME) : Paths.get("/var/log", Config.Instance().LoggingConfiguration$FILE_NAME));
                }
                if (!Files.exists(logPath.getParent(), new LinkOption[0]) && !logPath.getParent().toFile().mkdirs()) {
                    throw new IOException("Failed to create directory- " + logPath.getParent().toString());
                }
                FileHandler fileHandler = new FileHandler(logPath.toString(), 0xA00000, 4);
                fileHandler.setFormatter(new SimpleFormatter());
                logger.addHandler(fileHandler);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Failed to open log file: " + Config.Instance().LoggingConfiguration$FILE_NAME, e);
            }
        }
        return logger;
    }

    private static void OverrideNettyLogger() {
        InternalLoggerFactory.setDefaultFactory(new JdkLoggerFactory(){

            @Override
            public InternalLogger newInstance(String name) {
                String loggerName = RookLogger.Instance().getName() + ".netty";
                Logger logger = Logger.getLogger(loggerName);
                logger.setLevel(Level.WARNING);
                return super.newInstance(loggerName);
            }
        });
    }

    private static Level getLevel(String levelName) {
        switch (levelName) {
            case "CRITICAL": {
                return Level.SEVERE;
            }
            case "ERROR": {
                return Level.SEVERE;
            }
            case "WARN": 
            case "WARNING": {
                return Level.WARNING;
            }
            case "INFO": {
                return Level.INFO;
            }
            case "DEBUG": {
                return Level.ALL;
            }
        }
        return Level.WARNING;
    }
}

