/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Com;

import com.rookout.rook.AugManager;
import com.rookout.rook.Config;
import com.rookout.rook.Output;
import com.rookout.rook.RookLogger;
import com.rookout.rook.protobuf.AgentManagementServiceGrpc;
import com.rookout.rook.protobuf.Rook;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.net.ssl.SSLException;
import rook.io.grpc.Metadata;
import rook.io.grpc.internal.DnsNameResolverProvider;
import rook.io.grpc.netty.GrpcSslContexts;
import rook.io.grpc.netty.NettyChannelBuilder;
import rook.io.grpc.stub.MetadataUtils;
import rook.io.grpc.stub.StreamObserver;
import rook.io.netty.handler.ssl.SslContextBuilder;
import rook.io.netty.handler.ssl.SslProvider;
import rook.org.json.JSONObject;

public class AgentCom {
    private AugManager augManager;
    private Output output;
    private String agentHost;
    private int agentPort;
    private String token;
    private Metadata metadata = new Metadata();
    private AgentManagementServiceGrpc.AgentManagementServiceStub client = null;
    private int retries = 0;
    private long successfulConnectionAt = 0L;
    private State state = new State();

    public AgentCom(AugManager augManager, Output output, String agentHost, int agentPort, String token) {
        this.augManager = augManager;
        this.output = output;
        this.agentHost = agentHost;
        this.agentPort = agentPort;
        this.token = token;
        if (null != token) {
            this.metadata.put(Metadata.Key.of("rookout-token", Metadata.ASCII_STRING_MARSHALLER), token);
        }
    }

    public void ConnectToAgent() throws Exception {
        this.BuildClient();
        this.state.addObserver(new Observer(){
            Timer timer = new Timer("rookout_timer", true);

            @Override
            public void update(Observable o, Object arg) {
                if (StateValue.ERROR == AgentCom.this.state.get()) {
                    long delay = 0L;
                    if (AgentCom.this.retries > 0) {
                        Config config = Config.Instance();
                        double backoff = Math.min(config.AgentComConfiguration$BACK_OFF * Math.pow(2.0, AgentCom.this.retries - 1), config.AgentComConfiguration$MAX_SLEEP);
                        delay = (long)(backoff * 1000.0);
                        RookLogger.Instance().fine("Sleeping for- " + delay + "ms");
                    }
                    ++AgentCom.this.retries;
                    this.timer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            AgentCom.this.StartNewConnection();
                        }
                    }, delay);
                } else if (StateValue.CONNECTED == AgentCom.this.state.get()) {
                    AgentCom.this.successfulConnectionAt = System.currentTimeMillis();
                    final long MaxSleepMs = (long)(Config.Instance().AgentComConfiguration$MAX_SLEEP * 1000.0);
                    this.timer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            if (AgentCom.this.state.get() == StateValue.CONNECTED && System.currentTimeMillis() > AgentCom.this.successfulConnectionAt + MaxSleepMs) {
                                AgentCom.this.retries = 0;
                            }
                        }
                    }, (long)((double)MaxSleepMs * 1.1));
                }
            }
        });
        final CountDownLatch latch = new CountDownLatch(1);
        Observer observer = new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                latch.countDown();
            }
        };
        this.state.addObserver(observer);
        this.StartNewConnection();
        if (!latch.await(Config.Instance().AgentCom$GRPC_TIMEOUT.intValue(), TimeUnit.SECONDS)) {
            RookLogger.Instance().warning("Timeout while syncing with agent");
            this.state.set(StateValue.ERROR);
        }
        this.state.deleteObserver(observer);
        if (StateValue.ERROR == this.state.get()) {
            throw new IOException("Failed to connect to agent. Will keep trying");
        }
    }

    public void SendRookMessages(Rook.RookMessages messages) {
        final CountDownLatch latch = new CountDownLatch(1);
        ((AgentManagementServiceGrpc.AgentManagementServiceStub)this.client.withDeadlineAfter(Config.Instance().AgentCom$SEND_ROOK_MESSAGES_TIMEOUT.intValue(), TimeUnit.SECONDS)).sendMessages(messages, new StreamObserver<Rook.RpcReturnCode>(){

            @Override
            public void onNext(Rook.RpcReturnCode value) {
            }

            @Override
            public void onError(Throwable t) {
                latch.countDown();
                RookLogger.Instance().log(Level.SEVERE, "Failed to send messages", t);
            }

            @Override
            public void onCompleted() {
                latch.countDown();
            }
        });
        try {
            latch.await(Config.Instance().AgentCom$SEND_ROOK_MESSAGES_TIMEOUT.intValue(), TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void BuildClient() throws SSLException {
        if (null != this.client) {
            return;
        }
        RookLogger.Instance().info("Connecting to agent-\t" + this.agentHost);
        NettyChannelBuilder channel = ((NettyChannelBuilder)NettyChannelBuilder.forAddress(this.agentHost, this.agentPort).nameResolverFactory(new DnsNameResolverProvider())).keepAliveTime(2L, TimeUnit.MINUTES).keepAliveTimeout(2500L, TimeUnit.MILLISECONDS).keepAliveWithoutCalls(true);
        if (this.token == null) {
            channel.usePlaintext(true);
        } else {
            channel.sslContext(GrpcSslContexts.configure(SslContextBuilder.forClient(), SslProvider.OPENSSL).build());
        }
        this.client = (AgentManagementServiceGrpc.AgentManagementServiceStub)MetadataUtils.attachHeaders(AgentManagementServiceGrpc.newStub(channel.build()).withMaxOutboundMessageSize(Config.Instance().AgentCom$MAX_MESSAGE_LENGTH), this.metadata);
    }

    private void StartNewConnection() {
        Rook.PingMessage.Builder ping = Rook.PingMessage.newBuilder();
        ping.setValue(1);
        ((AgentManagementServiceGrpc.AgentManagementServiceStub)this.client.withDeadlineAfter(Config.Instance().AgentCom$GRPC_TIMEOUT.intValue(), TimeUnit.SECONDS)).ping(ping.build(), new StreamObserver<Rook.PingMessage>(){

            @Override
            public void onNext(Rook.PingMessage value) {
            }

            @Override
            public void onError(Throwable t) {
                Level level = Level.SEVERE;
                if (AgentCom.this.retries > 0) {
                    level = Level.INFO;
                }
                RookLogger.Instance().log(level, "Error on gRPC ping connection-", t);
                AgentCom.this.state.set(StateValue.ERROR);
            }

            @Override
            public void onCompleted() {
                RookLogger.Instance().info("Successfully connected to agent");
                AgentCom.this.client.newRookNotification(AgentCom.this.output.GetRookInfo(), new StreamObserver<Rook.RookCommand>(){

                    @Override
                    public void onNext(Rook.RookCommand command) {
                        switch (command.getCommandType()) {
                            case COMMAND_ADD_AUG: {
                                RookLogger.Instance().info("Got an add aug command");
                                try {
                                    AgentCom.this.augManager.AddAug(new JSONObject(command.getAugJson()));
                                }
                                catch (Throwable e) {
                                    RookLogger.Instance().log(Level.SEVERE, "Error processing new aug", e);
                                }
                                break;
                            }
                            case COMMAND_REMOVE_AUG: {
                                RookLogger.Instance().info("Got a remove aug command");
                                try {
                                    AgentCom.this.augManager.RemoveAug(command.getAugId());
                                }
                                catch (Throwable e) {
                                    RookLogger.Instance().log(Level.SEVERE, "Error removing aug", e);
                                }
                                break;
                            }
                            case COMAND_INIT_FINISHED: {
                                RookLogger.Instance().info("Finished initialization");
                                try {
                                    AgentCom.this.output.StartSendingMessages();
                                }
                                catch (Throwable e) {
                                    RookLogger.Instance().log(Level.SEVERE, "Error initiating output", e);
                                }
                                AgentCom.this.state.set(StateValue.CONNECTED);
                                break;
                            }
                            case COMMAND_CLEAR_AUGS: {
                                RookLogger.Instance().info("Got clear augs command");
                                try {
                                    AgentCom.this.augManager.ClearAugs();
                                }
                                catch (Throwable e) {
                                    RookLogger.Instance().log(Level.SEVERE, "Error clearing augs", e);
                                }
                                break;
                            }
                            case COMMAND_SET_ROOK_ID: {
                                RookLogger.Instance().info("Got set rook_id command- " + command.getRookId());
                                try {
                                    AgentCom.this.output.setRookId(command.getRookId());
                                }
                                catch (Throwable e) {
                                    RookLogger.Instance().log(Level.SEVERE, "Error setting id", e);
                                }
                                break;
                            }
                            default: {
                                RookLogger.Instance().severe("Unknown command- " + command.getCommandType());
                            }
                        }
                    }

                    @Override
                    public void onError(Throwable t) {
                        AgentCom.this.output.StopSendingMessages();
                        Level level = Level.SEVERE;
                        if (AgentCom.this.retries > 0) {
                            level = Level.INFO;
                        }
                        RookLogger.Instance().log(level, "Error on gRPC connection-", t);
                        AgentCom.this.state.set(StateValue.ERROR);
                    }

                    @Override
                    public void onCompleted() {
                        AgentCom.this.output.StopSendingMessages();
                        RookLogger.Instance().log(Level.SEVERE, "onCompleted called!!");
                        AgentCom.this.state.set(StateValue.ERROR);
                    }
                });
            }
        });
    }

    class State
    extends Observable {
        private StateValue value = StateValue.UNSET;

        State() {
        }

        void set(StateValue value) {
            this.value = value;
            this.setChanged();
            this.notifyObservers();
        }

        StateValue get() {
            return this.value;
        }
    }

    static enum StateValue {
        UNSET,
        CONNECTED,
        ERROR;

    }
}

