/*
 * Decompiled with CFR 0.152.
 */
package rook.com.google.protobuf;

import java.io.IOException;
import java.util.Date;
import java.util.Queue;
import rook.com.google.protobuf.AllocatedBuffer;
import rook.com.google.protobuf.BufferAllocator;
import rook.com.google.protobuf.MapEntryLite;
import rook.com.google.protobuf.RookoutBinaryWriter;
import rook.com.google.protobuf.Timestamp;
import rook.com.google.protobuf.WireFormat;
import rook.com.google.protobuf.util.Timestamps;

public class RookoutUtils {
    public static final MapEntryLite.Metadata mapMetaData = new MapEntryLite.Metadata<String, Integer>(WireFormat.FieldType.STRING, "", WireFormat.FieldType.INT32, 0);

    public static RookoutBinaryWriter GetBinaryWriter() {
        return RookoutBinaryWriter.newHeapInstance(BufferAllocator.unpooled(), 32768);
    }

    public static RookoutBinaryWriter GetBinaryWriter(int chunkSize) {
        return RookoutBinaryWriter.newHeapInstance(BufferAllocator.unpooled(), chunkSize);
    }

    public static byte[] BinaryWriterToArray(RookoutBinaryWriter writer) {
        Queue<AllocatedBuffer> buffers = writer.complete();
        byte[] result = new byte[writer.getTotalBytesWritten()];
        int writeHead = 0;
        for (AllocatedBuffer buffer : buffers) {
            writeHead += RookoutUtils.UnwindAllocatedBuffer(buffer, result, writeHead);
        }
        return result;
    }

    public static void CopyBinaryWriterToArray(RookoutBinaryWriter writer, byte[] target, int offset) {
        Queue<AllocatedBuffer> buffers = writer.complete();
        for (AllocatedBuffer buffer : buffers) {
            offset += RookoutUtils.UnwindAllocatedBuffer(buffer, target, offset);
        }
    }

    static int UnwindAllocatedBuffer(AllocatedBuffer src, byte[] target, int writeHead) {
        int size = src.limit() - src.position();
        byte[] rawSrc = src.array();
        for (int i = 0; i < size; ++i) {
            target[writeHead + i] = rawSrc[src.position() + i];
        }
        return size;
    }

    public static void writeMessageByEncoder(RookoutBinaryWriter writer, int fieldNumber, Encoder encoder) throws IOException {
        int prevBytes = writer.getTotalBytesWritten();
        encoder.writeTo(writer);
        int length = writer.getTotalBytesWritten() - prevBytes;
        writer.requireSpace(10);
        writer.writeVarint32(length);
        writer.writeTag(fieldNumber, 2);
    }

    public static Timestamp dateToTimestamp(Date date) {
        return Timestamps.fromMillis(date.getTime());
    }

    public static interface Encoder {
        public void writeTo(RookoutBinaryWriter var1) throws IOException;
    }
}

