/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook;

import com.rookout.rook.Config;
import com.rookout.rook.Exceptions;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Services.Instrumentation.InstrumentationService;
import com.rookout.rook.Services.Logging.LoggingService;
import com.rookout.rook.Services.Monitor.MonitorService;
import java.util.logging.Level;

public class TriggerServices {
    private InstrumentationService instrumentation;
    private LoggingService loggingService;

    public TriggerServices() {
        if (Config.Instance().LiveTail$Enable.booleanValue()) {
            try {
                this.loggingService = LoggingService.Build();
                RookLogger.Instance().log(Level.INFO, "Initiated LoggingService");
            }
            catch (Throwable e) {
                RookLogger.Instance().log(Level.SEVERE, "Error in initiating LoggingService", e, new Object[0]);
            }
        }
        if (Config.Instance().MonitorConfiguration$ENABLED) {
            MonitorService.Start();
        }
        try {
            this.instrumentation = InstrumentationService.Build();
        }
        catch (Throwable e) {
            RookLogger.Instance().log(Level.SEVERE, "Error in initiating InstrumentationService", e, new Object[0]);
        }
    }

    public InstrumentationService getInstrumentation() throws Exception {
        if (null != this.instrumentation) {
            return this.instrumentation;
        }
        throw new Exceptions.RookInstrumentationUnavailable();
    }

    public LoggingService getLoggingService() throws Exception {
        if (null != this.loggingService) {
            return this.loggingService;
        }
        throw new Exceptions.RookLoggingServiceUnavailable();
    }

    public void RemoveAug(String augId) {
        if (null != this.instrumentation) {
            this.instrumentation.RemoveAug(augId);
        }
        if (null != this.loggingService) {
            this.loggingService.RemoveAug(augId);
        }
    }

    public void ClearAugs() {
        if (null != this.instrumentation) {
            this.instrumentation.ClearAugs();
        }
        if (null != this.loggingService) {
            this.loggingService.ClearAugs();
        }
    }

    public void Close() {
        this.ClearAugs();
        if (null != this.instrumentation) {
            this.instrumentation.Close();
        }
        if (null != this.loggingService) {
            this.loggingService.Close();
        }
        MonitorService.Stop();
    }
}

