/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Processor.Namespaces;

import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.Namespaces.JavaObjectNamespace;
import com.rookout.rook.Processor.Namespaces.Namespace;
import java.util.List;
import java.util.Set;

public class ListNamespace
extends Namespace {
    public List<Namespace> list;
    public String commonType;
    public String originalType;
    public int originalSize;

    public ListNamespace(List<Namespace> list) {
        this.list = list;
        this.commonType = ListNamespace.GetCommonType(this.list);
        this.originalSize = this.list.size();
        this.originalType = this.list.getClass().getName();
    }

    @Override
    public Namespace CallMethod(String name, String args) throws Exceptions.ToolException {
        switch (name) {
            case "size": {
                return new JavaObjectNamespace(this.list.size());
            }
            case "original_size": {
                return new JavaObjectNamespace(this.list.size());
            }
            case "type": {
                return new JavaObjectNamespace(this.originalType);
            }
        }
        return super.CallMethod(name, args);
    }

    public static String GetCommonType(Object object) {
        if (object.getClass().isArray()) {
            return "array";
        }
        if (object instanceof Set) {
            return "set";
        }
        if (object instanceof List) {
            return "list";
        }
        return "list_unknown";
    }

    @Override
    public Namespace ReadKey(Object key) throws Exceptions.ToolException {
        if (!(key instanceof Integer)) {
            throw new Exceptions.RookInvalidKeyType(key, "Integer");
        }
        int index = (Integer)key;
        if (index >= this.list.size()) {
            throw new Exceptions.RookKeyNotFound(key);
        }
        return this.list.get((Integer)key);
    }
}

