/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Processor;

import com.rookout.org.apache.commons.lang3.ArrayUtils;
import com.rookout.rook.Processor.NamespaceSerializerExt;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class NamespaceSerializerBase {
    protected static NamespaceSerializerExt java8 = null;
    private static final String[] otherStrings;
    protected static final Set<String> otherStringsList;
    protected static final Class[] primitiveClassesList;
    protected static final Set<Class> primitiveClasses;
    protected static final String[] extensionPrimitiveClassesList;
    protected static final Set<String> extensionPrimitiveClasses;
    protected HashMap<String, Integer> stringCache;
    protected boolean useStringCache;
    protected int estimatedPendingBytes = 0;

    protected static boolean isPrimitive(Class cls) {
        return primitiveClasses.contains(cls) || null != java8 && java8.isPrimitive(cls) || extensionPrimitiveClasses.contains(cls.getName());
    }

    public NamespaceSerializerBase(boolean useStringCache) {
        this.useStringCache = useStringCache;
        this.stringCache = new HashMap();
        if (useStringCache) {
            this.stringCache.put("", 0);
        }
    }

    public HashMap<String, Integer> getStringCache() {
        return this.stringCache;
    }

    public int getEstimatedPendingBytes() {
        return this.estimatedPendingBytes;
    }

    protected static isListOfCharsOptions isListOfChars(Object object) {
        if (!(object instanceof List) || ((List)object).isEmpty()) {
            return isListOfCharsOptions.FALSE;
        }
        try {
            ListIterator itr = ((List)object).listIterator();
            if (itr.next() instanceof Character) {
                return isListOfCharsOptions.TRUE;
            }
        }
        catch (ConcurrentModificationException exc) {
            return isListOfCharsOptions.CONCURRENTLY_MODIFIED;
        }
        catch (Throwable t) {
            return isListOfCharsOptions.FALSE;
        }
        return isListOfCharsOptions.FALSE;
    }

    public static Object castStringObject(Object object) {
        if (!(object instanceof String)) {
            if (object instanceof char[]) {
                object = new String((char[])object);
            } else if (object instanceof Character[]) {
                object = new String(ArrayUtils.toPrimitive((Character[])object));
            } else if (object instanceof List) {
                StringBuilder sb = new StringBuilder();
                try {
                    for (Character ch : (List)object) {
                        sb.append(ch);
                    }
                    object = sb.toString();
                }
                catch (Exception e) {
                    object = "Failed to process list";
                }
            } else {
                object = object.toString();
            }
        }
        return object;
    }

    protected static boolean setAccessible(Field field, boolean newState) {
        if (newState != field.isAccessible()) {
            try {
                field.setAccessible(newState);
            }
            catch (Throwable ex) {
                return false;
            }
        }
        return true;
    }

    protected int GetStringIndexInCache(String str) {
        if (this.stringCache.containsKey(str)) {
            return this.stringCache.get(str);
        }
        this.estimatedPendingBytes += str.length() + 5;
        int currentSize = this.stringCache.size();
        this.stringCache.put(str, currentSize);
        return currentSize;
    }

    static {
        try {
            Class<?> namespaceSerializerJava8Ext = Class.forName("com.rookout.rook.Processor.NamespaceSerializerJava8Ext");
            java8 = (NamespaceSerializerExt)namespaceSerializerJava8Ext.newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        otherStrings = new String[]{"clojure.lang.Keyword", "clojure.lang.Symbol"};
        otherStringsList = new HashSet<String>(Arrays.asList(otherStrings));
        primitiveClassesList = new Class[]{Integer.class, Long.class, Double.class, Float.class, Character.class, Boolean.class, Byte.class, Short.class, String.class, ArrayList.class, LinkedList.class, CopyOnWriteArrayList.class, Vector.class, HashMap.class, ConcurrentHashMap.class, Hashtable.class, LinkedHashMap.class, TreeMap.class, WeakHashMap.class, Throwable.class, Date.class, Object.class, Enum.class, HashSet.class};
        primitiveClasses = new HashSet<Class>(Arrays.asList(primitiveClassesList));
        extensionPrimitiveClassesList = new String[]{"clojure.lang.PersistentArrayMap", "clojure.lang.PersistentHashMap", "org.apache.spark.sql.DataFrame", "org.apache.spark.sql.Dataset", "org.apache.spark.sql.Row", "org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema", "org.apache.spark.sql.catalyst.expressions.GenericRow"};
        extensionPrimitiveClasses = new HashSet<String>(Arrays.asList(extensionPrimitiveClassesList));
    }

    protected static enum isListOfCharsOptions {
        TRUE,
        FALSE,
        CONCURRENTLY_MODIFIED;

    }
}

