/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.ComWs;

import com.rookout.rook.ComWs.OutputWs;
import com.rookout.rook.Config;
import com.rookout.rook.Git;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Utils;
import com.rookout.rook.protobuf.AgentInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class Information {
    public static boolean testMode = false;
    public String agentId = "";
    public String version = "";
    public String commit = "";
    public String branch = "";
    public String ipAddr = "";
    public String network = "";
    public String hostName = "";
    public String os = "";
    public String osVersion = "";
    public String distro = "";
    public String arch = "";
    public String platform = "";
    public String platformVersion = "";
    public String platformVariant = "";
    public String scmCommit = "";
    public String origin = "";
    public ArrayList<String[]> sources = new ArrayList();
    public String executable = "";
    public ArrayList<String> commandArguments = new ArrayList();
    public int processId = 0;
    public Map<String, String> labels = new HashMap<String, String>();
    public String[] tags;
    public boolean debug;
    private static String k8s_namespace_default = "unread_default";
    public String k8s_namespace = "k8s_namespace_default";
    private static String k8sNamespaceFileName_default = "/var/run/secrets/kubernetes.io/serviceaccount/namespace";
    private String k8sNamespaceFileName = k8sNamespaceFileName_default;
    public Map<String, String> serverless_info = new HashMap<String, String>();

    public static Information Collect(boolean debug) {
        return Information.Collect(debug, k8sNamespaceFileName_default);
    }

    public static Information Collect(boolean debug, String k8namespaceFile) {
        Information info = new Information();
        info.k8sNamespaceFileName = k8namespaceFile;
        AgentInformation.CollectInto(info, debug);
        return info;
    }

    public static AgentInfo.AgentInformation PackAgentInfo(Information info) {
        AgentInfo.AgentInformation.Builder builder = AgentInfo.AgentInformation.newBuilder();
        builder.setAgentId(info.agentId);
        AgentInfo.VersionInformation.Builder versionInfo = AgentInfo.VersionInformation.newBuilder();
        versionInfo.setVersion(info.version);
        versionInfo.setCommit(info.commit);
        builder.setVersion(versionInfo);
        AgentInfo.NetworkInformation.Builder networkInfo = AgentInfo.NetworkInformation.newBuilder();
        networkInfo.setIpAddr(info.ipAddr);
        networkInfo.setNetwork(info.network);
        builder.setNetwork(networkInfo);
        AgentInfo.SystemInformation.Builder systemInfo = AgentInfo.SystemInformation.newBuilder();
        systemInfo.setHostname(info.hostName);
        systemInfo.setOs(info.os);
        systemInfo.setOsVersion(info.osVersion);
        systemInfo.setDistro(info.distro);
        systemInfo.setArch(info.arch);
        builder.setSystem(systemInfo);
        AgentInfo.PlatformInformation.Builder platformInfo = AgentInfo.PlatformInformation.newBuilder();
        platformInfo.setPlatform(info.platform);
        platformInfo.setVersion(info.platformVersion);
        platformInfo.setVariant(info.platformVariant);
        builder.setPlatform(platformInfo);
        AgentInfo.SCMInformation.Builder scmInfo = AgentInfo.SCMInformation.newBuilder();
        scmInfo.setCommit(info.scmCommit);
        scmInfo.setOrigin(info.origin);
        for (String[] stringArray : info.sources) {
            AgentInfo.SCMInformation.SourceInfo.Builder sourceBuilder = AgentInfo.SCMInformation.SourceInfo.newBuilder();
            sourceBuilder.setRemoteOriginUrl(stringArray[0]);
            sourceBuilder.setCommit(stringArray[1]);
            scmInfo.addSources(sourceBuilder);
        }
        builder.setScm(scmInfo);
        builder.setExecutable(info.executable);
        builder.addAllCommandArguments(info.commandArguments);
        builder.setProcessId(info.processId);
        if (info.debug) {
            info.labels.put("rookout_debug", "on");
            info.labels.put("rookout_branch", info.branch);
        }
        if (!(info.k8s_namespace.equals("") || info.k8s_namespace.equals(k8s_namespace_default) || info.labels.containsKey("k8s_namespace"))) {
            info.labels.put("k8s_namespace", info.k8s_namespace);
        }
        for (Map.Entry entry : info.serverless_info.entrySet()) {
            if (info.labels.containsKey(entry.getKey()) || entry.getValue() == null || ((String)entry.getValue()).length() <= 0) continue;
            info.labels.put((String)entry.getKey(), (String)entry.getValue());
        }
        builder.putAllLabels(info.labels);
        builder.addAllTags(info.tags == null ? new ArrayList() : Arrays.asList(info.tags));
        return builder.build();
    }

    static class AgentInformation {
        AgentInformation() {
        }

        public static void CollectInto(Information info, boolean debug) {
            VersionInformation.CollectInto(info);
            NetworkInformation.CollectInto(info);
            SystemInformation.CollectInto(info);
            PlatformInformation.CollectInto(info);
            SCMInformation.CollectInto(info);
            ClusterInformation.CollectInto(info);
            ServerlessInformation.CollectInto(info);
            info.executable = Utils.GetExecutalbePath();
            info.commandArguments = Utils.GetCommandLine();
            String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();
            String pid = nameOfRunningVM.substring(0, nameOfRunningVM.indexOf(64));
            info.processId = Integer.parseInt(pid);
            info.debug = debug;
        }
    }

    static class ServerlessInformation {
        ServerlessInformation() {
        }

        private static boolean isAWSLambda() {
            return System.getenv("AWS_LAMBDA_FUNCTION_NAME") != null;
        }

        private static boolean isGoogleCloudFunction() {
            return System.getenv("FUNCTION_TARGET") != null && System.getenv("FUNCTION_SIGNATURE_TYPE") != null;
        }

        private static boolean isAzureFunction() {
            return System.getenv("FUNCTIONS_WORKER_RUNTIME") != null && System.getenv("WEBSITE_SITE_NAME") != null;
        }

        public static void CollectInto(Information info) {
            if (ServerlessInformation.isAWSLambda()) {
                info.serverless_info.put("function_name", System.getenv("AWS_LAMBDA_FUNCTION_NAME"));
                info.serverless_info.put("aws_region", System.getenv("AWS_REGION"));
            } else if (ServerlessInformation.isGoogleCloudFunction()) {
                String function_name = System.getenv("FUNCTION_NAME");
                if (function_name == null) {
                    function_name = System.getenv("K_SERVICE");
                }
                info.serverless_info.put("function_name", function_name);
            } else if (ServerlessInformation.isAzureFunction()) {
                info.serverless_info.put("function_name", System.getenv("WEBSITE_SITE_NAME"));
                info.serverless_info.put("azure_region", System.getenv("REGION_NAME"));
            }
        }
    }

    static class ClusterInformation {
        ClusterInformation() {
        }

        public static void CollectInto(Information info) {
            File k8NamespaceFile = new File(info.k8sNamespaceFileName);
            if (!k8NamespaceFile.exists() || k8NamespaceFile.isDirectory()) {
                info.k8s_namespace = "";
                return;
            }
            String k8Namespace = "";
            try {
                FileInputStream is = new FileInputStream(info.k8sNamespaceFileName);
                BufferedReader buf = new BufferedReader(new InputStreamReader(is));
                k8Namespace = buf.readLine();
                buf.close();
            }
            catch (Exception e) {
                k8Namespace = "";
                RookLogger.Instance().log(Level.WARNING, "Failed to read Kubernates namespace information, check that '/var/run/secrets/kubernetes.io/serviceaccount/namespace' is valid");
            }
            info.k8s_namespace = k8Namespace;
        }
    }

    static class PlatformInformation {
        PlatformInformation() {
        }

        public static void CollectInto(Information info) {
            info.platform = "java";
            info.platformVersion = System.getProperty("java.version");
            info.platformVariant = System.getProperty("java.vendor");
        }
    }

    static class VersionInformation {
        VersionInformation() {
        }

        public static void CollectInto(Information info) {
            info.version = Config.Instance().VersionConfiguration$VERSION;
            info.commit = Config.Instance().VersionConfiguration$COMMIT;
            info.branch = Config.Instance().VersionConfiguration$BRANCH;
        }
    }

    static class SystemInformation {
        SystemInformation() {
        }

        public static void CollectInto(Information info) {
            try {
                info.hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (Throwable e) {
                RookLogger.Instance().log(Level.SEVERE, "Failed machine information", e, new Object[0]);
            }
            info.os = System.getProperty("os.name");
            info.osVersion = System.getProperty("os.version");
            info.distro = "";
            info.arch = "";
        }
    }

    static class NetworkInformation {
        NetworkInformation() {
        }

        public static void CollectInto(Information info) {
            try {
                info.ipAddr = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Throwable e) {
                RookLogger.Instance().log(Level.SEVERE, "Failed machine network", e, new Object[0]);
            }
        }
    }

    static class SCMInformation {
        SCMInformation() {
        }

        private static String GetGitRoot() {
            String root = Utils.GetConfigurationString("ROOKOUT_GIT");
            if (root == null || root.isEmpty()) {
                root = Git.FindRoot(new File(".").getAbsolutePath());
            }
            return root;
        }

        private static String getUserCommitFromSCM(String manifestTag) {
            if (testMode) {
                return "";
            }
            String userJarPath = Utils.GetConfigurationString("ROOKOUT_JAR_PATH");
            return OutputWs.GetUserSuppliedValue(manifestTag, userJarPath);
        }

        public static void CollectInto(Information info) {
            String sourcesConfigEnv;
            if (Config.Instance().GitConfiguration$COMMIT != null) {
                info.scmCommit = Config.Instance().GitConfiguration$COMMIT;
            } else {
                info.scmCommit = OutputWs.GetUserSuppliedValue("ROOKOUT_COMMIT", null);
                if (info.scmCommit.isEmpty()) {
                    info.scmCommit = SCMInformation.getUserCommitFromSCM("Rookout-Revision");
                }
                if (info.scmCommit.isEmpty()) {
                    info.scmCommit = Git.GetRevision(SCMInformation.GetGitRoot());
                }
            }
            if (Config.Instance().GitConfiguration$ORIGIN != null) {
                info.origin = Config.Instance().GitConfiguration$ORIGIN;
            } else {
                info.origin = OutputWs.GetUserSuppliedValue("ROOKOUT_REMOTE_ORIGIN", null);
                if (info.origin.isEmpty()) {
                    info.origin = SCMInformation.getUserCommitFromSCM("Rookout-Repository");
                }
                if (info.origin.isEmpty()) {
                    info.origin = Git.GetRemoteOrigin(SCMInformation.GetGitRoot());
                }
            }
            if (!info.origin.isEmpty() && !info.scmCommit.isEmpty()) {
                info.sources.add(new String[]{info.origin, info.scmCommit});
            }
            if ((sourcesConfigEnv = Utils.GetConfigurationString("ROOKOUT_SOURCES")) != null) {
                String[] sourcesConfig;
                for (String s : sourcesConfig = sourcesConfigEnv.split(";")) {
                    if (s.contains("#")) {
                        String[] source = s.split("#");
                        if (source.length != 2) continue;
                        info.sources.add(source);
                        continue;
                    }
                    if (!s.endsWith(".jar") && !s.endsWith(".war") && !s.endsWith(".ear")) continue;
                    String originUrl = OutputWs.getManifestValue("Rookout-Repository", s);
                    String commit = OutputWs.getManifestValue("Rookout-Revision", s);
                    if (originUrl.isEmpty() || commit.isEmpty()) continue;
                    info.sources.add(new String[]{originUrl, commit});
                }
            }
        }
    }
}

