/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Augs;

import com.rookout.rook.Augs.Actions.ActionRunProcessor;
import com.rookout.rook.Augs.Aug;
import com.rookout.rook.Augs.AugRateLimiter;
import com.rookout.rook.Augs.Conditions.Condition;
import com.rookout.rook.Augs.Locations.Location;
import com.rookout.rook.Augs.Locations.LocationFileLine;
import com.rookout.rook.Augs.Locations.LocationLogHandler;
import com.rookout.rook.ComWs.OutputWs;
import com.rookout.rook.Config;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.ProcessorFactory;
import com.rookout.rook.RookLogger;
import com.rookout.rook.Utils;
import java.util.logging.Level;
import rook.org.json.JSONException;
import rook.org.json.JSONObject;

public class AugFactory {
    private final Config config;
    private OutputWs output;
    private ProcessorFactory factory = new ProcessorFactory();

    public AugFactory(OutputWs output) {
        this.output = output;
        this.config = Config.Instance();
    }

    public Location GetAug(String configuration) throws Exceptions.ToolException {
        return this.GetAug(new JSONObject(configuration));
    }

    public Location GetAug(JSONObject configuration) throws Exceptions.ToolException {
        JSONObject jsonObjectLocation;
        String rateLimitsSpec;
        String[] rateLimitsSplit;
        ActionRunProcessor action;
        JSONObject jsonObjectAction;
        String augId;
        try {
            augId = configuration.getString("id");
        }
        catch (Throwable t) {
            throw new Exceptions.RookAugInvalidKey("id", configuration.toString(), t);
        }
        try {
            jsonObjectAction = configuration.getJSONObject("action");
        }
        catch (Throwable t) {
            throw new Exceptions.RookAugInvalidKey("action", configuration.toString(), t);
        }
        try {
            action = new ActionRunProcessor(jsonObjectAction, this.factory);
        }
        catch (Throwable t) {
            throw new Exceptions.RookInvalidObjectConfiguration("", jsonObjectAction.toString(), t);
        }
        long maxAugTime = Utils.MSToNS(this.config.InstrumentationConfig$MAX_AUG_TIME);
        try {
            maxAugTime = Utils.MSToNS(configuration.getLong("maxAugTime"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        maxAugTime = (long)((double)maxAugTime * Config.Instance().AgentComConfiguration$MAX_AUG_TIME_MULTIPLIER.get());
        Condition condition = null;
        try {
            String conditionConfiguration = configuration.getString("conditional");
            condition = new Condition(conditionConfiguration);
        }
        catch (JSONException conditionConfiguration) {
            // empty catch block
        }
        long window_quota = Utils.MSToNS(200L);
        long window_size = Utils.MSToNS(5000L);
        if (configuration.has("rateLimit") && (rateLimitsSplit = (rateLimitsSpec = configuration.getString("rateLimit")).split("/")).length == 2) {
            try {
                window_quota = Utils.MSToNS(Long.parseLong(rateLimitsSplit[0]));
                window_size = Utils.MSToNS(Long.parseLong(rateLimitsSplit[1]));
            }
            catch (NumberFormatException e) {
                RookLogger.Instance().log(Level.SEVERE, "Failed to parse rate limit configuration: ", e, new Object[0]);
            }
        }
        int rateLimitModifier = 0;
        if (configuration.has("rateLimitModifier")) {
            String rateLimitModifierStr = configuration.getString("rateLimitModifier");
            try {
                rateLimitModifier = Integer.parseInt(rateLimitModifierStr);
            }
            catch (NumberFormatException e) {
                RookLogger.Instance().log(Level.SEVERE, "Failed to parse rate limit configuration: ", e, new Object[0]);
            }
        }
        Aug aug = new Aug(augId, action, condition, maxAugTime, new AugRateLimiter(window_quota, window_size, rateLimitModifier));
        try {
            jsonObjectLocation = configuration.getJSONObject("location");
        }
        catch (Throwable t) {
            throw new Exceptions.RookAugInvalidKey("location", configuration.toString(), t);
        }
        return this.getLocation(jsonObjectLocation, aug);
    }

    private Location getLocation(JSONObject configuration, Aug aug) throws Exceptions.ToolException {
        String name;
        try {
            name = configuration.getString("name");
        }
        catch (Throwable t) {
            throw new Exceptions.RookObjectNameMissing(configuration.toString(), t);
        }
        switch (name) {
            case "file_line": {
                try {
                    return new LocationFileLine(configuration, this.factory, this.output, aug);
                }
                catch (Throwable t) {
                    throw new Exceptions.RookInvalidObjectConfiguration(name, configuration.toString(), t);
                }
            }
            case "log_handler": {
                try {
                    return new LocationLogHandler(this.output, aug);
                }
                catch (Throwable t) {
                    throw new Exceptions.RookInvalidObjectConfiguration(name, configuration.toString(), t);
                }
            }
        }
        throw new Exceptions.RookUnsupportedLocation(name);
    }
}

