/*
 * Decompiled with CFR 0.152.
 */
package com.rookout.rook.Augs;

import com.rookout.rook.Augs.Actions.Action;
import com.rookout.rook.Augs.AugNamespace;
import com.rookout.rook.Augs.AugRateLimiter;
import com.rookout.rook.Augs.Conditions.Condition;
import com.rookout.rook.ComWs.OutputWs;
import com.rookout.rook.Exceptions;
import com.rookout.rook.Processor.Namespaces.Namespace;
import com.rookout.rook.Processor.RookError;
import com.rookout.rook.RookLogger;
import com.rookout.rook.UserWarnings;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;

public class Aug {
    public String augId;
    private Action action;
    private AugRateLimiter rateLimiter;
    private long maxAugTime;
    private Condition condition;
    private boolean enabled = true;
    private boolean executed = false;

    public Aug(String augId, Action action) {
        this(augId, action, null, 0L, new AugRateLimiter(0L, 0L, 0));
    }

    public Aug(String augId, Action action, Condition condition, long maxAugTime, AugRateLimiter rateLimiter) {
        this.augId = augId;
        this.action = action;
        this.maxAugTime = maxAugTime;
        this.rateLimiter = rateLimiter;
        this.condition = condition;
    }

    public void Execute(final HashMap<String, Object> locals, final Namespace extracted, final long now, final OutputWs output) {
        if (!this.enabled) {
            return;
        }
        if (output.areUserMessagesFull()) {
            output.SendOutputQueueFullWarning(this.augId);
            return;
        }
        this.rateLimiter.TryWithRateLimit(now, new Runnable(){

            @Override
            public void run() {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            AugNamespace augNamespace = new AugNamespace(locals, extracted);
                            if (Aug.this.condition == null || Aug.this.condition.evaluate(augNamespace.getAugNamespace())) {
                                if (Aug.this.executed) {
                                    RookLogger.Instance().debug("Executing aug - " + Aug.this.augId, new Object[0]);
                                } else {
                                    RookLogger.Instance().info("Executing aug for the first time - " + Aug.this.augId, new Object[0]);
                                    Aug.this.executed = true;
                                }
                                String reportId = UUID.randomUUID().toString().replace("-", "");
                                Aug.this.action.Execute(Aug.this.augId, reportId, augNamespace.getAugNamespace(), output);
                            }
                            long augTime = System.nanoTime() - now;
                            if (Aug.this.maxAugTime > 0L && augTime > Aug.this.maxAugTime) {
                                RookLogger.Instance().log(Level.WARNING, "Removing rule because max execution time was reached - " + Aug.this.augId);
                                Aug.this.enabled = false;
                                UserWarnings.SendError(new RookError(new Exceptions.RookRuleMaxExecutionTimeReached(augTime / 1000000L, Aug.this.maxAugTime / 1000000L)));
                            }
                        }
                        catch (Throwable e) {
                            UserWarnings.SendWarning(new RookError(e, "Exception while processing Aug: " + e.toString()));
                        }
                        return null;
                    }
                });
            }
        });
    }
}

